+++
author = ["authors/neil-weisensel.md"]
categories = "Review"
date = 2019-11-25T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = "Manitoba Opera's production of [_Susannah_](https://mbopera.ca/season/susannah/) is onstage through November 29."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1574713480/media/2019/11/MOSusannahLaraCiekiewiczSusannah_xn8q5l.jpg"
primary_image_credit = "Lara Ciekiewicz in the title role of Susannah, Manitoba Opera, 2019. Photo: R. Tinker."
related_articles = ["articles/party-arias-the-traits-of-lesser-operas.md", "articles/susannah-is-the-great-original-american-opera.md"]
related_companies = ["scene/companies/manitoba-opera.md"]
related_people = ["scene/people/lara-ciekiewicz.md"]
short_description = "I hope that Ciekiewicz gets many more opportunities to sing this role. You won't hear it sung better anywhere, and her outstanding dramatic ability helped us feel the heartbreak of Susannah's anguish and confusion. "
slug = "ciekiewicz-shines-in-the-title-role-of-manitoba-operas-susannah/"
title = "Ciekiewicz shines in the title role of Manitoba Opera's Susannah"
youtube_url = ""

+++
Manitoba Opera's production of Carlisle Floyd's [_Susannah_](https://mbopera.ca/season/susannah/) is a thoughtful and courageous step outside the norms of the "10 most popular operas" that most  companies feel compelled to produce, in order to keep themselves afloat in the dime-squeezing world of presenting mainstage opera. By presenting this 20th-century American masterpiece, Manitoba Opera (MO) is helping lead their audience to discover important repertoire from the vast operatic canon, like Massenet's _Werther_ and Verdi's _Falstaff_ a few years back.

> It's a testament to the talent in this city – and MO's willingness to hire local singers – that the show sounds so good.

Over the course of 60 years, eminent American composer Carlisle Floyd's 12 operas transformed the landscape of American opera. Before him, most operas presented in the US (with the exception of the Gershwins' _Porgy and Bess_) were by European composers, with only three theatres in the entire country staging American works. Now, that has increased to literally hundreds of theatres, all in the life span of one long-lived opera composer. _Susannah_ is his most popular work, still relevant (unfortunately) even though five decades have passed since its premiere in 1955.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1574713506/media/2019/11/MOSusannahNov2019_lenp5y.jpg){{% /md %}}

<figcaption>Manitoba Opera's production of Susannah, 2019. Photo: R. Tinker.</figcaption>  
</figure>

Floyd's music for _Susannah_ is a blend of  melodies, rhythms and textures inspired by Appalachian music. Indeed, the sung English is accented in an Appalachian manner, which makes for a fascinating juxtaposition – "hillbilly"-like accents coupled with grand opera. Floyd's completely original music (that is, not based on external sources) is full of singable melodies and finely-placed dissonances, and functions much like music in a film; helping the listener understand what is going on in a character's head, foreshadowing an upcoming situation, or offering a remembrance of past events.

Manitoba Opera has assembled a fine cast for this production. It's a testament to the talent in this city – and MO's willingness to hire local singers – that the show sounds so good. The chorus, under the direction of long-time Chorus Master Tadeusz Biernacki, sounded fabulous - very engaged with the drama and fun to watch. All the Elders and their wives (David Watson, PJ Buchan, Terence Mierau, Thomas Goerz, Dawn Bruch-Wiens, Shannon Unger, Donnalynn Grills and Naomi Forman) sang beautifully, all the while positively seething with old-school judgement, hypocrisy and bile.

> Floyd's placement of text,  perfect tempos by conductor Tyrone Paterson and clear diction by the entire cast ensured that every word was clearly heard.

As the Rev. Olin Blitch, Kristopher Irmiter's mighty voice matched his outsized stage presence. Even in a chapel full of chorus members vocalizing and gesticulating heavenward, Irmiter's outstanding singing and powerful dramatic authority left no one doubting who is in charge of that church meeting.

Michael Robert Hendrick, as Susannah's wise but flawed older brother Sam Polk, is one of the few characters not caught up in monolithic thinking. Everything that Sam says early on in the show in his talks with Susannah are crystalline nuggets of wisdom, and the siblings' evident mutual love is truly touching.

James McLennan's portrayal of Little Bat McLean, Susannah's loyal friend who ultimately betrays her kindness towards him, was full of nervous energy and sung impeccably, with McLennan's character given the tricky task of narrating parts of the offstage drama. There were a lot of words to be sung – it's a very wordy opera overall – but Floyd's placement of text,  perfect tempos by conductor Tyrone Paterson and clear diction by the entire cast ensured that every word was clearly heard.

> I hope that Ciekiewicz gets many more opportunities to sing this role. You won't hear it sung better anywhere

Soprano [Lara Ciekiewicz](/spotlight-on-lara-ciekiewicz/)'s career seems to be moving from strength to strength. As recent lead roles have shown (as Jenufa at Pacific Opera Victoria and Tatyana in _Eugene Onegin_ at Calgary Opera) Ciekiewicz is now certifiably one of Canada's leading sopranos. How lucky we are to have her in our fair city, and how perfectly the role of Susannah fits her. She is totally believable as a confident young woman struggling with food insecurity in backwoods Tennessee with her brother Sam.

Ciekiewicz's lyrical interpretation of a very challenging score, and her ability to make difficult music sound easy, made her character all the more believable. Also, we don't usually talk about beautiful lyrics when talking about opera (the libretto is usually just a skeleton for the composer to hang their tunes on) but check out these lyrics by Floyd in Susannah's most famous aria, "Ain't It A Pretty Night":

_The sky seems so heavy with stars/ That it might fall right down out of heaven/ And cover us all up in one big blanket of velvet/ All stitched with diamonds._

Here's [Ciekiewicz singing this classic 20th-century aria](https://www.facebook.com/ManitobaOpera/videos/1010981209250458/).

I hope that Ciekiewicz gets many more opportunities to sing this role. You won't hear it sung better anywhere, and her outstanding dramatic ability helped us feel the heartbreak of Susannah's anguish and confusion. When Susannah has nothing left except bitterness and anger, we also sense the difference in Ciekiewicz's posture and energy.

Composer Floyd is an excellent craftsman, and his music serves this story extremely well. Indeed, I wish there had been even more time given to a few of the scene changes – sometimes it seemed to me like one scene had not yet been completed, but the next scene was already being set. This took away a lot of the dramatic power of Floyd's music for me.

> Floyd created, almost single-handedly, a lexicon for American opera.

For example, the scene where Blitch is praying in anguish, and asking for Susannah's (and God's) forgiveness: his final vocalizings are accompanied by a powerful orchestral surge, but before this scene had actually ended, the scenery was changing into the next scene. If felt like a missed opportunity – why not let the scene play out before the next scene starts?

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1574713493/media/2019/11/MOSusannahLaraCiekiewiczSusannahMichaelRobertHendrickSam_z6gfop.jpg){{% /md %}}

<figcaption>Manitoba Opera's production of Susannah, 2019. Photo: R. Tinker.</figcaption>  
</figure>

But this is a minor quibble compared to the overall excellence of this production. This experience has left me pondering the legacy of Maestro Floyd, a giant in the world of American opera, who at 93 is doubtless slowing down. (Although, he did compose a new opera, _Prince of Players_, in 2016!)

Floyd created, almost single-handedly, a lexicon for American opera. During the composition of _Susannah_ in 1954-1955, while McCarthyism was at peak furor in the US, Floyd and his fellow music professors at Florida State University had to sign forms stating they were not, and would never become, communists – and a refusal to do so would mean forfeiting their positions.

These themes subconsciously found their way into the libretto of _Susannah_ (which Floyd created himself, as he did with all his operas) and were [represented](https://www.yourobserver.com/article/interview-american-opera-composer-carlisle-floyd) by the existence of a "monolithic opinion… that everyone was afraid to challenge… which existed because of fear."

Sixty-four years after the creation of this opera, and its powerful message against baseless fear and hatred, it's unfortunate to note that the manipulation of fear/hatred of "the other" by corporations and politicians shows no signs of abating. Much like Sam Polk's wise ruminations in this opera, we need to realize that there is no "them", only "us".