+++
author = ["authors/arturo-fernandez.md"]
categories = "Review"
date = 2020-02-03T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1580661379/media/2020/02/sqMeganPachecano_GilRose_Orchestra_l9jws8.jpg"
primary_image_credit = "February 1, 2020, NEC’s Jordan Hall, Boston. World premiere of The Chronicle of Nine by Arnold Rosner, Boston Modern Orchestra Project and Odyssey Opera conducted by Gil Rose. Photo: Kathy Wittman/Ball Square Films."
related_articles = ["articles/in-review-la-belle-helene.md", "articles/odyssey-operas-giovanna-darco-bold-and-flawed.md", "articles/chemistry-sizzles-onstage-in-paride-ed-elena.md"]
related_companies = ["scene/companies/odyssey-opera.md"]
related_people = []
short_description = "The music, while still adhering to some trappings of the medieval stylings, began to explore outside the bounds of its medieval stylings in order to do something new. The libretto, already full of pathos for its subject, finally found its stride as far as moving the plot at a good clip."
slug = "chronicle-of-nine-a-slow-building-triumph"
title = "Chronicle of Nine a slow-building triumph"
youtube_url = ""

+++
When I was still a student at the College-Conservatory of Music, I had a professor who once told the class that you could not have an opinion on a work of media unless you’ve experienced the work as a whole. Some in media criticism might call such an approach a lazy way out, but it is astounding how much can change about a work as you sit with it and wholly experience it.

This is especially true of opera, where in some cases the whole may not be as interesting as certain parts. This is certainly true of Arnold Rosner’s world premiere opera _The Chronicle of Nine_, his adaptation of Florence Stevenson's play about the life of the lady Jane Grey, who was famously queen for only nine days.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1580661400/media/2020/02/DavidSalsberyFry_JamesDemler_WilliamHite_AaronEngebreth_piquto.jpg){{% /md %}}

<figcaption>February 1, 2020, NEC’s Jordan Hall, Boston. World premiere of The Chronicle of Nine by Arnold Rosner, Boston Modern Orchestra Project and Odyssey Opera conducted by Gil Rose. Photo: Kathy Wittman/Ball Square Films.</figcaption>

</figure>

This posthumous world premiere is a curious creature, in that part of me wishes that Rosner had been around long enough to revise the first act. Something about the first act is a little too slow: I am not sure if it is because the music is too consciously stuck on its medieval stylings, or that the libretto does not quite get to where it needs to be quickly enough, but the pacing is slow, and the first act was rather dull and full of dodgy musical decisions.

And then Act II began, and something shifted in the air. The music, while still adhering to some trappings of the medieval stylings, began to explore outside the bounds of its medieval stylings in order to do something new. The libretto, already full of pathos for its subject, finally found its stride as far as moving the plot at a good clip. These two things were already a marked change, but with the two of them together the work found its dramatic urgency, with the stakes rising as the show went on. Once the opera hits its second act, _Chronicle of Nine_ finds its stride.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1580661414/media/2020/02/GilRose_KristaRiver_MeganPachecano_yk6pzz.jpg){{% /md %}}

<figcaption>February 1, 2020, NEC’s Jordan Hall, Boston. World premiere of The Chronicle of Nine by Arnold Rosner, Boston Modern Orchestra Project and Odyssey Opera conducted by Gil Rose. Photo: Kathy Wittman/Ball Square Films.</figcaption>

</figure>

And what a stride it is! The coronation scene of Act II, something that would be a joyous occasion in any other opera, is hampered by some pretty choice dissonances as Jane Grey begs everyone else on stage not to crown her queen. The following scene sees the Earl of Arundel absolutely steal the show with a set-piece duet with the Earl of Pembroke where he vows revenge on Jane’s family to the menacing sounds of stopped horns and deep double bass notes. Mary, Queen of Scots only shows up in the last act, but when she does, she appears in a confrontation with the Lady Jane that is ingeniously accompanied by only a cello choir, a decision that adds a certain oomph to Mary having to tell Jane that she could not save her from her execution.

And then there is the execution itself, which builds up slowly to its fevered climax through its use of chorus, the searing orchestration. And ultimately, the libretto does a beautiful job setting up Lady Jane as a victim of circumstance that she has no realistic way out of: at the end of the work, I felt an immense pity for her, and it is always the mark of a successful opera when you walk away having such a strong emotional attachment to a character.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1580661430/media/2020/02/MeganPachecano_2_cyasj9.jpg){{% /md %}}

<figcaption>February 1, 2020, NEC’s Jordan Hall, Boston. World premiere of The Chronicle of Nine by Arnold Rosner, Boston Modern Orchestra Project and Odyssey Opera conducted by Gil Rose. Photo: Kathy Wittman/Ball Square Films.</figcaption>

</figure>

This was admittedly helped a lot by the incredibly strong cast of singers, but I am certain they are glad they had lots of good material to work with. Megan Pachecano was absolutely radiant as the lady Jane Grey: her voice had a clarity of tone that provided an innocence to the character, and she was also a great actor who shifted her voice to the needs of her text and let her facial expressions act where her voice could not.

James Demler absolutely stole the show in his big setpiece duet, using the full roar of his voice to turn what was already an intense duet into a truly unforgettable moment. Stephanie Kacoyanis did not have very much time to leave an impression as Lady Mary, but she made the most of it, providing a great sense of regret to the character that only brings the unfairness of Jane’s situation into sharper relief than before. The rest of the cast offered strong performances as well, with David Salsbery Fry as the Earl of Pembroke and William Hite as Henry Grey, and Gene Stenger as the show’s framing device minstrel standing out amongst the rest of the cast.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1580661447/media/2020/02/MeganPachecano_EricCarey_nopw2h.jpg){{% /md %}}

<figcaption>February 1, 2020, NEC’s Jordan Hall, Boston. World premiere of The Chronicle of Nine by Arnold Rosner, Boston Modern Orchestra Project and Odyssey Opera conducted by Gil Rose. Photo: Kathy Wittman/Ball Square Films.</figcaption>

</figure>

The remaining forces of the ensemble were also fantastic, which is to be expected when the Boston Modern Orchestra Project collaborates with Odyssey Opera. The orchestral playing was rather excellent, bringing out the colors of Rosner’s score even despite the occasional hiccup with balances in the brass. The chorus work was also quite outstanding, even if they were not quite powerful enough to project over Rosner’s sometimes thick orchestration during the choral segments.

To be sure, there are still aspects even beyond the second act that are not so great: the vocal writing has a tendency to stay in places that don’t project well over the orchestration, and there are some instances of strange prosody. But when the work finds its stride come Act II, it hits dramatic highs that most recent opera has trouble hitting. It is a worthy addition to the Odyssey Opera season, and I have the feeling it will have a very strong afterlife after this performance.