+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2015-11-04T09:18:00-05:00"
lastmod = "2015-11-06T09:14:00-05:00"
preamble = "Canadian-born tenor Chris Lysack brings a lot to the table when he takes on roles like Florestan (*Fidelio*), Walther von Stolzing in *Die Meistersinger von Nürnberg*, and the Prince in *Rusalka*. He studied voice at the [Manhattan School of Music](/scene/companies/manhattan-school-of-music/), after he earned a Doctor of Music as a pianist, and a PhD in French literature, both from Indiana University. \n\nChris is between performances of two concurrent roles, Cavaradossi in [Theater Aachen](http://www.theateraachen.de/index.php?page=detail_event&id_event_date=13493362)'s production of *Tosca*, and his very first Peter Grimes at [Theater Bremen](http://www.theaterbremen.de/de_DE/kalender/peter-grimes.13254405). In thoughtful, eloquent interview, Chris talks about wearing singer hats and pianist hats, working across the pond, and the tough love that comes with this career."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1446656286830/2015-11-04---Chris-Lysack---Square.jpg.jpg"
primary_image_credit = "Photo: Rebecca Fay Photography"
publishDate = "2015-11-06T08:00:00-05:00"
related_people = ["scene/people/chris-lysack.md"]
short_description = "Canadian-born tenor Chris Lysack brings a lot to the table when he takes on roles like Florestan (Fidelio), Walther von Stolzing in Die Meistersinger von Nürnberg, and the Prince in Rusalka. He studied voice at the Manhattan School of Music, after he earned a Doctor of Music as a pianist, and a PhD in French literature, both from Indiana University."
slug = "chris-lysack-on-singing-its-naked"
title = "Chris Lysack, on singing: &quot;It’s naked.&quot;"
+++

## 1. What sort of balance exists for you between singing, piano, and your passion for literature? How often do they cross over?

There’s plenty of crossover, even if it’s in ways you don’t expect until they’re upon you. I first started studying literature seriously because I thought it would make me a better pianist, and my logic was as follows—first learn another canon in another art form (any art form would be useful, as far as I was concerned, but I happened upon French literature almost by chance), then learn how artists in that other discipline deal with the idiosyncratic rhetorical challenges of poetry, and finally map them onto my analogous communicative goals as a pianist, maybe even gaining some passing familiarity with the specific texts that so influenced specific composers. 

However, when I switched to singing, all of these connections became more concrete. Now as a singing actor, I get to deal directly with specific texts, with explicit communicative and rhetorical goals, and am able to, in effect, do my own dramaturgical preparation before I go to rehearsal. At least that’s the theory. 

As for piano playing, I sadly don’t get to do as much of that as I’d like, but it’s always fun to do the occasional chamber-music performance, or to accompany myself in some jazz standard or whatnot. And of course, having that background in piano 
probably makes it easier to learn new roles. 

Sometimes the two worlds collide unexpectedly. For example in January of this year, due to some unresolvable scheduling issues, I had a trio performance as a pianist with the concertmaster and one of the cellists from the Hamburg Philharmonic—and it was a big program, too, with trios by Beethoven, Schumann, and Tchaikovsky—and then two hours later, about 125 km away, was in makeup to sing my last Walther von Stolzing in *Die 
Meistersinger von Nürnberg* in Bremen. I actually posted that whole day’s happenings using the hashtag #ThisDayIsEvenLongerThanAGermanNoun. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1446671779373/2015-11-04---LysackJenufa.jpg.jpg)<figcaption>Chris Lysack in *Jenůfa*, Theater Aachen, 2015. Photo: Carl Brunn.</figcaption>
</figure>

## 2. How did you discover that your voice fit this exciting repertoire?

Quite by accident. I had sung semi-seriously in my late teens (once upon a time, my 
real ambition was to do Broadway, but that’s another story), but my body hadn’t 
settled down and I was a spectacularly uninspiring baritone back in an age when Jean Chrétien was Prime Minister and the Stanley Cup was in seemingly perpetual transit between Detroit, Denver, and New Jersey. I spent several years working as an accompanist and coach however, and so was somewhat familiar with the rep and found that it was very easy for me to demonstrate what I was looking for. Don’t get me wrong — some of the sounds I was making were downright embarrassing. But given that I was "just a pianist," the high notes were surprisingly easy. 

Then when I was about 27, a wonderful colleague of mine, Chris Crans (who is now at the Nationaltheater Mannheim), convinced me to try singing more seriously. And in public. He put me in touch with my first teacher, Andreas Poulimenos at Indiana University, and then later with Patricia McCaffrey at Manhattan School of Music, and they agreed that I could and would do this bigger rep. 

## 3. How does singing Britten, and his characters, compare to Puccini, Wagner, and others in your rep?

Now you’re trying to get me in trouble. 

[Peter Grimes] is my first serious Britten role. I sang Macheath (in *The Beggar’s Opera*) back in grad school, but one could make the argument that that’s only half-Britten, and therefore doesn’t really count as representative. And I was second-tights-clad-gentleman-from-the-left in *Gloriana* in Hamburg, but again, I’m not really sure that counts as a real role. 

When you’re at a cocktail party, chattering about the respective strengths of this or that composer, because I’m told that’s a thing that people do on the weekends, the thing you’re “supposed to say” about Britten is the same thing that you’re supposed to say about Janáček: it’s all about the text-setting. But you know how sometimes you’ve heard about a thing all your life, so then when you finally experience it first-hand, it just seems banal? In a sense, finally singing Laca Klemeň (in *Jenůfa*) then Peter Grimes were two of those rare moments in my life when the experience has lived up to the advertising; I don’t know what I could add to that appraisal. From beginning to end, those pieces are simply...right. 

All of these composers (Britten, Wagner, Puccini, and Janáček) were primarily opera composers and knew how to set their own language far better than I ever will, but to me—and this is just a gut reaction—Britten and Janáček are in their own special category. They are setting the drama for the stage, rather than writing music (albeit transcendent music) that happens to include text and action. You get to wear your heart on your sleeve in Puccini, exult in the majesty of Wagner for hours on end, but in Britten and Janáček, I feel like an actor, rather than a singer. You simply get to be and to do and to lose yourself in the piece, rather than in the music.

And then, speaking of musical transcendence, let’s not forget *Fidelio*.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1446672046873/2015-11-04---LysackRusalka.jpg.jpg)<figcaption>Chris Lysack in *Rusalka*, Theater Aachen, 2013. Photo: Ludwig Koerfer.</figcaption>
</figure>

## 4. As a Canadian singer abroad, what advice do you have for young singers in North America hoping to gain work in Europe?

What’s that line about advice as autobiography? Of course it’s natural for me simply to describe my own past and label it “advice.” So with that caveat, I’ll start with the obvious. I got here as a member of a Young Artist program, which seems to be becoming more and more the “normal” way for people to start their careers here. And it was a fantastic time; the wonderful people at the Hamburg State Opera gave me the opportunity to cut my teeth on a wide range of pieces, and with no shortage of stage time (I did well over 100 performances during my two years in the studio).  

But I suppose that my more general advice is to accept up front that this is a very tough business, where the competition is stiff, and the careers are, in general, short. And by that, I mean that even in cases that are unambiguously successful careers, chances are good that you’ll be doing something different in ten or fifteen years. 

With that in mind, I think it extremely important to find in every operatic opportunity the concomitant opportunity to invest in yourself and your own human capital. This is even true — or maybe even especially true — in those jobs that we are otherwise tempted to dismiss as “putting in your time” or “paying your dues.” I would recommend finding whatever opportunities you can to turn any engagement, audition tour, visit to Europe, etc., into an experience that you will consider enriching on its own terms, regardless of whether it leads to more work.

To that end, I’d advise any North American opera singer in Europe to take advantage of the opportunity to learn a new skill or a new language, or simply to add to your breadth of experience that will come in handy down the road. Take a class part-time at the local university. Do a language course or two. I’ve known performers to try their hand at administrative positions, even on a part-time basis. Of course, you want to be careful not to send the message that you’re undecided about your singing, or that you’re a dilettante, or worst of all, that you’re “NOT SERIOUS,” but it should be simple enough to defend that cool-hobby-that-makes-me-an-interesting-singer. And chances are, it actually will make you a better, more well-rounded singer. Then again, I clearly like to hedge my bets. Why else do you think I was at university for fourteen years?

## 5. Is there anything about your career that you wish you’d learned earlier?

It’s not fair. Deal with it. Figure it out. Learn from it.

## 6. Why do you sing?

It’s naked. 

I spent the first 27 years of my life behind an instrument the size of an adult moose. It was delightful and enriching. There are opportunities for panache and virtuosity and subtlety and everything else in the performer’s arsenal, but everything was negotiated through this contraption of wood and iron. A contraption of engineering genius, but a contraption nonetheless.

I find singing decidedly different. Even though you’re explicitly donning the visage of some literary figure, there is a directness and a rawness that I find exhilarating. And it seems to me, strangely, that the validation more closely aligns in a sense with what you are, rather than what you can do. I suppose that makes the failures and the rejections all the more personal and biting too, but the confluence of dramatic emotion, physicality, and unobstructed communication between me and an audience is something that I had never quite experienced as a pianist. I imagine it must in some ways approximate what a professional athlete feels when he scores that tie-breaking goal and is awash not only in appreciation by the fans, but also in a shared jubilation with the fans. Conjubilation. I don’t think that’s a word, but it ought to be.

Besides. When “going to work” means “someone is actually going to pay me to put on tights and sing Shakespeare,” who wouldn’t like that?
