+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2016-05-31T11:30:00+01:00"
lastmod = "2017-04-15T19:09:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1464728118655/2016-06-01---Single.jpg.jpg"
primary_image_credit = "The person in this photo may or may not have children."
publishDate = "2016-06-01T11:25:00+01:00"
related_articles = ["articles/arianna-zukerman-youve-got-to-live-your-truth.md", "articles/is-technology-making-it-harder-to-tell-stories.md", "articles/the-heart-and-the-art.md", "articles/art-imitating-life-pat-emilia.md", "articles/young-singing-done-right-aksel-rykkvin.md", "articles/how-lucky-are-we-the-children-of-opera.md", "articles/opera-other-trysts-a-love-story.md"]
short_description = "Basically, when the work isn&#039;t going well, it can be quite devastating when it truly is the most important thing in an artist&#039;s life. It seems a lame excuse for moping, though, and it&#039;s easy to compound the guilt of being a &quot;bad artist&quot; with the guilt of &quot;not having anything else going for you&quot;; after all, compared to singers with &quot;real&quot; responsibilities outside of their work, a child-free singer should remember that they&#039;re among the lucky ones, right? "
slug = "child-free-opera-singers-happiness"
title = "Child-free opera singers &amp; happiness"

+++
Being an opera singer is a difficult career. It's a lot of work, a lot of pressure, a lot of travel. And opera singers aren't exempt from the common question about balancing work and family life. A quick Google search shows plenty of results about women who are juggling their opera careers while being mothers and wives; and, like other industries, there are more mothers answering these kinds of questions than fathers.

While, on the surface it seems one sided, we're happy to report that we've heard tales of parenting-related stress, loneliness, sleep-devprivation and guilt expressed by as many men as by women, among the singers we've interviewed. It appears, though, that fatherhood is not seen as a "cause" or "reason" or "admirable balancing act" in the same way as motherhood is.

So while we fight the double standard of gender, we at least can all agree that it's hard to be a parent; it's even harder to be a parent-plus-professional anything at all. There's another facet to this topic that is worth including, too: that it's also hard to be a professional singer who's single, and who has no kids.

The advantages of being kid-free and single: travel plans are less complicated, you have more disposable income, you can adapt more easily to changes in your schedule, and your sleep habits will not be interrupted by the goings-on of small kids or even partners.

It's easy to look at things like gig droughts, cancelled flights, paycheque-cancelling illness, and homesickness, and agree that all of these things *plus parenting* is a mountain of responsibility and stress. Still, "free agent" opera singers can unwittingly suggest that they have apparently nothing but time and energy to devote to their craft, and the people who hire them are aware that there's no family-career balance in play for this group of artists. While it's true that taking care of kids isn't on their to-do list, single, child-free singers deal with unique hurdles when the going gets tough.

Single opera singers can fall more easily, more thoroughly, into the insular opera bubble. If a singer is a motivated artist, they're using their oodles of free time wisely; they're practicing a lot, translating text into the wee hours of the morning, and keeping their bodies in shape. This is all fine when these singers are happy and inspired; but when they reach a moment (or one of the many moments) where they question their career and lifestyle, when they're burnt out or lonely or homesick or broke or they need a therapist, there's a specific kind of guilt that can sink in deeply.

All artists experience a lull (or several) during their careers, where their passion and energy diminish. For singers with kids, they have very tangible purpose and motivation and self-worth outside of their work: they're parents, too. 

It can be easy to equate one's value as a person with one's value as an artist; it's even easier when there's no "other big thing", like kids and marriages, that is deemed important enough to give value to one's life. Basically, when the work isn't going well, it can be quite devastating when it truly is the most important thing in an artist's life. It seems a lame excuse for moping, though, and it's easy to compound the guilt of being a "bad artist" with the guilt of "not having anything else going for you"; after all, compared to singers with "real" responsibilities outside of their work, a child-free singer should remember that they're among the lucky ones, right? 

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1464727022207/2016-06-01---Baby.jpg.jpg)
<figcaption>Adorable. Yet, not for everyone.</figcaption>
</figure>

Without familial responsibilities, it's easy to question your reason for feeling burnt out. You assume that you don't really have a good excuse for feeling uninspired, that others have it worse, that you must be lazy or ungrateful or unworthy of an opera singer's career. They may stumble upon interviews with successful singers, talking about parenthood and saying things like, ["It's wonderful. It keeps you in the world and makes your life complete,"](http://www.latinospost.com/articles/14077/20130311/la-traviata-soprano-diana-damrau-motherhood-future-projects-singing-dream.htm) or ["It outstrips any opera performance."](http://www.theoperablog.com/diva-interrupted-opera-and-motherhood/). 

It can even be tricky when singers do find their own ways to battle loneliness while on the road. Unattached singers may find romantic relationships while working on contract. For women as well as men, the opera bubble can be a cause and a trap; the world of opera is very small, and it may not take very many short-term relationships between singers for one or both of the parties involved to get an unsavoury reputation. Even if there's no scandalous behaviour, singers who date on the road can find themselves with career problems perhaps bigger than loneliness. 

The conclusion can be that these single, non-parent singers have cornered themselves into their careers; while said careers are real sources of happiness, they're volatile nonetheless. They not only have to deal with the same struggles as singers with families do, but they have to do it on their own, and they're even perceived as being at fault for that, because they didn't maintain their own "well-roundedness" as people.

Perhaps they're unwise about it, and instead of dating other colleagues, they should use online dating sites, and stick to "outsiders". But we all know that working with like-minded people can spark tempting and fulfilling relationships more readily than the average blind date. Plus, smart singers spend their time between rehearsals staying healthy, learning music, and maintaining a routine in a new city, rather than going on Tinder dates and spending late nights at noisy bars.

Readers, in case any of you watched *Sex and the City*, this whole thing is sort of like that episode, "A Woman's Right to Shoes", where Carrie loses a pair of Manolo Blahniks at a party. When the party host seems too busy being a mom to worry about where the shoes went, Carrie decides to throw herself an "I'm single, yay" kind of party, invite said host, and open up a one-item gift registry at, you guessed it, Manolo Blahnik.

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1464727006307/2016-06-01---Blahnik.jpg.jpg)
<figcaption>Adorable. Yet, again, not for everyone.</figcaption>
</figure>

To be fair, Carrie Bradshaw can be a horrible person, and *SATC* cheers on the single life, often to the point of insulting those who find happiness in so-called domesticity. And honestly, there are working artists (some of whom we've met), who have devoted their lives to their work, haven't married or had kids, and they seem *miserable*. Maybe they're miserable because they missed the boat on family stuff, or maybe they're the sort that would be grouchy even if they had the 2.5 kids and the picket fence.

The point we're veering towards is that happiness means different things to everybody, just like success. An opera singer who can support a family by performing has achieved a great feat of life. An opera singer who has figured out how to be his or her own independent support system has done the same. These two examples may not even be mutually exclusive, but they sure point to success. Hopefully, there's happiness in the mix, too.

Among singers themselves, there exists no internal competition; we've never experienced a singer with kids, looking disdainfully at a singer without kids, coming to any sort of conclusion that as parents, they're working harder or that their work is more admirable. No one is tsk-tsking anyone's life choices while at work. Yet in the press, it's an interesting trend; what opera singers do is pretty darn impressive already, yet perhaps it's an appealing detail to note that these singers also raise families. We do it with huge celebrities, too.

With all the self-help-like articles filling up our social media feeds, talking about how we all need to become self-sufficient and independent and that we shouldn't seek out happiness from external forces like partners and kids, you'd think that child-free opera singers would be a valuable headline, too. Singers are forced to be independent and thick-skinned at every turn of their volatile lives; under significant pressure and scrutiny at work, singers master the arts of dealing with rejection, fighting loneliness, and finding their own self-worth.

So, among the supermoms and superdads, we just want to let the supersingles know that we're cheering for you, too.