+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2016-01-02T21:33:00-05:00"
lastmod = "2016-01-04T11:46:00-05:00"
preamble = "The list of adjectives used to describe singers' voices is long and often hilarious. Critics (and this includes myself) use words like \"heroic\" or \"metallic\" or \"velvety\" to try and capture how a voice made them feel. It's usually a biased choice of word, one that refers back to their own personal aesthetics about singing. In truth, applying a label to a voice really only works when it's in comparison to another voice.\n\nSome of these descriptors are everywhere in operatic circles, yet it can often be hard to imagine what a \"bright\" colour sounds like in the voice, or what the word \"warm\" means when it comes to sound. We thought it would be handy to point out a few major categories under which voices fall, and let you easily hear the differences."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1451794712154/2016-01-03---ApplesOranges.jpg.jpg"
publishDate = "2016-01-04T09:00:00-05:00"
related_articles = ["articles/36-high-cs-to-perk-up-your-day.md"]
short_description = "Some of these descriptors are everywhere in operatic circles, yet it can often be hard to imagine what a &quot;bright&quot; colour sounds like in the voice, or what the word &quot;warm&quot; means when it comes to sound. We thought it would be handy to point out a few major categories under which voices fall, and let you easily hear the differences."
slug = "chiaro-vs-scuro-what-does-it-all-mean"
title = "Chiaro vs. scuro: what does it all mean?"
+++

## Bright versus dark

Bright and dark sounds come from everything from a singer's body shape and tiny differences in where the sound is resonating. There's an Italian term, [*charioscuro*](https://en.wikipedia.org/wiki/Chiaroscuro), which means *light-dark*, and it refers to that tricky balance of bright, ringing sound, with rich, full body resonance. Every singer finds this balance in a slightly different spot.

Bright sounds carry well in a large hall, even if the voice itself isn't big; there's an association between bright singing and vocal agility, and you'll often find a naturally bright quality in singers who excel at coloratura. Violetta's first act aria from *La traviata* is a great example for comparison. First, listen to Beverly Sills sing it:

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/I-AcsT9LRII?start=57" frameborder="0" allowfullscreen></iframe>
</figure>

The same bit now, but from Anna Netrebko. Compared to Sills, Netrebko's sound would be considered darker. formed a bit farther back, and you can hear that the voice feels somewhat wider, a bit heavier. Netrebko and Sills both approach their extreme high registers in a similar way, but you can really hear the difference in their coloratura.

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/cFJJ1zFBWgY" frameborder="0" allowfullscreen></iframe>
</figure>

The same bright/dark distinction applies for lower voices, too. Anyone who has heard or studied with Marilyn Horne knows that she's the queen of bright, forward singing, and listening to her sing "Non più mesta" from *La Cenerentola* is a textbook example:

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/2f4yWsmKIVE?start=29" frameborder="0" allowfullscreen></iframe>
</figure>

Compare that to the same aria, sung this time by Elīna Garanča. She has zero problems with her coloratura: the sound is comparatively muffled, yet beautifully rich.

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/ST1foXaRr_E?start=39" frameborder="0" allowfullscreen></iframe>
</figure>

For a subtler example, here are a couple of baritones. First, Sherrill Milnes sings Verdi's awesome aria, "Cortigiani, vil razza dannata" from *Rigoletto*:

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/hPa1HvsSnGE?start=10" frameborder="0" allowfullscreen></iframe>
</figure>

In men, this bright quality always sounds like it's honest and friendly; this is no friendly aria, and Milnes certainly brings the fire. Yet, the sound is sitting quite forward, and that's partly what gives him that thrilling, heroic sound up top. Compare that to how Dmitri Hvorostovsky sings the same aria. The initial sound is darker, yet more focused like a laser beam.

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/pQwlqogC8HQ?start=33" frameborder="0" allowfullscreen></iframe>
</figure>

## Steely vs warm

Again, these two words don't mean much on their own. In general, a steely sound has a bit of bite, grit, metallic ring to it; a warm sound has smooth edges, and it's often associated with lots and lots of legato. For example, here's Lucia Popp singing the Queen of the Night's famous aria from *Die Zauberflöte*:

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/pDUyA-fVie8" frameborder="0" allowfullscreen></iframe>
</figure>

In Popp's middle register is where you really hear this steely quality. Maybe people say "steely" because these voices can sound like they're singing from within a metal box; there's a huge amount of ring, and rage arias lend themselves well to steely singers. Contrast that to Diana Damrau's singing of the same aria, which I'd consider comparatively warm. You can hear less edge despite her character's rage, and there's a round quality to her whole range:

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/UXOYcd6KZ0E?start=131" frameborder="0" allowfullscreen></iframe>
</figure>

Sondra Radvanovsky is one of these singers with steel in her sound. Listen to how she begins "Vissi d'arte" from *Tosca*:

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/3pryZos2oOk?start=6" frameborder="0" allowfullscreen></iframe>
</figure>

Compare that to the queen of warm, luscious sound, Dame Kiri te Kanawa, singing the same aria:

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/-iYxNFCUD0A?start=50" frameborder="0" allowfullscreen></iframe>
</figure>

You can even hear the difference in two of the Three Tenors. Luciano Pavarotti starts Puccini's sweep-me-away aria from *Tosca*, "Recondita armonia", with that throaty, metallic steel we love so much:

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/qkzwB77h8Qs?start=39" frameborder="0" allowfullscreen></iframe>
</figure>

Plácido Domingo sings the same aria, but with his signature warmth and fire instead. Still sweeps me away:

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/cAM5d_tapXw?start=51" frameborder="0" allowfullscreen></iframe>
</figure>

## Spinning vs holding

This one is definitely related to vocal technique, and there can be *a lot* of reasons why you'd hear a sound that spins, versus one that's held still. It's a subtle difference, to be sure. Put simply, spinning the sound is a step up from simply sustaining a note; it's about sending it forward, the same way we lead ahead when we speak. For conductors or coaches, this spin is one of the clearest signals a singer can communicate. 

The verbs "hold" and "spin" are annoying and vague, I know, so let's start with an example of a sound that doesn't quite spin. Listen to soprano Carmen Giannattasio sing the first phrase of "Casta diva" from *Norma*:

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/eCe7p3rkM28?start=94" frameborder="0" allowfullscreen></iframe>
</figure>

The sustained notes are vibrating, and her sound is lovely; there's a distinct feeling of hanging on to the first phrase, almost as though she's afraid of running out of air. Holding the sound is generally less preferable to one that is not held, or that's "spinning", probably because a held sound is tense, and a spinning one is relaxed. It's unfair to compare anyone to Maria Callas, but listening to her is an easy way to hear what it means for a note to spin. Here's her rendition of Bellini's aria:

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/7rjGwS20V94?start=77" frameborder="0" allowfullscreen></iframe>
</figure>

Soft singing is a fantastic time to hear some spin. Supported singing at soft dynamic levels is an advanced technical skill, and for Heldentenors, it can separate the men from the boys. Here's Johan Botha singing the famed "In fernem Land" from *Lohengrin*:

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/wp1f-A4pGQs?start=22" frameborder="0" allowfullscreen></iframe>
</figure>

His sound is thrilling and huge, that's for sure; yet it almost feels like the voice is still getting revved up when it's under a certain volume. Compare that to the way Jonas Kaufmann begins the same aria:

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/FioGST4B4Jg?start=30" frameborder="0" allowfullscreen></iframe>
</figure>

>What do you listen for in a voice? How would you describe a sound you love? Have questions about any of the above? Let us know in the comments below!
