+++
author = ["authors/arturo-fernandez.md"]
categories = "Review"
date = "2019-02-17T17:53:14+00:00"
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1550425749/media/2019/02/sqMireilleAsselinMeghanLindsay.jpg"
primary_image_credit = "Mireille Asselin and Meghan Lindsay in Paride ed Elena, Odyssey Opera, 2019. Photo: Kathy Wittman, Ball Square Films."
related_articles = ["articles/orphee.md", "articles/odyssey-operas-giovanna-darco-bold-and-flawed.md"]
related_companies = ["scene/companies/odyssey-opera.md"]
related_people = ["scene/people/erica-schuller.md", "scene/people/meghan-lindsay.md", "scene/people/mireille-asselin.md"]
short_description = "Their voices pulled and pushed at Gluck’s music and Calzabigi's text, stretching and pulling and coloring every last note that made practically their entire run through the opera feel important."
slug = "chemistry-sizzles-onstage-in-paride-ed-elena"
title = "Chemistry sizzles onstage in Paride ed Elena"
youtube_url = ""

+++
Whenever one opts to say that an early opera was performed with fiery tenacity, I imagine the average opera-goer inevitably finds themselves asking "how does this get performed like that?" It can often get lost that audience expectations in the earlier days of opera were far, far different from what they are today, and in this light it is all too easy for early opera performance to get mired in the length and the padding that often accompanies these operas. But what is often forgotten is that this earlier music is activated when a singer approaches it with an eye for detail and attention, and when done right the drama can reach dramatic highs that Verdi and Wagner would have been jealous of.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1550426306/media/2019/02/Cast5.jpg){{% /md %}}

<figcaption>(l-r) Erica Schuller, Meghan Lindsay, and Mireille Asselin in Paride ed Elena, Odyssey Opera, 2019. Photo: Kathy Wittman, Ball Square Films.</figcaption>

</figure>

Thus, we come to [Odyssey Opera](/scene/companies/odyssey-opera/)'s staging of [Gluck's _Paride ed Elena_](https://www.odysseyopera.org/2019-gluck-paride-ed-elena/), the first of their three-opera explorations on the subject of Helen of Troy. As one might expect of Gluck, the opera contains many dances and choruses peppered throughout, most of which really don't add much to the drama unless they're setting the scene or something along those lines. The music is certainly nice, but these parts of the opera kind of sit there and bring the action to a standstill, particularly the bit in Act III when the chorus and dancers re-enacted Spartan games on-stage.

> It was clear that the Huntington Avenue Theater was hosting a pair of stars.

Then, the focus turned to Paride and Elena, and the love story at the heart of the opera. And _here_ is where the opera really shined, particularly in this production. [Mireille Asselin](/scene/people/mireille-asselin/) as Elena and [Meghan Lindsay](/scene/people/meghan-lindsay/) as Paride brought with them the kind of understanding of Gluck's text and music that is required to give the work much of its dramatic pull. Their voices pulled and pushed at Gluck’s music and Calzabigi's text, stretching and pulling and coloring every last note that made practically their entire run through the opera feel important. The amount of vocal control they both exercised was incredible to witness, and it was clear that the Huntington Avenue Theater was hosting a pair of stars.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1550426391/media/2019/02/MeghanLindsay.jpg){{% /md %}}

<figcaption>Meghan Lindsay in Paride ed Elena, Odyssey Opera, 2019. Photo: Kathy Wittman, Ball Square Films.</figcaption>

</figure>

But more than that, Asselin and Lindsay both did something that is exceedingly rare to find in the opera house: they worked up an undeniable chemistry throughout the night, one that was difficult for the audience to resist. Somewhere in their attention to detail in their vocal performance they elicited something out of Gluck's music that made sparks fly on-stage, and it was incredibly seductive to witness. The duet "_Ah ferma! … Ah senti!_" in particular was delivered with such ferocity and passion from both of them that I remember audibly woofing when the audience rightly burst into applause once it ended. It is exceedingly rare that older opera traditions are performed with such fire, and both Asselin and Lindsay deserve major accolades for bringing Gluck's music to real life.

> As always, Maestro Gil Rose led the ensemble in its terrific reading of Gluck's score that gave the singers plenty of room to play around in.

Asselin and Lindsay were not the only great parts of the opera, for sure. [Erica Schuller](/scene/people/erica-schuller/)'s Amore was a great playful trickster, and her performance elicited a lot of laughs throughout the evening. The chorus and dancers all had a very strong showing as well in their performance, and brought a sense of scale that was sorely missing in how few principle roles there were. As always, Maestro Gil Rose led the ensemble in its terrific reading of Gluck's score that gave the singers plenty of room to play around in.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1550426785/media/2019/02/MireilleAsselinEricaSchuller.jpg){{% /md %}}

<figcaption>Mireille Asselin and Erica Schuller in Paride ed Elena, Odyssey Opera, 2019. Photo: Kathy Wittman, Ball Square Films.</figcaption>

</figure>

As well, the production design was vibrant and colorful in ways I would not expect. It is always a risky prospect to design a set where half the opera is done without backdrop, but Russell Champa's lighting design smartly kept much of the lighting to the front of the stage, and thus shrouded the back of the theater wall in darkness. The effect was that the color palette in Brooke Stanton's costume designs was allowed to pop in a way they would not have otherwise, and it led to an aesthetically beautiful production that made a lot with very little.

> Performances like this are rare to come across in the realm of early opera productions.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1550426916/media/2019/02/Cast2.jpg){{% /md %}}

<figcaption>A scene from Paride ed Elena, Odyssey Opera, 2019. Photo: Kathy Wittman, Ball Square Films.</figcaption>

</figure>

But all of these are only amplified by Asselin and Lindsay's starring roles as the two central lovers at the heart of the story: it is through the efforts of their wills alone that the rest of the elements of the production fell into place. It should really say something that the sheer force of Lindsay's performance was enough for me to overlook my biggest gripe with the production: I eventually found it easy to forget that the hair and make-up chosen for her registered more like Jodie Whitaker as the 13th Doctor, because Lindsay embodied Paride in every other way that mattered to a degree that the costuming was _way_ less important. [Performances like this](https://www.odysseyopera.org/2019-gluck-paride-ed-elena/) are rare to come across in the realm of early opera productions, and it was a treat that I think the Boston opera scene was incredibly fortunate to witness.