+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2015-07-22T16:35:00-04:00"
lastmod = "2015-09-13T20:17:00-04:00"
preamble = "Based in Toronto, [Urbanvessel](/scene/companies/urbanvessel/) produces performances that are interdisciplinary, provocative, and based in the human voice. Past shows include *Voice-Box*, a boxing opera for an all-woman cast, *Stitch*, an *a cappella* opera for three women and sewing machines, and this summer's *Singing River*, which brought dance, poetry, singing and more to the Toronto's Don River. I spoke with Artistic Director [Juliet Palmer](/scene/people/juliet-palmer/), herself a composer and performer, about Urbanvessel's place in the Indie Opera T.O. collective, and in Canada's larger arts scene."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1437685981935/SingingRiver-1Square.jpg.jpg"
publishDate = "2015-09-01T12:44:00-04:00"
related_articles = ["articles/check-out-opera-5.md","articles/check-out-loose-tea-music-theatre.md","articles/check-out-opera-after-hours.md","articles/check-out-liederwolfe.md","articles/check-out-fawn-chamber-creative.md","articles/check-out-myopera.md"]
related_companies = ["scene/companies/urbanvessel.md","scene/companies/indie-opera-to.md"]
related_people = ["scene/people/juliet-palmer.md"]
short_description = "Based in Toronto, Urbanvessel produces performances that are interdisciplinary, provocative, and based in the human voice. Past shows include Voice-Box, a boxing opera for an all-woman cast, Stitch, an a cappella opera for three women and sewing machines, and this summer&#039;s Singing River, which brought dance, poetry, singing and more to the Toronto&#039;s Don River."
slug = "check-out-urbanvessel"
title = "Check out: Urbanvessel"
+++

### 1. What’s the mission behind Urbanvessel?

[Urbanvessel](/scene/companies/urban-vessel/) creates new work that is at the intersection of multiple disciplines and cultures. Our work is anchored in the human voice, and our overarching aims are to surprise people, transform space, and invite our audience to ask questions about the larger world around them.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1437692324321/SingingRiver-4Resized.jpg.jpg)
<figcaption>From Urbanvessel's *Singing River*. Photo: Giulio Muratori.</figcaption>
</figure>

### 2. How does Urbanvessel fit into today's opera scene?

In terms of an organization like Indie Opera T.O., our practice is rooted in the human voice, something we share with more traditional opera companies. And if we think about the big idea of what opera is we find common ground. Opera brings together artists from different backgrounds — traditionally it’s a writer, a composer, a director and a designer. 

We often draw on those same disciplines, but we may have an architect in the mix, or a filmmaker, or, as in our last show, women boxers and opera singers.

### 3. What do you think opera needs more or less of?

It needs to be relevant to people. My desire would be for people to engage with opera through an unpredictable connection, to offer an unexpected way of seeing the world around us. Our most recent project (*Singing River*) took people down into the lower Don River. We brought vocal soloists and ensembles into the valley, but also dancers, street artists and spoken word performers, creating site-specific performances and installations. At one point, we sing to the river, giving it back its Anishinaabemowin name, Wonscotonach.

Opera and theatre needs to be relevant to people’s lives, and fill the gap that’s not filled by a screen or by being able to find anything on the Internet. To me it’s about place, and understanding our place in the city.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1437692491927/SLIP-1Resized.jpg.jpg)<figcaption>From Urbanvessel's *Slip*. Photo: Ashok Charles.</figcaption>
</figure>

### 4. What kind of feedback have you gotten from your work?

Very positive feedback. When we did our boxing opera, Voice-Box, it was fantastic because the conversations we were having about women, violence, aggression, strength, were really inspiring. People got to engage hands-on, they got to learn some boxing techniques after our show. And I think it wasn’t something that a regular opera-going audience would necessarily expect. And we had a very diverse audience, which to me is very promising both for theatre and opera.

We have a lot of people who haven’t come to hear opera singers before, just because of the theme of a show. Our project *Slip* took place in the Harrison Street Baths in Toronto. This was a project that was bringing together architecture, dance, and different vocal styles — from jazz and gospel to opera and Japanese folk song. The kind of audience you bring together in a project like that is extremely diverse, so you’re always coming across people who haven’t seen one or another of those forms before.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1437692632593/STITCH-1Resized.jpg.jpg)<figcaption>Neema Bickersteth in Urbanvessel's *Stitch*. Photo: Omer Yukseker.</figcaption>
</figure>

### 5. Do you try to accomplish a goal with each production?

Our official line is that we want to “subvert social assumptions,” which sounds very lofty, but I think it’s true. For instance, the piece we just produced, *Singing River*, was challenging people to think differently about the Don River. Most people think of it as a dumping ground, a bit of a sad river. But we wanted people to fall in love with the river. In *Voice-Box* we wanted people to ask questions about women and power, aggression and violence. A lot of the time our aim is to provoke questions, making people uncomfortable, maybe, but in a wonderful way.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1437692869350/VOICE-BOX-3Resized.jpg.jpg)
<figcaption>From Urbanvessel's *Voice-Box*. Photo: Omer Yukseker.</figcaption>
</figure>

### 6. What projects do you look forward to in future seasons?

We are teaming up with [Bicycle Opera](/scene/companies/the-bicycle-opera-project/), to do a tour of a new opera that I’ve composed with librettist [Anna Chatterton](/scene/people/anna-chatterton/) called *Sweat*, an *a cappella* opera for eleven singers. We’re going to take that opera, which is inspired by garment sweat shops, and the globalization of the economy, into former industrial sites throughout Southern Ontario and possibly into Québec. It's a project we’re pretty excited about. For both companies, it’s a step up to a larger scale of work, but I'm excited about the possibilities of our new partnership.
