+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2015-07-28T19:55:00+02:00"
lastmod = "2015-08-13T00:26:00+02:00"
preamble = "[The Friends of Gravity](/scene/companies/the-friends-of-gravity/) is all about \"expressive immediacy,\" producing music theatre in intimate spaces, and combining live action and music with film and photographic media. This fall, The Friends of Gravity presents Kurt Weill's fantastic [*Seven Deadly Sins*](http://thefriendsofgravity.org/seven-deadly-sins/), complete with silent film elements. The Friends are [Scott Gabriel](/scene/people/scott-grabriel/), Artistic Director, conductor, and arranger, and [Stephanie Conn](/scene/people/stephanie-conn/), producer and vocal artist. I had the chance to ask them both about The Friends of Gravity, and their place in the Indie Opera T.O. collective.\n\n*Seven Deadly Sins* runs September 25 & 26 at St. Bartholomew Church, 509 Dundas St. E. For details and tickets, follow the box office links below."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1439364965514/FoG%20Logo%20Fill.jpg.jpg"
publishDate = "2015-08-12T14:47:00+02:00"
related_articles = ["articles/check-out-opera-5.md","articles/check-out-loose-tea-music-theatre.md","articles/check-out-opera-after-hours.md","articles/check-out-liederwolfe.md","articles/check-out-fawn-chamber-creative.md","articles/meet-the-friends-their-seven-deadly-sins.md","articles/in-review-the-seven-deadly-sins.md","articles/check-out-myopera.md"]
related_companies = ["scene/companies/the-friends-of-gravity.md","scene/companies/indie-opera-to.md"]
related_people = ["scene/people/stephanie-conn.md","scene/people/scott-gabriel.md"]
short_description = "The Friends of Gravity is all about &quot;expressive immediacy,&quot; producing music theatre in intimate spaces, and combining live action and music with film and photographic media. This fall, The Friends of Gravity presents Kurt Weill&#039;s fantastic Seven Deadly Sins, complete with silent film elements."
slug = "check-out-the-friends-of-gravity"
title = "Check out: The Friends of Gravity"
+++

### 1. What is the mission behind The Friends of Gravity?

**Stephanie**: Our slogan is "Big ideas on a small scale", which is sort of an over-simplification but does capture the essence of our intention. Opera can be expensive, unwieldy, and can be viewed as inaccessible, anachronistic or self-important. With The Friends of Gravity we want to perform works on an intimate scale, but also to draw on other genres and cultural influences like cabaret, spoken word and ritual. We want to draw in diverse audiences — not just opera-goers but also those who enjoy those other genres. Also, we started in Regent Park, and aim to keep a foot planted there.

**Scott**: We make theatre with music that we hope will seize the imagination of the audience and create an unexpected state-of-mind on their part. As Stephanie said, scale is fundamental to our way of thinking about stage production and communication—scale and setting. Whether we’re thinking about a piece of "musical theatre", a song cycle with puppets, a "legit" opera, or any other idea that involves asking people to sit and listen and watch us, the first consideration is always "What can be special about the experience of that person right there who’s watching?"

### 2. How does The Friends of Gravity fit into today's opera scene?

**Stephanie**: Today’s opera scene is so rich and diverse. It’s an exciting time to be involved. In Toronto we have this consortium of small companies, Indie Opera T.O., who are all doing things their own way, on their own, and pushing the boundaries of what opera can be.

**Scott**: Agreed - it’s fortunate that the scene is diverse. After all, our goal is not necessarily to present operas *per se*, but to create a vivid, communicative theatre with music that affects people in ways that they weren’t expecting to be. I think we’ll have to wait to see where we fit! 

### 3. What do you offer that's unique in the opera & theatre scene?

**Scott**: Because our departure point, or goal, is not to present operas but to make a certain kind of theatre, I hope we’ll offer a world where entering feels a certain way for the audience. I think the work of many groups can be identified by type or category—this company does small, this company does modern, or portable, or Mozart, for example. 

My hope is that people will come to identify The Friends of Gravity as a place to go where the experience is characterized by wonder.

**Stephanie**: In practice, this means including things that people might not expect in an opera. For example, in this production Scott has arranged the original full orchestra score for a small cabaret band (including accordion and ukulele). And instead of just surtitles – or the ballet of the original production - we’ve got snippets of our own original silent film running in the background!

### 4. What does opera need more, or less of?

**Scott**: I think we need more focus on communicating with and affecting an audience rather than less on amusing them or impressing them. I think we need more "violence", in Artaud’s sense — that ability to jar the audience out of the state of mind they came in with so that they end up feeling or thinking something unaccustomed or unexpected. It’s a tall order, and I don’t know if our little project is capable of realizing it, but I think we need always to be trying.

### 5. What kind of feedback have you gotten from your work thus far?

**Stephanie**: This production of Kurt Weill’s *Seven Deadly Sins* is actually our debut! So we haven’t yet had feedback on performances. But the response from the musicians involved in the show has been inspiring; they seem to get that we’re trying to do something a little different and are genuinely interested in being part of it. Friends and strangers have expressed enthusiasm for a new take on Weill/Brecht and in particular this show, which is relatively seldom-performed in comparison with, say, *Threepenny Opera*.

### 6. What do you hope your company will accomplish in future seasons? Do you have any "bucket list" productions you'd like to create?

**Scott**: The first thing to accomplish is to figure out if we can actually work the way we want to and make a show that meets certain goals. I hope we’ll accomplish figuring ourselves out. Can we do this?! As for a bucket list — definitely. There will be puppets. There will be miniature sets and live video. There will be Bártok, and Beckett. But we’re going to take one step at a time and see how we do. In future, I’d like us to become part of the fabric of the community in ways that promote more experimentation.

**Stephanie**: We’d like perhaps to collaborate with other companies, and organize a little festival. And as Scott has said, we didn’t start out thinking of ourselves as a company that does only opera, so we also have ideas for "theatricalizing" other works with inherent drama, like Monteverdi vocal works or even songs that lean toward the popular.
