+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-06-28T18:22:00-06:00"
draft = true
lastmod = "2016-07-05T19:50:00-06:00"
preamble = "Since 1997, [Tête à Tête](/scene/companies/tete-a-tete/) has produced over 70 new works by over 50 different composers, and the London-based company is a leader among those who foster contemporary opera. We spoke with Artistic Director Bill Bankes-Jones, about Tête à Tête's place among today's collective opera scene, some of his most memorable productions, and the upcoming premiere of Toni Castells' [*2045: The Year Man Becomes Immortal?*](http://www.tete-a-tete.org.uk/2045-year-man-becomes-immortal/), happening July 6th."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1467769829599/2016-06-29---Logo---TAT.jpg.jpg"
short_description = "&quot;The initial impulse behind Tête à Tête was to share with audiences the wonder of experiencing opera at very close quarters - quite literally tête-à-tête.  I had been working in huge international opera houses for quite a few years before founding the company, having a wonderful time, but also feeling a sense of loss as we moved from rehearsal room, where the greatest singers in the world would sing right in front of you, to the houses where they became tiny dots in the distance on the stage.&quot;"
slug = "check-out-tete-a-tete"
title = "Check out: Tête à Tête"
+++

# What has been the mission behind Tête à Tête over these 20 years?

The initial impulse behind Tête à Tête was to share with audiences the wonder of experiencing opera at very close quarters - quite literally tête-à-tête.  I had been working in huge international opera houses for quite a few years before founding the company, having a wonderful time, but also feeling a sense of loss as we moved from rehearsal room, where the greatest singers in the world would sing right in front of you, to the houses where they became tiny dots in the distance on the stage.  The intensity of this tête à tête experience still informs all our work.

But a second, complimentary mission emerged pretty fast - a focus on new work as well as innovative versions of older works, and in particular, a desire to introduce opera makers, particularly composers, to the stage at an early point in their work.  This really didn't happen back in the late 90s, composers tended to blunder out onto the main stages of our huge opera companies with little or no experience at all in the theatre, where I have my roots.  

## How does Tête à Tête fit into the opera scene of today?

Maybe a question for someone other than me.  My answer would be that we've become a focal point for new opera, somewhere that embraces risk, innovation, creative courage and adventure, keen to profit from all the lessons of operatic, theatrical and musical history, but also to engage imaginations in pushing the boundaries and finding out not what opera is but what it might become.  In this, we've also become an *éminence grise* - I've spent a lot of time abroad this year at various conferences, finding out that there is an explosion worldwide of the kind of work we do - small, short, new opera and music theatre.  When we started there was barely any, now there is a vast and thriving scene.

## What does Tête à Tête strive for with its productions?

The huge volume of work we've hosted or promoted over the last few years is not to be confused with our own productions.  All our productions to date have been directed or co-directed by me, aiming for and achieving the highest standard of musical and theatrical delivery, telling stories clearly, tête å tête, of course, and with a playful sense of theatricality and bond between audience and performer.  
In terms of the work we've hosted or supported, like *2045*, the common thread is a spirit of adventure and a genuine heart.  I meet up with everyone who comes to me with an idea, really to find out if what they have to get across comes from a genuine passion to communicate, share, open their hearts to their public.  Other than being new, and creating worlds with music and the voice, this is the main criterion, really.

## Are there any productions or projects of which you're particularly proud?

I'll pick out three, but there are many:

*The Canticles*, Westminster Abbey 2002, a co-production with Streetwise Opera which saw the birth of this miraculous company which is now working with homeless people worldwide. 

*Salad Days*, Riverside Studios 2009-2013, a joyous reappraisal of the 1950s musical, performed to 40,000 people over 4 years.  Exactly what I mean about a show with a good hear. You can still [buy the CD here](http://www.tete-a-tete.org.uk/shop/salad-days-cd/). 

*My Mother, My Daughter: 2015* an exquisite 6-minute jewel by Orlando Gough, one of our pop -up operas (performed each year of our festival to tens of thousands in streets and public spaces.)  Funny, truthful, touching, you can [watch it here](http://www.tete-a-tete.org.uk/pop-up-operas/).

## What can you tell us about *2045: The year man becomes immortal?*

Very little.  This is a show we are supporting rather than producing.  I can tell you that Toni Castells, composer and mastermind, produced *Life from Light*, with us in 2014 which certainly teased the edges of what opera is in a pop direction and packed out the theatre with a delighted audience.  This time, he's exploring questions of identity, technology and individuality around a fascinating thesis, that technology will become more intelligent than mankind in around 30 years.  The concert performance in July is the precursor of a grander event involving dancers and more complex staging.  I'm delighted to be supporting Toni with this initial version.

## What projects do you look forward to in future seasons?

I am REALLY looking forward to our own next production, *The Hive*, by Carole Hayman and Harvey Brough, an extraordinary exploration of the world of the serial killer stemming from Carole's long and extensive research. We're producing *The Hive* under the umbrella of Grimeborn this August, itself a noteworthy collaboration!
