+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2015-07-20T11:42:00-04:00"
lastmod = "2015-09-09T08:42:00-04:00"
preamble = "Vancouver based company [Opera After Hours](/scene/companies/opera-after-hours/) is all about looking twice at historical opera repertoire. Led by Artistic Directors [Christopher Bagan](/scene/people/christopher-bagan/) (historical keyboardist) and [Debi Wong](/scene/people/debi-wong/) (mezzo-soprano), Opera After Hours had its inaugural production last summer, with *#DidoAndAeneas*; they took the story in a new direction, focusing on issues of cyberbullying and collaborating with [Stop-A-Bully Canada](http://www.stopabully.ca/). Debi and Christopher chat about their unique mission, and the problem/solution of so-called \"tradition.\""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1437410496479/OperaAfterHoursLogo.png"
publishDate = "2015-09-02T12:00:00-04:00"
related_articles = ["articles/check-out-loose-tea-music-theatre.md","articles/check-out-urbanvessel.md","articles/check-out-the-friends-of-gravity.md","articles/check-out-liederwolfe.md","articles/check-out-opera-5.md","articles/check-out-fawn-chamber-creative.md","articles/check-out-myopera.md"]
related_companies = ["scene/companies/renaissance.md"]
related_people = ["scene/people/debi-wong.md","scene/people/christopher-bagan.md"]
short_description = "Vancouver based company Opera After Hours is all about looking twice at historical opera repertoire. Led by Artistic Directors Christopher Bagan (historical keyboardist) and Debi Wong (mezzo-soprano), Opera After Hours had its inaugural production last summer, with #DidoAndAeneas; they took the story in a new direction, focusing on issues of cyberbullying and collaborating with Stop-A-Bully Canada. "
slug = "check-out-opera-after-hours"
title = "Check out: Opera After Hours"
+++

### 1. Can you tell us about the mission behind Opera After Hours?

Our mission is to create and present performances that build bridges between
the baroque and the contemporary; the artist and the audience; the imaginary and the real. We endeavour to provide opportunities for young artists and new audiences to explore historical music, as well as established artists and audiences to experience historical music in a new way. We value innovation, risk taking, flexibility, artistic intuition, interdisciplinary collaboration, experimentation and artistic excellence.

### 2. How does Opera After Hours fit into today's opera scene?

It’s hard to say. It seems like there is a new movement happening in opera. We’ve, unfortunately, seen a lot of bigger opera companies fold in the past five years for various reasons, which has really shaken up the scene. It’s sad to see, but in these past five years, we have also seen a very strong indie-opera scene emerge. There are a lot of smaller companies that are exploring new ways of presenting traditional operatic works and that are also commissioning new operas. There’s a renewed focus on building audiences and redefining what opera is in the 21st century. I think that’s the scene we belong in: the small underground indie scene that isn’t afraid to take risks and step outside the box - we’re excited to be a part of that!

### 3. What do you offer that's unique in the opera & theatre scene?

That’s a tricky question because we are a very new company and we’ve only had
one production. But our main goals with our debut production were: to make sure the story addressed current trends and issues in our society; to present in a venue that offered a casual atmosphere and that could be inviting to audiences that have never seen an opera before; to use a mixed cast of young-emerging singers and more established performers, and lastly and most importantly, to work as collaboratively as possible. I don’t think any one of those goals is really unique to the opera scene, but perhaps the combination of all these things, is.

#### 4. What does opera need more, or less of?

More *and* less: tradition. That’s a dangerous thing to throw out there, but to be perfectly honest, it’s exhausting to come up with what could be a great idea, and then be told over and over again, that it’s too risky, or that it will never sell, or that it simply isn’t what the public is looking for, or that it isn’t correct. It is equally exhausting to hear and see the same kind of performances over and over again.

We need fewer traditions of following rules and preserving performance practices, and more traditions of asking ourselves “what else is possible?”, “how can I make this happen”, “what if...?”. That being said, in our experimentation it’s important that we also hold ourselves to high artistic standards.

### 5. What kind of feedback have you gotten from your work thus far?

So far, so good! We’re still super green at all this. We’ve only had one production, #DidoAndAeneas, which was a remake of Purcell’s opera (of the same name sans hashtag…). We updated the story to address the issue of cyberbullying and we incorporated social media into the production concept and staging. We also teamed up with Stop-A-Bully Canada who provided us with anti-bullying information and with local jewelry designers (Patsy Kay Kolesar, Simone Richmond and Su Foster) who created hashtag pendants for our cast to wear. 

It could have all gone horribly wrong, but in the end the audience loved the unique interaction with the characters and the relevant storyline (we all learned A LOT about social media and bullying), and the creative team enjoyed the collaborative working environment and the opportunity to work on something “old” in a very new and interdisciplinary way.

### 6. What do you hope Opera After Hours will accomplish in future seasons? Do you have any "bucket list" productions you'd like to create?

We would love to be able to produce at least one fully-staged opera per season, and we are working on creating a concert series that will focus on interdisciplinary performance and explore what it means to present a “classical” recital today. We don’t have a production bucket-list - we’re open to anything as long as it meets our mission!
