+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2015-07-22T16:50:00-04:00"
lastmod = "2015-09-07T22:23:00-04:00"
preamble = "Artistic Director [Aria Umezawa](/scene/people/aria-umezawa/) and General Director [Rachel Krehm](/scene/people/rachel-krehm/), also known as the ladies of [Opera 5](/scene/companies/opera-5/), said to me that although they take their work and their art very seriously, they don't take themselves seriously. I think that's a great way to sum up Opera 5, a Toronto-based company that creates a full opera-going experience for its audiences. They commission new works, put up rarely heard operas, and pair their performances with food, drink, and atmosphere suggestive of the evening's entertainment.  \n\nAria and Rachel are also strong supporters of building their own audiences, and their video series, [*Opera Cheats*](https://www.youtube.com/user/OperaFive) is one of the creative ways they've found to do just that. I was able to chat with both of them about their aesthetic, their beliefs in opera, and the shows they're still keen to put up.\n\nTo kick off the 2015/16 season, Opera 5 is having its annual gala, Opera 500, on September 29th at The Extension Room. Get dressed up, bid on singers, win prizes, and press the MYSTERIOUS RED BUTTON. The event starts at 7pm, tickets are $25. For more details and to buy tickets, follow the box office links below."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1438207828983/Opera5Boheme.jpg.jpg"
primary_image_credit = "A scene from Opera 5's Opera Cheats: La bohème."
publishDate = "2015-09-08T12:00:00-04:00"
related_articles = ["articles/check-out-the-friends-of-gravity.md","articles/check-out-urbanvessel.md","articles/check-out-loose-tea-music-theatre.md","articles/check-out-liederwolfe.md","articles/check-out-opera-after-hours.md","articles/check-out-myopera.md","articles/aria-umezawa-opera-5s-die-fledermaus-with-surprises.md"]
related_companies = ["scene/companies/opera-5.md"]
related_people = ["scene/people/rachel-krehm.md","scene/people/aria-umezawa.md"]
short_description = "Artistic Director Aria Umezawa and General Director Rachel Krehm, also known as the ladies of Opera 5, said to me that although they take their work and their art very seriously, they don&#039;t take themselves seriously. I think that&#039;s a great way to sum up Opera 5, a Toronto-based company that creates a full opera-going experience for its audiences. They commission new works, put up rarely heard operas, and pair their performances with food, drink, and atmosphere suggestive of the evening&#039;s entertainment. "
slug = "check-out-opera-5"
title = "Check out: Opera 5"
+++

### 1. What is the mission behind Opera 5?

Opera 5 seeks out and engages new opera audiences through creative programming. We believe that the joy of opera is not only what you see on stage, but the whole experience from the time you walk in the door. Whether we spice up your intermission with custom cocktails, or combine hip hop with our staging, Opera 5 loves to inject an element of fun in everything we do. At our shows, you should bring a pal, grab a drink, relax and enjoy the show! 

### 2. How does it fit into today's opera scene?

Opera is a great art form with a long and proud tradition, but it can take itself too seriously sometimes. We aren't afraid to highlight the more ridiculous aspects of any particular piece. This is especially evident in our web series *Opera Cheats*, where we deconstruct operatic plots in humorous ways. Opera 5 is a company that isn't afraid to say what we are all thinking. Who hasn't thought to themselves "Huh, *Madame Butterfly*. Kind of super racist" or, "Wow! The ending to *La traviata* is sort of abrupt!" 

There are plenty of companies out there that are innovating in terms of staging, and music. Opera 5 is innovating in terms of opera-going culture. We take the art form very seriously, but not ourselves, and we think that this attitude can break down some of the barriers that may be preventing some people from trying out their first opera. We try to make sure that people coming into our shows don't feel they are walking into a situation where they need to be "in the know" and that it is ok to laugh and just have a fun night. Opera is entertainment and doesn't have to be an intellectual exercise (for everyone). 

<figure data-type="video">
<iframe width="854" height="510" src="https://www.youtube.com/embed/ikOUh8ZZ23k" frameborder="0" allowfullscreen></iframe>
</figure>
 
### 3. What does opera need more, or less of?

Opera needs more diversity in leadership positions. From Musical Directors, to Stage Directors, to Artistic Directors, General Directors and beyond. If we had a more diverse group of leaders (both in terms of gender and race), maybe *Carmen* wouldn't always be reduced to a sex symbol; maybe Don Giovanni wouldn't be the victim of the show and Zerlina, Donna Anna and Donna Elvira wouldn't be fickle women who lose their morals when a handsome man walks into the room; and yellow face, black face, or simply white washing would stop being acceptable. These are the kinds of things that alienate modern audiences and prevent first time opera-goers from returning. 

Cities across North America hold up their multiculturalism as a badge of honour. If the opera world hopes to engage people and get them hooked on the art form, we're going to have to reflect the values of the societies these people live in. Opera 5 is very conscious of who we hire to do a job if a certain culture or group is represented in an opera. When we produced [*Ba-ta-clan*](http://www.schmopera.com/in-review-offenbachhahn/), an Offenbach operetta set in a presumed China with Frenchmen disguised as locals, we made sure to have a Chinese-Canadian director, Jasmine Chen, who was sensitive to the cultural traps of the piece. The result was a hilarious piece about revolution and false identity. With a leadership that is sensitive to these modern sensibilities and expectations, we believe opera is fully viable and accessible to a far greater audience. 

<figure data-type="video">
<iframe width="854" height="510" src="https://www.youtube.com/embed/tWT-uoOk-54" frameborder="0" allowfullscreen></iframe>
</figure>

### 4. Can you tell us about your "Opera Cheats" video series?

We’ve always sort of wanted to do a series that introduced people to opera, in a way that didn’t apologize for opera as an art form, didn’t over-intellectualize it; literally just said, “this opera is awesome, and let’s tell you why as simply as possible."

So, we started writing [Opera Cheats](https://www.youtube.com/user/OperaFive) as way to give you all the information you need to know about opera or about any particular show in about 3 minutes, and in an enjoyable format. Without any of the bells and whistles, just literally what you needed to know. We put the first 3 up, and we said, "If we get 500 views between these 3 videos, I think we’ve done a really good job." And then, within the week, we had 3000 views, and then it was more like, “How many more can we put out, and how quickly?"

So, if you want to know about a specific show or you want to know about some of the customs of opera, or what people do in opera, then [Opera Cheats](https://www.youtube.com/user/OperaFive) is there for you as a resource to teach you the basics.
 
### 5. What kind of feedback have you gotten from your work?

We are very lucky in that our audiences have always been receptive to our productions. People new to opera have told us they finally understand what the emotional draw is and people who have never seen an opera before have left comments on our videos saying that we've inspired them to go see their first show. A young man and his friends drove from Waterloo to Ottawa to see our production of *La voix humaine* at the 2013 Fringe. He had never seen an opera before and when the show was over he said he knew there were deaths because of the old trope, but he hadn't expected to be so affected by seeing one live. When we can provide those kinds of experiences to our audiences, we feel we've done a good job.

<figure data-type="video">
<iframe width="640" height="360" src="https://www.youtube.com/embed/JqrVM4F8kHs" frameborder="0" allowfullscreen></iframe>
</figure>

### 6. What do you hope Opera 5 will accomplish in future seasons? Do you have any "bucket list" productions you'd like to create?

Opera 5 is never short of ideas. It would take several more posts to outline everything we wish we could do! What we certainly want to do more of is commission new Canadian works and present them in their full orchestration. We are in talks with a few composers and have some pretty cool stories lined up. We also have a "bucket list" of some classic opera chestnuts reimagined in more modern contexts. Some of them involve changing the role of the audience, some involve modern updates with the original libretto and music in tact, but modern dialogue between numbers. We are pretty psyched about all the ideas we have and can't wait to get some of them on a stage! 
