+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2018-10-11T21:24:00-04:00"
lastmod = "2018-10-13T12:29:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539352221751/LindenTrio.jpg.jpg"
primary_image_credit = "Clockwise: pianist Trevor Chartrand, soprano Julie Ludwig, and baritone Jeremy Ludwig."
publishDate = "2018-10-12T20:03:00-04:00"
related_people = ["scene/people/julie-ludwig.md","scene/people/jeremy-ludwig.md"]
short_description = "Art song - a broad classical music term to describe a piece written for solo singer and accompaniment, usually by a piano - can feel equal parts vague and exclusive. A song by Schubert and a song by Bernstein are both considered art songs, despite enormous differences in style; conversely, art song carries with it some special qualities, like the conversational relationship between the voice and piano."
slug = "check-it-out-the-linden-project"
title = "Check it out: The Linden Project"
+++

These days, opera is getting its fair share of makeovers; companies are shaking off its perceived cobwebs, doing away with the "elitist" hurdles like hours-long run times and stuffy theatres. The 21st century is the time of the slimmed down, newly translated, not-in-an-opera-house opera.

Baritone [Jeremy Ludwig](/scene/people/jeremy-ludwig/) and soprano [Julie Ludwig](/scene/people/julie-ludwig/) have a similar aim, with art song. Together, they have founded [The Linden Project](http://lindenproject.com), a concert series with a simple goal: to bring in a new art song audience. "People who don't already know what art song is," Jeremy imagines, "which is most people."

Art song - a broad classical music term to describe a piece written for solo singer and (usually) piano accompaniment - can feel equal parts vague and exclusive. A song by Schubert and a song by Bernstein are both considered art songs, despite enormous differences in style; conversely, art song carries with it some special qualities, like the conversational relationship between the voice and piano.

The Linden Project is about making it easy for listeners to digest art song. Along with performing it at a high standard, they'll have visual aids: imagery and artwork to complement each song, and condensed, to-the-point translations projected beside the singers - no shuffling of paper programmes necessary.

The inaugural season of The Linden Project kicks off with their opening concert on **November 3**, featuring Julie, Jeremy, and pianist Trevor Chartrand. Entitled [*Song Sampler*](http://lindenproject.com/ld_schedule-events/tasting-menu/) ("A little of this, a little of that"), the concert is a carefully curated programme of "hits" from the art song repertoire - everything from Schubert to Debussy to Joni Mitchell. It's a conscious choice by the Ludwigs, to begin their grand plan of unpacking and demystifying the art song genre with a dose of familiarity.

"If people have taken singing lessons before with a classical teacher," says Julie, "chances are they have sung at least one of [these songs]." 

The Linden Project's first season is modest, with just two recitals in the calendar (the second happens April 20, 2019). "We're hoping, down the road, to involve other singers and other pianists," says Jeremy. They're also on the hunt for unorthodox performance venues - bars, art galleries, the outdoors (perhaps near a linden tree).

You can [check out the full programme](http://lindenproject.com/wp-content/uploads/2018/07/Fall-2018-Concert-Programme.pdf) of *Song Sampler*, happening **November 3, 8pm, at St. Cuthbert's Presbyterian in Hamilton, ON**.

It's also worth perusing The Linden Project's [About section](http://lindenproject.com/about/), where you'll find answers to your most pressing questions: ["What is art song?"](http://lindenproject.com/about/#artsong) and ["What's with the tree?"](http://lindenproject.com/about/#tree)

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539307431465/Song-Sampler-Poster.jpg.jpg)
</figure>

>For details and tickets, [click here.](http://lindenproject.com/ld_schedule-events/tasting-menu/)
