+++
author = ["authors/michael-pecak.md"]
categories = "Review"
date = "2018-02-21T12:05:00-05:00"
lastmod = "2018-03-04T16:44:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519232008267/sq---Joshua-Hopkins_Marianne-Crebassa_Ana-Mari%CC%81a-Marti%CC%81nez_Andrew-Stenson_COSI-FAN-TUTTE_37A6827_c.Cory-Weaver.jpg.jpg"
primary_image_credit = "Joshua Hopkins, Marianne Crebassa, Ana María Martínez, and Andrew Stenson in Così fan tutte, Lyric Opera of Chicago, 2018. Photo: Cory Weaver."
publishDate = "2018-02-21T12:05:00-05:00"
related_articles = ["articles/cosi-fan-tutte-misogynist-unreasonable.md", "articles/stay-warm-with-opera-mariposas-tropical-cos-fan-tutte.md"]
related_companies = ["scene/companies/lyric-opera-of-chicago.md"]
related_people = ["scene/people/joshua-hopkins.md", "scene/people/ana-maria-martinez.md"]
short_description = "The overt chauvinism and cynicism of this plot aside, what isn&#039;t made clear — and what inevitably proves difficult for any production of this opera — is what happens at the end once the wager is divulged and all has been revealed to the sisters. Do the original pairs simply reunite despite all that transpired?"
slug = "chauvinism-cynicism-great-singing-così-fan-tutte"
title = "Chauvinism, cynicism, &amp; great singing: Così fan tutte"

+++
A lot can happen in twenty-four hours. Fortunes are fleeting. Feelings can change. The surreal materializes. Such is the underlying premise of Mozart's *Così fan tutte*, currently on stage at the Lyric Opera of Chicago.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519232376021/COSI-FAN-TUTTE_WS-18_c.Andrew-Cioffi.jpg.jpg)
<figcaption>*Così fan tutte*, Lyric Opera of Chicago, 2018. Photo: Andrew Cioffi.</figcaption>
</figure>
 
Lorenzo Da Ponte's problematic libretto for *Così* (his final collaboration with Mozart) has been commented on and criticized continuously since the work's premiere in 1790. Fiordiligi and Dorabella, happy and seemingly carefree sisters from Ferrara, suffer a quasi Job-ian twist of fate when their beloveds Guglielmo and Ferrando suddenly ship out to war. Unbeknownst to the ladies, however, is that they are actually the subjects of a cynical ruse orchestrated by Don Alfonso, an "old philosopher," who intends to prove—within twenty-four hours—the inherent fickleness of women. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519232396325/Elena-Tsallagova_Marianne-Crebassa_Ana-Mari%CC%81a-Marti%CC%81nez_COSI-FAN-TUTTE_37A6918_c.Cory-Weaver.jpg.jpg)
<figcaption>Elena Tsallagova, Marianne Crebassa, and Ana Marìa Martìnez in *Così fan tutte*, Lyric Opera of Chicago, 2018. Photo: Cory Weaver.</figcaption>
</figure>

Guglielmo and Ferrando are parts of his ploy. Disguised as foreigners ("Albanians" in the original), the men must test the women's faithfulness, each attempting to seduce the other's beau. Although they hope to disprove the Don's point, the men are ultimately successful in winning the women's affections and, in the process of doing so, fall in love with their conquests. 

The overt chauvinism and cynicism of this plot aside, what isn't made clear — and what inevitably proves difficult for any production of this opera — is what happens at the end once the wager is divulged and all has been revealed to the sisters. Do the original pairs simply reunite despite all that transpired? What to do with the personal and emotional growth the characters experience in Act 2? And how are we, the audience, supposed to take in this story, couched as it is in Mozart's characteristically sublime lyricism.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519232443964/Joshua-Hopkins_Elena-Tsallagova_Andrew-Stenson_COSI-FAN-TUTTE_37A6723_c.Cory-Weaver.jpg.jpg)
<figcaption>Joshua Hopkins, Elena Tsallagova, and Andrew Stenson in *Così fan tutte*, Lyric Opera of Chicago, 2018. Photo: Cory Weaver.</figcaption>
</figure>
 
Indeed, the character development in *Così* is the weakest among the three Da Ponte operas (the other two being *Le nozze di Figaro* and *Don Giovanni*). John Cox's production, first seen at LOC during their 2006/07 season and back currently for a revival under director Bruno Ravella, offers a subtle, but ingenious angle on the characters' emotions. In Cox's vision, the action is set on a Mediterranean beach resort sometime in August 1914. Though it's never dwelled on and only ever hinted at during a few key scenes, war now becomes a reality with teeth capable of true emotional and physical laceration and not merely a contrivance that is quickly forgotten during the shenanigans of the "Albanian" masquerade. This provides a much richer dramatic space for the singer-actors to explore. And the cast of this production certainly capitalized on the opportunity.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519232467018/Andrew-Stenson_Alessandro-Corbelli_Joshua-Hopkins_COSI-FAN-TUTTE_37A7002_c.Cory-Weaver.jpg.jpg)
<figcaption>Andrew Stenson, Alessandro Corbelli, and Joshua Hopkins in *Così fan tutte*, Lyric Opera of Chicago, 2018. Photo: Cory Weaver.</figcaption>
</figure>
 
Soprano [Ana María Martínez](/scene/people/ana-maria-martinez/) and mezzo Marianne Crebassa sang, respectively, Fiordiligi and Dorabella. Both were radiant as love-struck debutantes in Act 1 and captivating as love-torn women in Act 2. Looking — and sounding — every bit like sisters, Martínez and Crebassa had an infectious Lucy Ricardo-Ethel Mertz chemistry, yet each brought an individuality that captured the essence of her character as distinct from the other. Highlights for me included Fiordiligi's Act 1 aria "Come scoglio" and the touching Act 2 duet "Il core vi dono" between Dorabella and Guglielmo, here sung by Canadian baritone [Joshua Hopkins](/scene/people/joshua-hopkins/). Not to be outdone, tenor Andrew Stenson delivered Ferrando with, at times, Jim Carrey-esque physical humor, but an always sweet lyricism. Rounding out the male ensemble was Italian baritone Alessandro Corbelli in the role of Don Alfonso. A veteran of the Mozart, Rossini, and Donizetti comedic roles, Corbelli proved a grand seigneur both vocally and dramatically. I couldn't help but root for the scheming Don.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519232502741/Marianne-Crebassa_Ana-Mari%CC%81a-Marti%CC%81nez_COSI-FAN-TUTTE_37A7248_c.Cory-Weaver.jpg.jpg)
<figcaption>Marianne Crebassa and Ana Marìa Martìnez in *Così fan tutte*, Lyric Opera of Chicago, 2018. Photo: Cory Weaver.</figcaption>
</figure>
 
Unquestionably, the person who stole every scene she appeared in was Russian lyric soprano [Elena Tsallagova](/scene/people/elena-tsallagova/) as Despina. Her run in *Così* at LOC marks her U. S. debut and judging by the ecstatic ovation she received she will be heard here again very soon. In addition to an impeccable sense of comedic timing and a superb stage presence, Tsallagova sang with such artistry and grace that it carried over into the pit. It was astounding to hear how much more vivid and incisive the orchestra sounded when Tsallagova took the stage, especially so in her two signature arias, "In uomini! In soldati" and "Una donna a quindici anni," both of which I would have been happy to hear her sing on loop for the rest of the evening.  

*Così fan tutte* runs at the Lyric Opera of Chicago through March 16.