+++
author = ["authors/greg.md"]
categories = "Interview"
date = "2016-03-22T09:25:00+00:00"
lastmod = "2016-03-22T15:21:00+00:00"
preamble = "On a sunny Saturday afternoon, I made my way to the trendy Yorkville area of Toronto to meet up with my good friend and colleague, soprano [Lucia Cesaroni](/scene/people/lucia-cesaroni/). We got together to discuss her participation in a world premiere performance of the new Canadian opera *Isis and Osiris: Gods of Egypt*, being presented by [VOICEBOX: Opera In Concert](/scene/companies/voicebox-opera-in-concert/) at the beginning of April. \n\nI made my way up to her lovely penthouse suite, and after the prerequisite gabfest with her and her husband (another friend and colleague, tenor [Adrian Kramer](/adrian-kramer-youre-just-a-bit-of-an-ambiguous-vocal-identity/)) about what we've all been doing in our \"spare time\" (I put it in quotation marks because it's totally a fictional concept), we began to get into the nitty-gritty.\n\nWe sent Adrian off to his friend's engagement party, and Lucia and I did one of the things singers do best: sip a cocktail and talk some shop. As I take my first dram of [Crown Royal © Northern Harvest](https://www.crownroyal.com/canadian-whisky/crown-royal-northern-harvest-rye/) (yes, I FINALLY got to try the world's best Whiskey, 2015) and Lucia settles into a delicious looking Manhattan, we start with a few of the basics. \n\nConsidering the refreshments available, the conversation has been paraphrased somewhat. To get you in the mood, imagine the beautiful sustained ring of a crystal tumbler as it sparkles with the caramel colour of great Canadian whiskey... "
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1458654331507/2016-03-22---Whisky---Photo-by-Greg-Finney.jpg.jpg"
primary_image_credit = "Photo by Greg Finney."
publishDate = "2016-03-22T13:47:00+00:00"
related_articles = ["articles/talking-with-singers-lucia-cesaroni.md","articles/talking-with-singers-adrian-kramer.md"]
related_companies = ["scene/companies/voicebox-opera-in-concert.md","scene/companies/the-santa-fe-opera.md","scene/companies/tapestry-opera.md","scene/companies/toronto-operetta-theatre.md"]
related_people = ["scene/people/lucia-cesaroni.md","scene/people/adrian-kramer.md","scene/people/michael-barrett.md","scene/people/julie-nesrallah.md"]
short_description = "&quot;I don&#039;t want to keep comparing to the States, but we&#039;re behind. We hate to admit it, but we are behind - and that&#039;s okay. We&#039;re a younger country, we&#039;re a younger industry. We may be behind here, but look at all the other places where we&#039;re ahead. It&#039;s very important to me that we find a way to secure a creative, successful, tenable way to secure a future for opera in Canada.&quot;"
slug = "cesaroni-isis-osiris-new-opera"
title = "Lucia Cesaroni: Isis and Osiris, the value of new opera, &amp; &quot;bad b*tches in charge&quot;"
+++

### What have you been up to lately?

I just got back from LA, where I was coaching Susanna in *Le nozze di Figaro* with James Conlon for my upcoming Italian debut in Spoleto, Italy. After that, Adrian and I took a nice drive along the coast and tried a bunch of great wines. Now, we're back in Toronto hitting the scores."

### How did you get involved with this opera?

I had realized how precious little new works I had done in the past. Guillermo Silva-Marin and Henry Ingram of [VOICEBOX: Opera In Concert](/scene/companies/voicebox-opera-in-concert/) came to me and asked if I was interested. You and I had talked briefly earlier about how important I believe it is that we champion these new works as much as we can. After speaking with Guillermo and Henry, I then got in contact with the composer [Peter Anthony Togni](http://www.petertogni.com/), who is incredibly well-versed in opera and vocal music, and is well known to Canadians through his work on CBC and amongst the musical community as a composer and performer. It was then great to meet the rest of the cast, especially the beautiful [Julie Nesrallah](/scene/people/julie-nesrallah/). We realized that even though she's of Lebanese descent and I'm Italian, we could pass for sisters.

### What are your thoughts on singing new operas versus the standard canon?

Up until now, I really only got cast in the Italian repertoire. Be it my name, or the colour of my voice, or my Italian background and sensibilities, that's just where I've been hired. It's always something of a departure doing new music. Adrian, my husband, has spent the last two summers with [Santa Fe Opera](/scene/companies/the-santa-fe-opera/). Being there, meeting the composers and conductors, my eyes were opened to the sheer volume of well-done, expensively-produced new opera happening in the States. Santa Fe is but one slice of the pie - I realize we're talking about a 10-1 ratio - yet the comparison between Canadian and American new opera is important. 

There are a multitude of companies that have big budgets, and what's interesting to me is that it's not even a gamble for them to produce these works. The amount of incubation of new opera in the States, so far, exceeds what we're doing here in Canada. Certainly we have companies like VOICEBOX and [Tapestry Opera](/scene/companies/tapestry-opera/) doing great work, but we need more. The old chestnuts are doing just fine, but we need to create and support the creation of works so they can also become part of the standard canon. 

I don't want to keep comparing to the States, but we're behind. We hate to admit it, but we are behind - and that's okay. We're a younger country, we're a younger industry. We may be behind here, but look at all the other places where we're ahead. It's very important to me that we find a way to secure a creative, successful, tenable way to secure a future for opera in Canada.

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1458654304215/CESARONI-PHOTO2014.jpg.jpg)<figcaption>Lucia Cesaroni, soprano.</figcaption>
</figure>

### Can you describe Peter Togni's score?

The good thing is it's tonal. I'm a big fan of the weird, way out there, new compositions in the contemporary realm, but this one is very accessible and tonal. It's also fairly chromatic and he draws a lot from middle-eastern themes and musical sensibilities. 

### Have you found yourself connecting to Sharon Singer's libretto in any way?

We were talking about this a little before, but I'm playing Isis, who is this total "bad b\*tch in charge". There's a lot of emphasis in the libretto on the equality between the genders. Isis is a queen in her own right, and a powerful one at that. It also is a real unique pleasure to sing a score for the first time. Without a previous knowledge of the score, I found myself reading the words first. I believe you need to really know your character's intentions cold before you even come anywhere near a stage. 

### The cast is pretty exciting. Is there anyone you're excited to sing with or to sing with again? 

Well, I talked about it a little before but I'm really excited to sing with Julie Nesrallah. She's a real, true, mezzo with a rich, dark, powerful sound. I think we sound really good together, and we have a great personal chemistry; it's like we're sisters. Also, [Michael Barrett](/scene/people/michael-barrett/), who's playing Osiris, and I overlapped a little at Opera School. It'll be good to sing with him again. 

### Have you sung with VOICEBOX: Opera In Concert before? 

No, I've worked with Guillermo before at [Toronto Operetta Theatre](/scene/companies/toronto-operetta-theatre/), but this is my first time with this company. And while we're at it, we start rehearsals on Monday because this Opera In Concert, isn't in concert at all - we're staging it fully. 

### What's the most exciting part of learning a show?

I feel it's when you finally get to work with everyone else. After all the practicing in a vacuum you do to learn, it's always amazing to hear the score fully with all its parts, and to actual have a real person there to play off of, instead of what you think they might do when you're in a practice room or studio pretending to look at them. 

### Now for something a little more personal - what are your three favourite songs right now? 

Hands down: "Work" by Rihanna and Drake. I saw the video, it kinda makes me wish that The Real Jerk was a club like that all the time. My second choice is probably going to be pretty unpopular, but it's "Sorry" by Justin Bieber. It's just a really good song. The third I discovered on this thing called "Tinydesk". It's by NPR, and they have these super intimate concerts, like 30 people in a room, and they bring in bands they like for acoustic and pared down versions of their songs. This group is called [Lake Street Dive](http://www.lakestreetdive.com/) and the singer, Rachael Price is really amazing. 

### Last but not least, what's next for Lucia? 

Susanna in *Le nozze di Figaro* under the baton of James Conlon. It's my Italian debut and we're performing in Spoleto, Italy. I spent a lot of time in Italy growing up (my family has a house there) so I'm going to get to go around and visit some of my favourite places while I'm there. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1458652441256/2016-03-22---ISIS-and-Osiris_eFlyer.jpg.jpg)
</figure>

***

So there you have it, right from the soprano's mouth. I want to thank Lucia for having me over and opening her beautiful home to me while we did this. The whole conversation was recorded, and with enough prodding we could possibly see this develop into my kind of podcast. But in the meantime, check out Lucia's own website, [here](http://luciacesaroni.com/index.html). 

>VOICEBOX: Opera In Concert presents [*ISIS AND OSIRIS: Gods of Egypt*](http://www.operainconcert.com/IandO.html), conducted by Robert Cooper, and featuring the VOICEBOX: Opera In Concert Chorus at the Jane Mallett Theatre in the St. Lawrence Centre for the Arts, April 1-3, 2016. For full details and ticket information, follow our box office links below.
