+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2014-11-20T10:00:00-05:00"
lastmod = "2015-04-14T10:07:00-04:00"
preamble = "Next Tuesday, November 25th, the seven finalists from the national auditions for the [Canadian Opera Company's Ensemble Studio](http://www.coc.ca/AboutTheCOC/CompanyMembers/EnsembleStudio.aspx) will compete for precious few spots in the coveted young artist programme. Hosted by the beloved Canadian tenor [Ben Heppner](http://www.benheppner.com/), the event is called [_Centre Stage_](http://coccentrestage.ca/), and it's an ongoing evolution of the audition process for these young singers. I've watched the competition for a few years now, biting my nails in empathetic nerves; I love that it's grown from a closed audition process, to a finals round in the Richard Bradshaw Amphitheatre, and finally to its current (and grand) form, on the stage of the Four Seasons Centre with Johannes Debus leading the COC Orchestra. It's a big night for these young singers, and I wanted to check in with them before the big day. In no particular order:"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429020432603/Centre-Stage%20(1).jpg.jpg"
publishDate = "2014-11-20T10:00:00-05:00"
related_articles = ["articles/ben-heppner-to-host-the-coc-ensemble-studio-competition-gala.md","articles/the-coc-ensemble-studio-meet-the-newbies.md","articles/centre-stage-2014-lets-hear-it-for-the-boys.md","articles/go-hear-the-tafelmusik-vocal-competition.md"]
related_companies = ["scene/companies/canadian-opera-company-ensemble-studio.md","scene/companies/canadian-opera-company.md"]
related_people = ["scene/people/charles-sy.md","scene/people/eliza-johnson.md","scene/people/zoe-band.md","scene/people/michelle-siemens.md","scene/people/dimitri-katotakis.md"]
short_description = "Next Tuesday, November 25th, the seven finalists from the national auditions for the Canadian Opera Company&#039;s Ensemble Studio will compete for precious few spots in the coveted young artist programme. Hosted by the beloved Canadian tenor Ben Heppner, the event is called Centre Stage, and it&#039;s an ongoing evolution of the audition process for these young singers."
slug = "centre-stage-7-finalists-compete-in-the-cocs-ensemble-studio-competition-gala"
title = "Centre Stage: 7 finalists compete in the COC&#039;s Ensemble Studio Competition Gala"
+++

## Charles Sy, tenor (Toronto)

**1\. What makes a good competitor?**

Quite frankly, a strong constitution and nerves of steel. Full opera performances are always fun to be a part of because at that point your performances have been well-rehearsed (hopefully...) and you are doing what you love to do. Competitions are along the same track but there is an additional necessity to perform to the best of your ability right then and there. One shot to get it right. Of course, as a singer your whole career is about being judged and compared to others. In a competition, the comparison is just a little more tangible and real. I think the most important thing to remember is that all competitions are a crapshoot and you just can't take anything personally. Take everything constructively and critically and decide whether or not the result is real and should be addressed for future reference or if it is just ONE person's personal opinion that can be thrown away for now. There are just so many variables when it comes to doing well in competitions beyond how your voice sounds on that particular day. Once your mindset switches from "This has to be the best performance of my life" to "This is a representation of who I am right now. Take it or leave it." then you start to take a lot of the pressure off of yourself and can just enjoy what it is that you love to do.

**2\. Do you have a performance day routine? Lucky underwear?**

When possible, I like to be in bed by 9:30pm the night before a performance. I always start the day with a nice, big breakfast and then go for a jog to wake up my body before the performance. Unfortunately, I have not found any of my undergarments to be particularly lucky. However, whenever possible, I like to wear a silver chain bracelet and titanium/black onyx ring that I got as gifts from my mother. She is definitely my biggest fan and has been such a huge support during my entire singing career. It is comforting to know that regardless of all of the many variables involved in performing, from sickness to thick vocal folds to extremely dry and acoustically poor performance spaces, that there is something on stage with me that I know is consistent and never changing.

**3\. What do you anticipate most during the evening?**

The opportunity to sing on the main stage of The Four Seasons Centre of course! After years and years of being inspired by watching great opera in my hometown, I now have the opportunity to be on that coveted stage. It has been a dream of mine to sing in that hall ever since I first became interested in opera and after all of these years it is finally going to happen. To top it all off, I have the privilege of performing with the renowned COC orchestra led by the incredible Johannes Debus. This is not an opportunity that comes every day and I plan to enjoy every minute of it. One of my favourite parts of being an opera singer is being backstage when the orchestra is tuning. It is a simple pleasure that I never take for granted and reminds me how much I have to be thankful for before every performance.

**4\. What role does this competition play in your development as a professional singer?**

In my opinion, every performance is a new opportunity and challenge to grow as a singer and also as a person. This competition is by far one of the biggest challenges I have ever had to face. It is funny that the two arias that were selected for me in the final round happen to be two of the very first arias I ever learned in my formal studies as a classical singer. It has all come back full circle and it is as if I have been preparing for this one performance for the last 6 years of my life. Of course, this competition is not the finish line but rather the next hurdle in my career path. Regardless of the outcome on November 25th, I hope that another six years from now, I can look back to this day and see how much it has taught me in order to deal with the newer opportunities and challenges I will be facing in the future.

**5\. What will be your goal when you step on the Four Seasons Centre stage?**

The thing a lot of people don't know about me is that I have (or at least used to have) horrible stage anxiety. Before walking on stage, I always felt like I was going to vomit and felt the need to go to the bathroom. On stage, my legs would shake and my voice would waver. There were many times in my life that I figured that there was no way that this was the right career path for me. As time went on and I got more performing experience, I was able to experiment with different levels of positive self-talk before and during a performance. This year has been one of the most vocally intense years of my life, from being a vocal fellow at Marilyn Horne's [Music Academy of the West](http://www.musicacademy.org/) in Santa Barbara, California, to winning the grand prize at this year's Jeunes Ambassadeurs Lyriques gala performances in Montreal and now a finalist in one of the most important young artist competitions in Canada. After years of performing with debilitating fear, I am now able to remind myself that it is a privilege to be on stage as a singer. I have been given the opportunity to share my love for what I do and to communicate with an audience that is willing to listen. I have no right to be afraid. Win or lose, if I am able to communicate with every audience member in that hall and not be hindered by gripping fear then I will have considered the night a success.

***

## Michelle Siemens, mezzo-soprano (Calgary)

**1\. What makes a good competitor?**

A good competitor competes with his or her own self. Comparing yourself to the competition is pointless because the only performance you can control is your own. Obviously it’s not the easiest mindset to maintain, but a good competitor will try and keep it in mind. I’ve found that the best way to maintain a positive mindset for any competitive situation is to wish for the best performance possible for everyone involved.

**2\. Do you have a performance day routine? Lucky underwear?**

On performance days I like to be sure that I’m well rested and also try to fit in a workout so that I can be physically warmed up and engaged. Backstage, I like to have water with lemons and a couple of granny smith apples with me. A few high energy dance moves are also great for getting pumped up.

**3\. What do you anticipate most during the evening?**

I am most looking forward to the sight of the Four Seasons Centre from the perspective of the stage. It is a view that I’ve dreamed of seeing from the singers’ side. I just hope that I will be able to soak in the moment as much as possible.

**4\. What role does this competition play in your development as a professional singer?**

The competition is a crucial step to bridge the divide between being a student and a professional. After years of being a student it can be hard to recognize when it is the right time to trust that you are ready vocally and artistically to enter the professional realm. This competition and the possibility of entering the COC Ensemble, are ways to support this challenging transition.

**5\. What will be your goal when you step on the Four Seasons Centre stage?**

My goal is to breathe, have fun, and take in the moment. I want to experience the joy of the art form in which I have invested all of myself and, as always, to share a meaningful connection with the audience.

***

## Aaron Sheppard, tenor (St. John's)

**1\. What makes a good competitor?**

I think a good competitor is someone that isn't afraid to make a mistake, or take a chance. I believe this keeps everything interesting and fresh during a performance.

**2\. Do you have a performance day routine? Lucky underwear?**

I just like doing what I would do on a regular day, maybe sleep-in a little bit if the performance is at night.

**3\. What do you anticipate most during the evening?**

I am driven by performance, so I can’t wait to get out there and feel the support and atmosphere that the audience creates.

**4\. What role does this competition play in your development as a professional singer?**

This competition is a fantastic way to get invaluable performance experience, with an orchestra. I think it's a great stepping stone for all young aspiring singers.

**5\. What will be your goal when you step on the Four Seasons Centre stage?**

I would love to just be proud of my performance, and have a fun time while doing so.

****

## Zoe Band, mezzo-soprano (Toronto)

**1\. What makes a good competitor?**

I think being kind and friendly to everyone involved in the competition process ensures happy feelings and a positive experience for all. You can’t control how other competitors treat you, but exuding positive energy always makes me feel my best. At the same time, I try to forget that I’m a competitor and focus instead on my performance. This approach helps me to perform most openly and achieve the kind of result I strive for.

** 2\. Do you have a performance day routine? Lucky underwear?**

I regard the performance day like any other day. The goal is to sing well everyday and to practice with the same intensity, whether or not I am preparing for a specific concert. Throughout the day, I warm up on three separate occasions, singing a bit more each time. I like to eat a lot of protein. About six months ago I cut gluten from my diet, and try to avoid coffee and dairy. Coffee is tough to eliminate! As a result, my energy level has improved significantly and contributed to the consistency of my singing. Is lucky underwear a thing? Perhaps I should try it out!

**3\. What do you anticipate most during the evening?**

I love anticipating the reaction the audience will have to what I am able to express. When I sing, my main endeavor is to communicate – to make people experience and feel the meaning of the words and notes I am singing. I love that moment when the audience is absolutely still, caught up in the music, and transported to another world. I look forward to that kind of moment, to that kind of bond with the audience.

**4\. What role does this competition play in your development as a professional singer?**

The thrill of having been chosen as a finalist from such a large pool of singers has given me a great shot of confidence. There is nothing like a competition to make you concentrate on your technique and fine-tune the nuances of your repertoire and performance. My intense focus and drive in the weeks leading up to the competition is a constant reminder of my passion for music and all it can communicate. I’m only getting better in these times and the deadline of a competition intensifies that experience.

**5\. What will be your goal when you step on the Four Seasons Centre stage?**

Probably to get a hug from Ben Heppner! He is an inspiration. Of course, my goal is to be able to immerse the audience in beautiful singing and pull off the performance that I hear in my mind when I rehearse. If the audience goes quiet and believes the words I am singing and the character I am portraying, then I know I will have achieved the goal I continue to work toward every day. For me the goal isn’t only stepping on the stage, but transporting the audience through the music I am able to sing.

****

## Dimitri Katotakis, baritone (Toronto)

**1\. What makes a good competitor?**

Competition is a word with such a diverse set of meanings. Someone in an artistic competition has to be first-most aware of why they are making art. They have to have respect for their goal as an artist, which I think is ideally to communicate the meaning and humanity of their piece. A good competitor, much like a good singer in general should be able to roll with the punches, to share their love for music despite changing circumstances. Lastly, they should be able to enjoy the whole process, to share that joy with their colleagues (their fellow ‘competitors’) and their audience. The gray area between nervous and comfortable is where art thrives, and joy magnifies the whole process.

**2\. Do you have a performance day routine? Lucky underwear?**

On days that I perform I usually take it pretty easy, save my energy for the big event. That said, I usually like to move around, keep my body fluid. I try to exercise in some way. Another thing that I like to do is listen to a whole album that I enjoy. Some days it’s symphonic music, others art song, some days it’s Queen, Miles Davis or Jeff Buckley. Something that refreshes me and makes me remember the power of music. Other than that, it’s get my clothes all together, have a nice warm up and start getting ready to go!

**3\. What do you anticipate most during the evening?**

I’m looking forward to the end of my first piece. The combination of feeling ‘done’ with the expectation of being able to get back on stage to do it all over again is such an overwhelming feeling.

**4\. What role does this competition play in your development as a professional singer?**

This competition marks my first foray the professional singing world for me so it’s quite exciting. Before this it's been school and summer programs with occasional other concerts. I’m excited to finally get the chance to show some of what I’ve been learning all these years!

**5\. What will be your goal when you step on the Four Seasons Centre stage?**

Right now my goal for this performance is not to be perfect or show everyone the culmination of myself as an artist, but rather to just have fun. I want to be able to step off of the stage and think to myself “I made music out there”.

***

## Eliza Johnson, soprano (Stratford)

**1\. What makes a good competitor?**

You ask as if I am an expert! Aside from all of the obvious vocal and dramatic demands, it’s all about mindset. Maintaining a grounded, calm, and impenetrable relaxed state is ideal in dealing with many unpredictable elements that will arise. A good competitor is focused, self-assured, confident, kind and gracious. A good competitor is always supportive of fellow competitors.

**2\. Do you have a performance day routine? Lucky underwear?**

I’ve made many lifestyle adjustments as I have progressed in my life as a singer. Since our job can be so physically, emotionally, and mentally demanding, I really strive to maintain balance and health in my daily life, in order to support my singing.

Performance day is really no different than any other day. Having recently finished a school tour of _The Magic Flute_ (for young audiences) with Opera Lyra, I’ve had an epiphany that I think is worth sharing. As performers, we are faced with many elements that are beyond our control: traffic, weather, sickness, accidents, injury, etc. There is no perfect set of circumstances in the world that will bring about a better or worse performance. It truly is all about focus and commitment.

That said, when I do have the opportunity to choose the way I prepare, performance days always start with a big breakfast. I find time to exercise, meditate, and definitely listen to some pump-up music on my commute to a venue.

**3\. What do you anticipate most during the evening?**

That electric feeling right before I go on stage. I’m also very excited to sing with the COC Orchestra! The Four Seasons Centre is a really magical venue.

**4\. What role does this competition play in your development as a professional singer?**

Well, it’s hard to say what the future will hold. It has been a real privilege to be chosen as a finalist for this year’s competition. The media attention and exposure is definitely a good thing for my career, regardless of the results, and participating in such an illustrious competition will surely benefit me in the future as I continue to make valuable connections in the industry. If I am chosen to join the Ensemble Studio, well that’s a whole new ballgame!

**5\. What will be your goal when you step on the Four Seasons Centre stage?**

I plan on being pretty single-minded in my focus. I want to tell a story: to inspire the imagination of the audience and transport them to a different time and place.

I recently received an overwhelming compliment from a patron after a concert. She rushed up to me and joyously told me that my singing made her dream. I want nothing more than to be totally present and available in my body, mind, heart, and especially in my voice, in order to bring these epic operatic characters to life and to inspire the audience to dream along with me!

***

## Nathan Keoughan, bass-baritone (Charlottetown)

**1\. What makes a good competitor? **

I think any good competition singer needs to be self aware of their strengths with a healthy dose of reality. Confidence is necessary but no one needs to see an ego. Though I tend to look at this is a competition more as a grandiose audition into an incredible company. I’ve never been much of a "competitive singer".

**2\. Do you have a performance day routine? **

I try to keep performance days as regular as possible. It generally starts with coffee and YouTube. If I’m really on my game I'll try to go to the gym. I find it helps with my air. But If I don’t make it to the gym, that’s okay too…

**3\. What do you anticipate most during the evening? **

Well of course I’m very excited to have the opportunity to perform with the COC orchestra again. But I must say I most look forward to the 30 seconds following my performance. It can hit you like a shock of electricity, and I imagine they feel very similar. You’re heart rate sky rockets, hands and feet go numb. The adrenaline lasts until you walk backstage and remember it’s a competition and you’re about to be publicly rated. But it’s all worth it for that performance rush.

**4\. What role does this competition play in your development as a professional singer?**

It’s all about experience, ain’t it? The evening is designed to be a wonderful platform for a few of us lucky singers to have some Toronto spotlight and to try to make some connections while we can. The biggest impact I’ve had from this competition in the past was the opportunity to sing in that incredible hall without amplification.

**5\. What will be your goal when you step on the Four Seasons Stage?**

Breathe.

***
