+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2014-11-26T10:12:00-05:00"
lastmod = "2015-04-13T11:00:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428937040209/sy.jpg.jpg"
primary_image_credit = "Charles Sy, tenor"
publishDate = "2014-11-26T10:12:00-05:00"
related_articles = ["articles/ben-heppner-to-host-the-coc-ensemble-studio-competition-gala.md","articles/the-coc-ensemble-studio-meet-the-newbies.md","articles/centre-stage-7-finalists-compete-in-the-cocs-ensemble-studio-competition-gala.md","articles/she-saidhe-said-centre-stage-2015.md"]
related_companies = ["scene/companies/canadian-opera-company.md","scene/companies/canadian-opera-company-ensemble-studio.md"]
related_people = ["scene/people/adrianne-pieczonka.md","scene/people/nathan-keoughan.md","scene/people/eliza-johnson.md","scene/people/ben-heppner.md","scene/people/charles-sy.md","scene/people/aaron-sheppard.md","scene/people/zoe-band.md","scene/people/michelle-siemens.md","scene/people/dimitri-katotakis.md"]
short_description = "Last night the seven finalists of the COC&#039;s Ensemble Studio Competition sang on the stage of the Four Seasons Centre for the second annual Centre Stage Gala. I like this event, and I like the hype it brings to this exciting part of today&#039;s opera world. This year, Centre Stage was hosted by Canada&#039;s favourite tenor, Ben Heppner, who was as warm and funny as he was respectful of the competitors. "
slug = "centre-stage-2014-lets-hear-it-for-the-boys"
title = "Centre Stage 2014: Let&#039;s Hear It For the Boys"
+++

Last night the seven finalists of the COC's Ensemble Studio Competition sang on the stage of the Four Seasons Centre for the second annual <a href="http://coccentrestage.ca/" target="_blank">Centre Stage Gala</a>. I like this event, and I like the hype it brings to this exciting part of today's opera world. This year, Centre Stage was hosted by Canada's favourite tenor, <a href="http://www.benheppner.com/" target="_blank">Ben Heppner</a>, who was as warm and funny as he was respectful of the competitors. The seven singers, dressed in tuxedos and gowns from the Hudson's Bay Company (bonus prize indeed!), each sang two arias with the COC Orchestra under the baton of Music Director <a href="http://www.coc.ca/AboutTheCOC/CompanyMembers/Orchestra/JohannesDebus.aspx" target="_blank">Johannes Debus</a>. The orchestra began the night with the overture from Nicolai's&nbsp;<em>Die Lustigen Weiber von Windsor</em>, and reminded the audience just how well they play together. Also, I'm partial to the Nicolai&nbsp;<em>Merry Wives</em> over the more common Lehar, so I was excited to hear it. Four prizes are awarded: first ($5000), second ($3000), and third place ($1500) by the judging panel, as well as an Audience Choice award ($1500). The cash is always nice, but the real prize for this competition is an invitation to join the coveted COC Ensemble Studio Young Artist Program.<p></p><p>Three singers took the four prizes on Tuesday night. Tenor <a href="http://www.coc.ca/exploreandlearn/newtoopera/onlinelearningcentre/parlandothecocblog.aspx?EntryID=46712" target="_blank">Aaron Sheppard</a> (St. John's, NL) won&nbsp;third prize, baritone <a href="http://www.coc.ca/ExploreAndLearn/NewToOpera/OnlineLearningCentre/ParlandoTheCOCBlog.aspx?EntryID=46737" target="_blank">Dimitri Katotakis</a> (Toronto) won second, and tenor <a href="http://www.coc.ca/ExploreAndLearn/NewToOpera/OnlineLearningCentre/ParlandoTheCOCBlog.aspx?EntryID=46757" target="_blank">Charles Sy</a> took home both first prize and the Audience Choice award. I had my own personal top three in my head as the judges deliberated, and I'm historically terrible at predicting competition winners. Centre Stage isn't simply about how these singers&nbsp;give an isolated performance; this is the final of several rounds of North American auditions, as well as an intensive week of work with the COC artistic staff. The judges know these finalists well by the time they hear them at the competition, and the results may reflect that (further skewing my already bad competition-radar).</p><p>I thought Charles Sy truly gave the night's best performance. He was vocally and dramatically mature, with a delicious dark tenor sound that stretched easily into shining high notes. He sang "Dies Bildnis ist bezaubernd schön" (<em>Die Zauberflöte</em>), and "Una furtiva lagrima" (<em>L'elisir d'amore</em>), and he delivered both like a well-wrapped present with a bow on top. Technically, Charles nailed the notably tricky spots in both arias, like the last page of the Mozart (terrifying and ceaselessly in the&nbsp;<em>passaggio</em>), or the very first entrance of the Donizetti (that [u] vowel on an F, tricky stuff). He deserves accolades for being a smart singer, but he also gave the first real moments of storytelling. He didn't let any physicality distract us from his seriously gorgeous sound, but he filled all the silences, bridged all the dramatic beats, and gave us a&nbsp;<em>person</em> instead of an aria. Well done, Mr. Sy, and congratulations.</p><p><span data-sc-tag="[caption id=&quot;attachment_2231&quot; align=&quot;aligncenter&quot; width=&quot;456&quot;][/caption]" class="sc-node sc-node-caption"></span></p><p>Baritone Dimitri Katotakis sang the Count's Aria (<em>Le nozze di Figaro</em>),&nbsp;followed by&nbsp;"Mab, la reine des mensonges" (<em>Roméo et Juliette</em>), and proved himself surprisingly chameleon-like. I thought he paced the Mozart in a smart way, not falling into the dramatic traps of playing a blustery, vengeful character. He kept his cool the whole time, giving a more mature telling of the Count's story. It's essentially an aria about revenge, however, and I missed a bit of the fire and brimstone that exists in Mozart's writing. I&nbsp;wondered if Dimitri's choice to focus on solid singing robbed us of some of the dramatic possibilities. In the Gounod, Dimitri embodied a totally different character,&nbsp;and almost sang with a new voice. He was wisely light and agile and was comfy with the endless French. At times&nbsp;he drifted from light singing into crooning, but Dimitri's&nbsp;voice carried well and his was the easiest, most in-control performance of this tricky aria that I've heard.</p><p>Tenor Aaron Sheppard sang two more beloved tenor arias; he started with Lalo's "Vainement, ma bien aimée" (<em>Le roi d'Ys</em>), followed by "Un'aura amorosa"&nbsp;(<em>Così fan tutte</em>). I thought he had a nice masculine sound, and he reminded me of Jerry Hadley. He tended to hold his sound a bit, and we missed some legato and there were moments of intonation problems.&nbsp;He has what I think will become a really heroic top, and he still gave us two beautiful high As in the Lalo. Out of the men, however, I was most looking forward to hearing bass-baritone <a href="http://www.coc.ca/ExploreAndLearn/NewToOpera/OnlineLearningCentre/ParlandoTheCOCBlog.aspx?EntryID=46731" target="_blank">Nathan Keoughan</a>. He's a returning competitor, and I've been able to follow his development a little bit over the last couple of years. He started with "La calunnia è un venticello" (<em>Il barbiere di Siviglia</em>), and finished with "Se vuol ballare" (<em>Le nozze di Figaro</em>). I really love Nathan's voice, and I love that he's made some huge technical advancements. His top is slimmer and he approached those blasted high Fs in the Mozart with a gentler attack; it made them reliable and melodic, rather than the whole crux of the aria. Nathan has this really thrilling, throaty, virile sound that he now carries from bottom to top. He was in my pick for the top three, no question.</p><p><span data-sc-tag="[caption id=&quot;attachment_2232&quot; align=&quot;aligncenter&quot; width=&quot;456&quot;][/caption]" class="sc-node sc-node-caption"></span></p><p>Onto the ladies, who were, for the first time in my own competition history, the minority amongst the finalists. Mezzo-soprano <a href="http://m.coc.ca/Parlando.aspx?EntryID=46713" target="_blank">Michelle Siemens</a> was the first competitor to sing, giving us&nbsp;Donizetti's "All'afflitto è dolce il pianto" (<em>Roberto Devereux</em>) and "Voi che sapete"&nbsp;(<em>Le nozze di Figaro</em>). I met Michelle this past summer in St. John's, and I heard some really exciting changes in her singing last night. In the Donizetti, she showed off her clean and warm top, and some juicy low notes to boot. Her Mozart was young and fresh-sounding, maybe a tiny bit less nervous. I was super happy for Michelle; she has all the stuff of an incredibly versatile and exciting mezzo-soprano sound.</p><p>Mezzo-soprano <a href="http://www.coc.ca/exploreandlearn/newtoopera/onlinelearningcentre/parlandothecocblog.aspx?EntryID=46736" target="_blank">Zoe Band</a> showed off a lighter, brighter mezzo sound, and took on two cornerstone arias: "Parto, parto, ma tu ben mio" (<em>La clemenza di Tito</em>) and "Must the Winter Come So Soon" (<em>Vanessa</em>). In the Mozart, she showed really smart pacing of the taxing aria, and the affect was a more loving take on Sesto, rather than decisive. When Zoe got to those famous triplet runs near the end, she chose to keep it light (wise), but I felt she got off her voice a bit too much, and she needed a quicker tempo than was set up. In the Barber, I got to hear more of her long lines, which stretch and spin beautifully; I felt like she was holding her voice back, in position and in freedom, and it kept us from getting the full impact of her truly beautiful sound.</p><p><span data-sc-tag="[caption id=&quot;attachment_2233&quot; align=&quot;aligncenter&quot; width=&quot;456&quot;][/caption]" class="sc-node sc-node-caption"></span></p><p>The sole soprano in this year's competition, <a href="http://www.coc.ca/exploreandlearn/newtoopera/onlinelearningcentre/parlandothecocblog.aspx?EntryID=46719" target="_blank">Eliza Johnson</a> finished off the night with gorgeous renditions of "Padre, germani, addio" (<em>Idomeneo</em>) and "Je veux vivre"&nbsp;(<em>Roméo et Juliette</em>). I'm a big fan of Eliza's; I think she's absolutely someone to watch in the coming years. Her Mozart was liquid and sobbing, but entirely clean and using the voice as the sole storytelling device. Her Juliette was some much-needed excitement after several slow-ish arias on the program, and she sang it with that young, fragile sound that's so important in this aria. The grace notes and the middle-voice writing throughout much of the aria was warm and graceful, and she climbed up to the top of her range with lots of focus and clarity. I loved her performance, and Eliza was also one of my top three picks.</p><p>While the judges deliberated, we got to hear a surprise performance by ridiculous Canadian soprano <a href="http://www.adriannepieczonka.com/" target="_blank">Adrienne Pieczonka</a>. I was in heaven as she sang&nbsp;"Ebben, ne andrò lontana" (<em>La Wally</em>), "Pace, pace mio Dio!" (<em>La forza del destino</em>), and Richard Strauss' gorgeous "Zueignung". It was a great performance, of course, and it was also great to hear a real pro sing after hearing the seven rising young singers. Adrienne's singing, so closely programmed to the finalists, gave us a really clear picture of what young singers strive to do, and what's possible when it comes to vocal development. Not a bad way to pass 15 minutes, I'd say.</p><p><span data-sc-tag="[caption id=&quot;attachment_2234&quot; align=&quot;aligncenter&quot; width=&quot;638&quot;][/caption]" class="sc-node sc-node-caption"></span></p><p>I thought this year's Centre Stage Gala had the right vibe to it, and I hope this is the precedent that is set for future years. The event was simple and well-paced, and I loved that the singers were able to sing both of their arias for the audience (in 2013, the public only got to hear their second selection). Ben Heppner was the best possible choice to host the gala; he's a graduate of the COC Ensemble Studio, and his humble, respectful air brought the event to a level of seriousness that the competitors really deserve.&nbsp;I disagreed with the final results of the competition (save for Charles Sy's First Prize and Audience Choice Award), but I know that there are factors in play beyond the finalists' singing last night. I had a great time watching, and I'm thrilled for the seven singers who got to do a really big thing: sing on the stage at the Four Seasons Centre. Bravi, guys.</p>
