+++
author = ["authors/michael-pecak.md"]
categories = "Review"
date = "2018-03-12T12:30:00-04:00"
lastmod = "2018-03-12T13:01:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1546218826/media/2018/12/sq-Bernstein-LOC-Susan-Graham-Kate-Baldwin-pc-Todd-Rosenberg.jpg"
primary_image_credit = "Susan Graham and Kate Baldwin in Lyric Opera of Chicago's Celebrating 100 Years of Bernstein, 2018. Photo: Todd Rosenberg."
publishDate = "2018-03-12T13:01:00-04:00"
related_companies = ["scene/companies/lyric-opera-of-chicago.md"]
related_people = ["scene/people/susan-graham.md"]
short_description = "How can one not be enchanted? This is the same Bernstein-ian smile I recognize in my teachers&#039; recollections of their mentor, the same smile that, to my ears, permeates his whole artistic output, and the same smile that suffused the Lyric Opera of Chicago&#039;s commemorative Bernstein concert this past Saturday at the Lyric Opera House."
slug = "celebrating-bernstein-in-chicago-how-can-one-not-be-enchanted"
title = "Celebrating Bernstein in Chicago: &quot;How can one not be enchanted?&quot;"

+++
I was only four years old when Leonard Bernstein died in 1990 – just too young to have had any real, direct contact with the man. I have, however, over the course of my education, had the good fortune of studying with two teachers who are bona fide Bernstein progeny (pianist André Watts and conductor Victor Yampolsky), whose personal and professional lives were formed by and indebted to the great artist. In lessons, "Lenny" was ever-present: "You know, Lenny used to say…", "When I did this with Lenny...", "Lenny had a marvelous way of...". Their Bernstein anecdotes were ample and I gleefully soaked up the details, hoping to extract as much vicarious wisdom and experience as possible. Over the years, and thanks to the treasure-trove that is YouTube, I've absorbed further Bernstein's prolific legacy: the composer, pianist, conductor, teacher, thinker, humanitarian.

Yet, for all the man's copious talents and myriad achievements, for all his eloquence, erudition, enthusiasm, and energy, for all the contributions for which we love and celebrate him now, the thing that always impresses itself on me the most after watching his videos or listening to his music is…his smile. It's extraordinary: at once welcoming, empathetic, confident, vulnerable, sly, perceptive, poignantly communicative, deeply human, and simply infectious. Perhaps I'm being sentimental, but just watch this brief video of him "conducting" the Vienna Philharmonic in the fourth movement of Haydn’s Symphony No. 88:

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/oU0Ubs2KYUI" frameborder="0" allow="autoplay; encrypted-media" allowfullscreen></iframe>
</figure>

How can one not be enchanted? This is the same Bernstein-ian smile I recognize in my teachers' recollections of their mentor, the same smile that, to my ears, permeates his whole artistic output, and the same smile that suffused the [Lyric Opera of Chicago](/scene/companies/lyric-opera-of-chicago/)'s commemorative Bernstein concert this past Saturday at the Lyric Opera House.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1520871864365/18.-Bernstein-%40LOC%2C-l.r.-Diana-Newman%2C-Ann-Toomey%2C-Josh-Lovell%2C-Alan-Higgs%2C-Emmett-O'Hanlon%2C-Susan-Graham%2C-Nathan-Gunn%2C-Kate-Baldwin_c.Todd-Rosenberg.jpg.jpg)
<figcaption>(l-r) Diana Newman, Ann Toomey, Josh Lovell, Alan Higgs, Emmett O'Hanon, Susan Graham, Nathan Gunn, and Kate Baldwin in Lyric Opera of Chicago's _Celebrating 100 Years of Bernstein_, 2018. Photo: Todd Rosenberg.</figcaption>
</figure>

As befits an opera company, LOC showcased Bernstein as the man of the theatre with a cornucopia of delights — classics and less-familiar numbers alike — from his _West Side Story_, _Candide_, _Wonderful Town_, _On the Town_, _Peter Pan_, and _A White House Cantata_ (a repurposed version of his unsuccessful 1976 musical _1600 Pennsylvania Avenue_). From this latter work, Broadway superstar Kate Baldwin, singing as then-first-lady Abigail Adams, delivered an especially touching rendition of "Take Care of this House." Equally moving and memorable was her performance of "So Pretty," a disarmingly innocent antiwar song Bernstein composed in 1968 and first sung by Barbara Streisand at the fundraiser "Broadway for Peace." While Baldwin’s crystalline and expressive voice was superb in these unaffected numbers, "Somewhere" from _West Side Story_ felt lacking in the dramatic sweep so central to this enduring favorite. Nonetheless, the Tony-award-winner razzled and dazzled in "I Can Cook, Too" and "I Hate Music" from Bernstein's delightful song-cycle of the same title. Here she was clearly in her element with LOC's William C. Billingham accompanying deftly on the piano and channeling his inner Hoagy Carmichael.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1546218887/media/2018/12/10-Pianist-William-Billingham-Kate-Baldwin-pcTodd-Rosenberg.jpg)<figcaption>Pianist William Billingham and Kate Baldwin in Lyric Opera of Chicago's _Celebrating 100 Years of Bernstein_, 2018. Photo: Todd Rosenberg.</figcaption>
</figure>

Sharing the stage with Baldwin were opera luminaries Susan Graham and Nathan Gunn. Renowned for dramatic French repertoire (at LOC she recently sang Dido in Berlioz's epic _Les Troyens_), Graham was utterly arresting in Wendy's "Dream with Me" from _Peter Pan_. The mezzo's honeyed Texas tone enveloped the auditorium in a plush blanket of sheer vocal splendor. Gunn, on the other hand, was hilarious in "Captain Hook's Soliloquy" from the same musical. Clad in a wig of black curly locks and wielding the signature hook-hand, Gunn emerged from the center-stage trap door eager to persuade us that the otherwise blustering buccaneer is really just a sadly misunderstood soul. Gunn's was a virtuosic performance as regards both singing and physical comedy.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1520871911113/16.-Bernstein-%40LOC%2C-Nathan-Gunn-as-Capt.-Hook_c.Todd-Rosenberg.jpg.jpg)
<figcaption>Nathan Gunn as Captain Hook in Lyric Opera of Chicago's _Celebrating 100 Years of Bernstein_, 2018. Photo: Todd Rosenberg.</figcaption>
</figure>

This potpourri of Bernstein hits by three great singers would have been delight enough, but the real treat of the evening was the complete performance of his 1952 one-act opera Trouble in Tahiti. Peggy Hickey directed the semi-staged production; Gunn and Graham sang, respectively, the main roles of Sam and Dinah, a middle-class couple who have grown distant and disenchanted with married-life. Tahiti offers a succinct and poignant glimpse into post-World-War-Two American life. All that glitters is not gold indeed, despite the ostensible societal optimism of the time and despite Bernstein's glittering music. A Jazz vocal trio, acting as a kind of Greek chorus, punctuates the show and extols the creature-comforts of 1950s suburbia. LOC Ryan Opera Center members Diana Newman, Josh Lovell, and Emmett O'Hanlon scatted their way in and out of scenes with terrific precision, humor, and sounding as if they had come straight out of a 50s radio commercial.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1546218989/media/2018/12/1-Bernstein-LOC-TROUBLE-IN-TAHITI-Susan-Graham-Nathan-Gunn-cTodd-Rosenberg.jpg)<figcaption>Susan Graham and Nathan Gunn in Lyric Opera of Chicago's _Celebrating 100 Years of Bernstein_, 2018. Photo: Todd Rosenberg.</figcaption>
</figure>

Sam and Dinah clearly want to save their marriage and rekindle their love yet fail agonizingly at even the most basic attempts at communication. Here Gunn and Graham captured their characters' cold loneliness with unsettling conviction. Derisive of his wife and more interested in winning his handball tournament than attending his son's school play, Sam is the archetypical mid-century American "man's man." Gunn conjured his best Don Draper for the part all while singing with a commanding lyric baritone, especially in his (cringe-worthy) aria, "There's a law."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1520871887999/9.-Bernstein-%40LOC%2C-TROUBLE-IN-TAHITI%2C-l.-r.-Josh-Lovell%2C-Emmett-O'Hanlon%2CSusan-Graham%2C--Diana-Newman_c.Todd-Rosenberg.jpg.jpg)
<figcaption>(l-r) Josh Lovell, Emmett O'Hanlon, Susan Graham, and Diana Newman in Lyric Opera of Chicago's _Celebrating 100 Years of Bernstein_, 2018. Photo: Todd Rosenberg.</figcaption>
</figure>

Graham played Dinah with heart-wrenching restraint with the notable exception of the opera's best-known number, "What a movie…Island Magic". This riotous, colorful, and decidedly not-PC aria benefits from a kind of Robin Williams vividness, painting a picture of South Pacific exotica, tribal natives, erupting volcanoes, dashing U.S. Navy sailors, etc. Graham was stellar in how she conveyed the inane details of the film while also clearly being swept away by the escapist fantasy it offered her. Here was that Bernstein-ian smile in all its glory.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1520871937686/17.-Bernstein-%40LOC%2C-Susan-Graham_c.Todd-Rosenberg.jpg.jpg)
<figcaption>Susan Graham in Lyric Opera of Chicago's _Celebrating 100 Years of Bernstein_, 2018. Photo: Todd Rosenberg.</figcaption>
</figure>

The ever-impressive LOC orchestra, moved onto the main stage, flexed its protean muscles and proved once again just how flexible and responsive an ensemble they can be. Veteran Broadway conductor and arranger David Chase led the evening's music with care, finesse, and verve as if he had written it himself and served as an entertaining emcee throughout the second half of the program.

Walking out of the theater that evening, surrounded by people all whistling a medley of Bernstein tunes, recalling the first time they saw this musical or heard him in that concert, sharing stories of what his artistry meant to them – it was impossible to not smile.