+++
author = ["authors/jenna.md"]
date = "2014-12-15T14:54:00-05:00"
lastmod = "2015-04-13T17:44:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428961346324/53756789.jpg.jpg"
primary_image_credit = "Photo: Uli Weber"
publishDate = "2014-12-15T14:54:00-05:00"
related_articles = ["articles/8-contemporary-roles-to-covet.md","articles/ian-page-mozart-imagination.md","articles/natalie-dessay-opera-is-an-art-which-has-not-been-able-to-renew.md"]
related_people = ["scene/people/cecilia-bartoli.md"]
short_description = "Did anyone catch Cecilia Bartoli&#039;s comments earlier this year, in an interview promoting her new album, St Petersburg? Cecilia is known for her singing of Mozart, Vivaldi, and plenty of long-lost songs from the 18th-century and earlier. Early Music folks are notoriously eccentric, and at their worst, annoyingly closed-minded about &quot;modern music&quot;."
slug = "cecilia-bartoli-atonal-music-creates-a-barrier-between-composer-and-singer"
title = "Cecilia Bartoli: &quot;atonal music creates a barrier between composer and singer&quot;"
+++

Did anyone catch&nbsp;<a href="http://www.gramilano.com/2014/10/cecilia-bartoli-contemporary-composers-cant-write-opera-singers-like/" target="_blank">Cecilia Bartoli</a>'s comments earlier this year, in an interview promoting&nbsp;her new album,&nbsp;<a href="http://www.amazon.com/St-Petersburg-Deluxe-Edition-Limited/dp/B00M0CX9HM" target="_blank"><em>St Petersburg</em></a>? Cecilia is known for her singing of Mozart, Vivaldi, and plenty of long-lost songs from the 18th-century and earlier. Early Music folks are notoriously eccentric, and at their worst, <a href="http://www.earlymusicworld.com/id44.html" target="_blank">annoyingly closed-minded</a> about "modern music". I didn't picture Ceci for one to turn up their nose at music outside of her usual repertoire, but here's <a href="http://www.gramilano.com/2014/10/cecilia-bartoli-contemporary-composers-cant-write-opera-singers-like/" target="_blank">this quote</a> of hers:<p></p><p>"I’ve always enjoyed research, try­ing to find for­got­ten music to enlarge the rep­er­toire, being that con­tem­por­ary com­posers can’t seem to write for opera sing­ers like me. It would be won­der­ful to work with a com­poser writ­ing for [sic] just for us. Moz­art wrote his operas know­ing the voices of the sing­ers who would inter­pret the roles. Today, it’s no longer like that: atonal music cre­ates a bar­rier between com­poser and singer, so in order to find new music to sing I have to search in the past."</p><p>Let's take this one sentence at a time. Enlarging the known repertoire certainly doesn't just mean writing more contemporary music; searching for unfamiliar music of the past is completely legit. But, "contemporary composers can't seem to write for opera singers like me"? Really? I mean, I'm thinking of someone like Dawn Upshaw, similar in voice, and a serious champion of new music. I hope Cecilia isn't playing the special-snowflake-<em>fach</em> card, because it just doesn't fly. She skips right on past the solution to this non-problem in her second sentence: "It would be wonderful to work with a composer..." So do it? Work with a living composer, and educate him or her about what makes good vocal writing, about the natural demands and limitations of different voices.</p><p>Does Cecilia really think that the composer-singer relationship stopped after Mozart? Apparently so: "Mozart wrote his operas knowing the voices of the singers who would interpret the roles." First of all, these singers may have been bad singers. Besides&nbsp;anecdotal knowledge that's handy to have in the rehearsal process, who cares? More importantly, composers have been writing for singers they know for as long as there have been composers and singers. I mean, there's <a href="http://www.brittenpears.org/" target="_blank">Benjamin Britten and Peter Pears</a>, <a href="http://www.festivalopera.org/curtin.htm" target="_blank">Carlisle Floyd and Phyllis Curtin</a>, <a href="http://florentschmitt.com/2014/08/19/french-soprano-denise-duval-muse-of-francis-poulenc-friend-of-florent-schmitt/" target="_blank">Francis Poulenc and Denis Duval</a>, and of course,&nbsp;<a href="http://en.wikipedia.org/wiki/Giacomo_Puccini#Marriage_and_affairs" target="_blank">Puccini and all his mistresses</a>. And to drive a point home, Dawn Upshaw has made a name for herself working with composers like Saariaho, Golijov, Adams, and Herbison.</p><p>It's in the last bit of that quote where I think the real point lies. The whole&nbsp;"atonal music cre­ates a bar­rier between com­poser and singer" thing is just such an old thing to say. Atonality has nothing to do with any barriers that may exist between what's written and what can be well-sung in practicality. I remember seeing Verdi's&nbsp;<em>Stiffelio</em> at VOICEBOX/Opera in Concert earlier this year, thinking the whole time that it was written uncomfortably for the three lead roles. There's Richard Strauss, who ran a gamut of compositional styles, including atonality. People like singing Strauss and find his music&nbsp;expressive, engaging and narrative. There are also Stravinsky and Berg and Britten and others writing well for voices in questionable keys. I also found this bit of hilarity from <a href="http://sk-sk.pchelplinebd.comwww.fb.me/sally.whitwell.musician/posts/770322526337076?comment_id=770736606295668&amp;offset=0&amp;total_comments=17" target="_blank">Sally Whitwell</a>'s posting of Cecilia's statement on her Facebook page:</p><p><span data-sc-tag="[caption id=&quot;attachment_2335&quot; align=&quot;aligncenter&quot; width=&quot;320&quot;][/caption]" class="sc-node sc-node-caption"></span></p><p>I'll admit firstly that I'm not in Cecilia's vocal shoes; I'm not even a singer. Perhaps I'm being unfair, offering up examples of contemporary music that I understand to be vocally well-written. I'll also admit that when it comes to what she wants to sing, Cecilia has as much right as any other singer. She's earned herself an enviable career with her clearly passionate singing of difficult rep (I still can't get over <a href="http://www.youtube.com/watch?v=rISjBGOtHhs" target="_blank">her Vivaldi coloratura</a>). My objections to her statements may come simply from a difference in taste. However, I can't shake the feeling that Cecilia, whether or not she's aware of it, wants composers to write music that sounds like the stuff she already prefers to sing. I guess that falls under taste. I'm just surprised that's how she feels.</p><p>Contemporary singers, what say you? How does newly written music stack up to the singability of Mozart and his friends? Are today's composers irreverent of the singer's task? Is Cecilia Bartoli right?</p>
