+++
author = ["authors/jeremy-hirsch.md"]
categories = "Review"
date = "2017-12-22T12:08:00-05:00"
lastmod = "2017-12-24T10:54:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1514074262401/2017-12-23---sq---image2.jpg.jpg"
primary_image_credit = "GLMMR, Book of Dreams, National Sawdust 2017. Photo: VIta Tzykun."
publishDate = "2017-12-23T15:39:00-05:00"
related_articles = ["articles/spotlight-on-jeremy-hirsch.md","articles/cosmic-grandeur-and-human-frailty-crossing.md"]
short_description = "GLMMR&#039;s creative team has constructed a scenario in which a Promethean ur-man (David Adam Moore) grapples with a deity-like overseer (pre-recorded narration by new-music impresario Beth Morrison), as he searches for identity in a world bereft of humankind."
slug = "cautiously-aspirational-book-of-dreams"
title = "Cautiously aspirational: Book of Dreams"
+++

A blinded wanderer chained to the earth navigates a desolate landscape. No humans in sight. Chafed, he claws his way onto a mound of sand in an expansive, bleached desert. A menacing haze of sound builds, builds, into a diffuse burst. Momentary quiet. Rustling. The din emerges again. The bone-white surroundings assert their harsh brightness. Alone, crouched into himself, the wanderer pleads.

Response: a disembodied voice booms. Vertical shards of light pulse to its incantations. The man cowers, desperate for answers but fearful of this deity. His cry shimmers upwards, rises and wiggles, seeking to affirm his humanity.
 
So begins the first installment, "Chapter Sand", of the larger *Book of Dreams*. This new collaborative project by the art collective [GLMMR](https://www.glmmr.org/) uses Sonja Krefting's poetry as the spine for what will be a multi-chaptered, multi-genre work. This first completed section, described as an electroacoustic song cycle, is a fully produced, multi-media drama. Its performance at National Sawdust is part of Sparks & Wiry Cries' adventurously curated [Casement Fund Song Series](http://www.sparksandwirycries.com/CasementFundSongSeries/UpcomingSeason.aspx).
 
Poet Sonja Krefting, who died of cancer far too young at 25, wrote prolifically – this project marks the first public presentation of her work. The text assembled for "Chapter Sand" shifts between mythological and quotidian settings. Its imagery is surreal, its message cautiously aspirational.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1514074304372/2017-12-23---image1.jpg.jpg)<figcaption>GLMMR, Book of Dreams, National Sawdust 2017. Photo: VIta Tzykun.</figcaption>
</figure>
 
GLMMR's creative team has constructed a scenario in which a Promethean ur-man (David Adam Moore) grapples with a deity-like overseer (pre-recorded narration by new-music impresario Beth Morrison), as he searches for identity in a world bereft of humankind.
 
The show's set (designed by Vita Tzykun) took up minimal space, yet with the help of projections, suggested vastness, as though a mountainous, Antarctic desert spanned the horizon. Built on stage was an elevated pile no more than seven or eight feet in diameter. Three large combs cascaded white, spaghetti-like strands onto the platform. They dangled from different heights, one in front of the other. Moore, as the protagonist, hardly needed to move laterally. Standing, climbing, and crouching told a dramatic enough story in the compact but detailed space.
 
Moore's singing sounded a capella despite a prominent electronic soundscape. Fitting considering the music's genesis. Composer David T. Little (*Soldier Songs*, *Dog Days*) wrote the vocal line as a sort of stand alone a capella song cycle. His melodies, while grounded in a maintainable tessitura, exploited Moore's glowing head voice mix with climbing, stratospheric melismatic passages. Little's melodic contours served and clarified the text by highlighting evocative words, and emphasizing emotional content through rhythmic variation, carefully chosen repetition, and harmonically suggestive pitch relationships. Moore built the electronic score around Little's melodies. His track favored distorted bass sounds you might hear in techno and heavy metal. Crashes and percussive flares gave perilous dimension to the protagonist's unforgiving environment. In general, the music was unpretentious and utterly enjoyable while it effectively told a treacherous story. The piece is short, clocking in around half an hour, perfect considering its place in the expansive *Book of Dreams* yet to come.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1514074291955/2017-12-23---image3.jpg.jpg)<figcaption>GLMMR, Book of Dreams, National Sawdust 2017. Photo: VIta Tzykun.</figcaption>
</figure>
 
A post-show Q&A offered insight into the concepts that informed David Adam Moore's carefully calibrated electronic arrangement. Moore, a DJ in another life (he has a Terry Gross-worthy musical journey), described how during a period of enthusiasm for microhouse music, a style of electronic music that favors high and low frequencies, he entered a club and realized that, though the music thumped loudly, he could hold a conversation without shouting. How was this possible?
 
While in college at Oberlin, Moore assisted the legendary pedagogue Richard Miller, known for, among other developments, working with spectrometers to map the voice's frequencies in order to gain further technical insight. Moore learned a concept during his work that stuck: there is an acoustical sweet spot between about 2300-3000 Hz that a well produced voice will maintain in its spectrum of resonance throughout its range. Whether the note is low, high, in the middle, wherever, with its overtones, the expert singer's sound will contain some vibrations in that specific amplitude. This remarkable ability unique to the human voice is called the "singer's formant".
          	
Consequently, an orchestral instrument resonating below 2300 Hz or above 3000 Hz can play loudly without necessarily covering the singer. If a composer leaves sonic space in the 2300-3000 Hz slot, her risk of drowning out a well-focused voice greatly decreases. The best opera composers intuited this principle as did, evidently, the micro-house artists in the clubs Moore frequented. Moore too used this concept to his advantage. His electronic track, though heavily amplified, rendered every sung syllable and melodic nuance audible.
 
The post-performance talk entitled "Voice + Machine: A Love Story 2.5 Million Years in the Making" discussed the integration of the ancient, self-amplified voice with modern technology. To a large extent, "Chapter Sand" explored the same topic on a metaphysical level, asking how humans cope with tech that threatens to replace them. The disembodied electronic voice and soundtrack, unburdened by corporeal limitations, emphasized the solitary man's frailty.
 
The protagonist sings his final lines, marked "an ANTHEM". He says, "I shall possess my body forever. / I shall not be corrupted; / I shall not disintegrate." He removes his blindfold and stares into a bewildering abyss. Conviction is his only refuge.
