+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2018-11-11T11:32:00-05:00"
lastmod = "2018-11-11T11:38:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1541954133589/sqBramwellToveyTobySpenceRussellBraunJagGundu.jpg.jpg"
primary_image_credit = "Toby Spence and Russell Braun performing Britten's War Requiem with the Toronto Symphony Orchestra, 2018. Photo: Jag Gundu."
publishDate = "2018-11-11T11:35:00-05:00"
related_articles = ["articles/in-review-songs-of-love-and-war.md","articles/war-stories-o17.md","articles/a-chilling-cry-of-warning-enos-war-requiem.md"]
related_companies = ["scene/companies/toronto-symphony-orchestra.md"]
short_description = "There was bile on Tovey&#039;s tongue that rang into Roy Thomson Hall, and its effect lingered long enough to dovetail into the first bars of the War Requiem. I have always found something magnetic and charismatic about Tovey, and as silly as it may sound, to hear him indulge in a brief moment of personal feelings about the meaning of war and commemoration felt akin to hearing a friend&#039;s firsthand experience with tragedy."
slug = "catharsis-is-the-wrong-word-brittens-war-requiem"
title = "&quot;Catharsis&quot; is the wrong word: Britten&#039;s War Requiem"
+++

There was a moment of particular vitriol in Bramwell Tovey's brief remarks before giving the Toronto Symphony Orchestra its downbeat for Britten's arresting *War Requiem*. He said, "When the sun goes down, and when the sun comes up - *and in the rain* - we shall remember." It was a pointed, verbal bite directed at a US President who, 100 years after the official end of WWI, was too small and weak to pay an in-person visit to an American military cemetary outside Paris; he cited rain as his excuse, which is in horrific taste even as it is thinly-veiled code for pouting and narcissism.

There was bile on Tovey's tongue that rang into Roy Thomson Hall, and its effect lingered long enough to dovetail into the first bars of the *War Requiem*. I have always found something magnetic and charismatic about Tovey, and as silly as it may sound, to hear him indulge in a brief moment of personal feelings about the meaning of war and commemoration felt akin to hearing a friend's firsthand experience with tragedy.

For as long as I can recall, the ceremonies that come with November 11 have evoked, above all, guilt. And obtuse guilt - not the immediacy of survivor's guilt, or even over failed empathy of a friend or family who lived through a World War. It was always clear to me the importance and humanity in remembering; yet my own connection to war is distant, and it keeps at arm's length the meaning of symbols like silence and poppies. I suppose it's nearly impossible to actually understand war without having lived it, and the more removed one is from that reality, the more one relies on small pieces of understanding. Pieces like the fleeting moment of emotion from Tovey - a man who, born in England in 1953, has more connection than me to WWI.

The TSO's performance of Britten's *War Requiem* was excellent, and rooted in respect well before the first notes were played. Nodding to the three soloists whom Britten envisioned for the 1962 premiere of his work, Russian soprano Galina Vishnevskaya, German baritone Dietrich Fischer-Dieskau, and English tenor Peter Pears, the TSO mirrored the gesture of global reconciliation with their line-up of singers: Russian soprano Tatiana Pavlovskaya, German-Canadian baritone Russell Braun, and English tenor Toby Spence.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1541954109691/TatianaPavlovskayaWarRequiemJagGundu.jpg.jpg)
<figcaption>Tatiana Pavlovskaya performing Britten's *War Requiem* with the Toronto Symphony Orchestra. Photo: Jag Gundu.</figcaption>
</figure>

Pavlovskaya, with her generous and free soprano, gave the Mass text; with the orchestra and chorus, they were the elevated voices of retrospective sympathy. Braun and Spence were the earthy voices of a German and English soldier; with their own chamber orchestra, they sang the text of Wilfred Owen's poetry and seemed to offer private details of life in combat, known only to those who were there. Above it all was the Toronto Children's Chorus, making the sound of the unnamed masses a full spectrum of the people affected by the war.

Britten's is a brilliant work of homage, one that stands nobly on Mass conventions - Latin text, its six sections - and comes with something personal, the tangible experiences of Owen and the soldiers he knew. More than most composers, Britten's works always include some of his own thoughts on a subject. His *Peter Grimes* often feels like a diary entry of a man who is isolated and misunderstood; *The Turn of the Screw* tells of a blurry line between care and harm. His *War Requiem* includes Owen's poem, "The Parable of the Old Man and the Young", a telling of the story of Abraham and Isaac, but with a nauseating twist at the end. When the angel stops Abraham from killing his son, offering a ram to sacrifice instead, Abraham rejects it. 

"But the old man would not so<br>
but slew his son,-<br>
And half the seed of Europe, one by one."<br>

It's too real in 2018. A man decides to kill an innocent, under the pretext that his hand is forced by God; when God stops him and gives him a way to save the innocent's life, the man still kills. With terrifying regularity, we see today people who choose to do harm, under the pretext that they have no other choice; when presented with, indeed, another choice, they ignore. The pretext is dishonest, the aim was always to do harm.

There's a moment in Britten's *War Requiem* where everything escalates, concentrates, and then seems to explode and melt in a disturbing climax. Maybe that's what it means for a piece of music to be "timeless" - for it to draw out a sob in a listener born fortunately far from the tragedy that inspired the piece's creation.

"Catharsis" is the wrong word, since there's still a pit in my stomach.
