+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2019-01-10T01:29:24+00:00"
disclaimer = ""
image_gallery = []
preamble = "New York-based ensemble [Cantata Profana](https://www.cantataprofana.com/meet-cp) is gearing up for its latest concert, [_Visions of Silence_](https://www.cantataprofana.com/tickets), January 18 & 19 at St. Peter's Chelsea. The headlining piece on the programme is Salvatore Sciarrino's \"Ecstasy in One Act\", _Infinito Nero_ (1998); the work is scored for voice and eight instruments, each representing one of the eight scribes who took down the words of 17th-century visionary and saint, [Maria Maddalena de' Pazzi](https://en.wikipedia.org/wiki/Mary_Magdalene_de%27_Pazzi). We spoke with Jacob Ashworth, violinist, conductor, and Cantata Profana Artistic Director, about the ensemble's insatiable hunt for excellent music."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1547084016/media/2019/01/sqJacobAshworthHeadshot.jpg"
primary_image_credit = "Photo by David Fung."
related_articles = ["articles/heartbeats-giovanni-successfully-bucks-tradition.md", "articles/a-truly-otherworldly-space-heartbeat-operas-drag-extravaganza.md"]
related_companies = []
related_people = []
short_description = "\"If you want to see our bucket list, there's about a hundred pages of endless Google docs of repertoire ideas that we've been marinating for years. Some pieces stay on the list because they are just waiting for the right venue, the right collaborators, the right concert.\""
slug = "cantata-profana-set-to-present-a-total-masterpiece-in-visions-of-silence"
title = "Cantata Profana set to present \"a total masterpiece\" in Visions of Silence"
youtube_url = ""

+++
### What are the creative advantages of Cantata Profana's dual focus on early music and new music?

To me all of music history is just one ever-expanding epic story. So I like to be able to draw on any part of that story when making a show. We're lucky to have such a wealth of specialities in the group on every kind of period and modern instrument, so we can create fresh, new connections across enormous stretches of time and geography with the conviction that we're really inhabiting each style. Or put another way, we're all nerds about such different kinds of music that we can plop ourselves in any time period or musical genre and chances it'll be someone's wheelhouse and they can teach the rest of us. And that’s how we learn together as a group and how we've tackled so much repertoire over the years.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1547084613/media/2019/01/CPgroupphoto.jpg){{% /md %}}

<figcaption>The members of Cantata Profana. Photo by Henry Chan.</figcaption>

</figure>

### How do you go about programming your concerts?

How do we go about programming our concerts? How does the sausage get made, as our lutenist Arash Noori refers to it? I think it's a mystery even to us sometimes. We have various different ways of approaching a show. Sometimes there's a big piece that anchors everything, like this upcoming show. We know we wanted to do _Infinito Nero_ and that piece exists in such a rarified world that we knew we needed to carefully build the first half hour of the program so that the audience would be ready for the astonishing experience of that work.

> "Okay, this might sound hokey, but I think the key to our programming is we only do bucket list pieces."

But other times a whole program comes from the smallest germ. I remember a show that included a staged semi-production of Monteverdi's famous _Il Combattimento di Tancredi e Clorinda_ that I swear came from this yen I had to do a 2-minute Webern choral work ("Entflieht auf leichten Kähnen", op. 2) for four solo voices. Other times we start from an idea or a text or a story, like our _Phaedra_ concert from our second season, and the music comes from there. But we search always through hundreds of pieces looking for the connections that fascinate us, trying to tell a new story each time.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1547084648/media/2019/01/AliceArash.jpg){{% /md %}}

<figcaption>Soprano Alice Teyssier (photo: Blaise Hayward) and lutenist Arash Noori (photo: Russ Rowland), two performers on Cantata Profana's Visions of Silence programme, January 18-19, 2019.</figcaption>

</figure>

### What unique challenge do you find in programming obscure music, like Ustvolskaya's Symphony No. 5?

Sometimes getting the actual music itself is a difficulty. Searching for publishers, or particularly for baroque music, searching through libraries is great fun. There's also a wonderful sort of global community for anyone interested in obscure music, so that if you found out that someone out there has done the piece, chances are they are excited about the music and if you can reach them, they'll be delighted to help you find it, or send you a copy. For the Ustvolskaya, it's a good thing our clarinetist and Associate Artistic Director Gleb Kanasevich speaks Russian, because all the score indications are in Cyrillic. But in general I'd say programming obscure music is only ever a minor hassle and more people should do it!

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1547084880/media/2019/01/CantataProfanaComposers.jpg){{% /md %}}

<figcaption>Clockwise from top left: composers Tarquinio Merula, Salvatore Sciarrino (photo: Philippe Gontier), Galina Ustvolskaya, and Alvin Lucier.</figcaption>

</figure>

### What can you tell us about Sciarrino's music, and why have you chosen to highlight his _Infinito Nero_ on this programme?

Salvatore Sciarrino for me is part of that wonderful and all-too-short list of composers from the second half of the twentieth century (Henze, Ligeti, Berio, Chin, Kurtág, others like that) who studied all the trends, learned all the skills, made all the experiments, and never forgot about the audience. It is so much fun to watch his output change over his life, because at the end of the day he is always a dramatist. He is constantly taking music to its absolute extremes, challenging instruments in every piece to play in ways that few have dared ask. But there is always drama and it always pays off. A scene, a vision, a story, a character. Something the listener can become viscerally involved in.

> "There's about a hundred pages of endless Google docs of repertoire ideas that we've been marinating for years."

Much of his music presents a more familiar virtuosity with zillions of notes, complicated extended techniques at breakneck speeds, turning on a dime, or stretching the ranges of the instrument to the highest highs and lowest lows. But in _Infinito Nero_, the virtuosity is in the precision. Aching minutes and seconds of near silence are broken by cracking explosions of sound and the whole band has to be able to sputter and jolt in electrifying unison. It's a total masterpiece, and there isn't another piece of music in the world like it.

### Do you have any pieces on your "bucket list" for Cantata Profana?

Okay, this might sound hokey, but I think the key to our programming is we only do bucket list pieces. I can't tell you how often we're designing a show and doing our research and we come across a piece that is exactly the right fit — the right instruments, the right length, thematically relevant, perfectly suited to that juncture in the show — and after a few listens we have to admit that it just isn't good enough to make it onto one of our programs, and we're back to the drawing board. If you're going to choose from eight centuries of music, why choose anything but the best?

But yes, if you want to see our bucket list, there's about a hundred pages of endless Google docs of repertoire ideas that we've been marinating for years. Some pieces stay on the list because they are just waiting for the right venue, the right collaborators, the right concert. Berio's _Recital for Cathy_. Gorecki's _Harpsichord Concerto_. Monteverdi's _Book 8 madrigals_. The complete Webern vocal chamber music. Carter _Double Concerto_. Vivier's _Lonely Child_. Shostakovich's _14th Symphony_. Tom Waits songs. Everything by Machaut. But the good news is we're ticking off pieces all the time. We did Mahler's _Das Lied von der Erde_ last year in Schoenberg's arrangement. That's a bucket list piece for life, no matter what group you are. This concert we're finally doing more Ustvolskaya and this incredible canzonetta by Tarquinio Merula that belongs on everyone's desert island CD. This May we're staging a Handel cantata that we've been dreaming about forever, and in March we're finally going to have a whole show of piano four-hands with our two amazing keyboardists Lee Dionne and Daniel Schlosberg at Joe's Pub.

> _Visions of Silence_ happens January 18-19 at St. Peter's, Chelsea. For details, [click here](https://www.cantataprofana.com/tickets); for tickets, [click here](https://www.eventbrite.com/e/visions-of-silence-tickets-52992094782).