+++
author = ["authors/meghan-klinkenborg.md"]
categories = "Review"
date = "2019-07-01T04:00:00+00:00"
disclaimer = ""
image_gallery = []
postamble = "Des Moines Metro Opera's production of [_Candide_](http://desmoinesmetroopera.org/productions/candide/) runs through July 20."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1562036043/media/2019/07/sqDMMOCandideDSC_5530.jpg"
primary_image_credit = "Candide, Des Moines Metro Opera, 2019. Photo: Duane Tinkey for Des Moines Metro Opera."
related_articles = ["articles/candide-the-best-of-all-possible-productions.md"]
related_companies = ["scene/companies/des-moines-metro-opera.md"]
related_people = ["scene/people/corey-bix.md", "scene/people/emmett-o-hanlon.md", "scene/people/eliza-bonet.md", "scene/people/kyle-albertson.md", "scene/people/jonathan-johnson.md", "scene/people/deanna-breiwick.md"]
short_description = "If you're looking for a theatrical farce that will leave you with a lot of questions about the human condition, then look no further than Des Moines Metro Opera's charming production of Candide."
slug = "dont-let-the-upbeat-tunes-deceive-you-dmmos-candide"
title = "Don't let the upbeat tunes deceive you: DMMO's Candide"
youtube_url = ""

+++
On the surface, [Leonard Bernstein's _Candide_](http://desmoinesmetroopera.org/productions/candide/) seems like a delightful theatrical comedy, but underneath the cheerful tunes and ridiculous plot, there is a deeper, darker undercurrent. Des Moines Metro Opera tackled this hard-to-define opera/operetta/musical about philosophy and human nature with unrelenting energy and flair, leaving the audience laughing and reflecting simultaneously.

Candide and his companions travel to numerous countries throughout the story, and these rapid fire relocations pose quite a challenge to any production team. The scenic designer, Steven C. Kemp, took a strategically clever and colorful approach to this conundrum. Each location in the story was designated by a unique monochromatic color scheme. As the narrative progressed to a new city, set pieces in the designated color would appear, and then once the characters moved onto another place, a couple pieces of scenery would remain. By the end of the night, the stage was a rainbow of mismatched platforms, furniture, and backdrops, each reflecting part of Candide's chaotic journey and the contradictory lessons he learned.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1562033227/media/2019/07/DMMOCandideDSC_0026.jpg){{% /md %}}

<figcaption>Candide, Des Moines Metro Opera, 2019. Photo: Duane Tinkey for Des Moines Metro Opera.</figcaption>

</figure>

The rest of the design teams played off the color scheme as well. Linda Pisano chose a neutral white base for the chorus costumes, accentuating each city's designated color through the use of accessories. Cunegonde and the Old Lady were chameleons, their clothes changing to assimilate with their surroundings. Candide, however, stood out against the varying colored backdrops, often wearing the same neutral outfit from scene to scene. The choice was subtle but effective.

The orchestra under the direction of David Neely created the effervescent and erratic musical atmosphere that served as a backdrop for Candide's many misadventures. Bernstein's beloved overture was executed with lively precision, forecasting the frantic fun ahead. From sultry tangos to choral hymns, they excelled in every musical style, dragging us along for the wild ride that is _Candide._

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1562033242/media/2019/07/DMMOCandideDSC_0153.jpg){{% /md %}}

<figcaption>Candide, Des Moines Metro Opera, 2019. Photo: Duane Tinkey for Des Moines Metro Opera.</figcaption>

</figure>

This opera/operetta/musical calls for a multitude of performers that can pull off virtuosic vocals as well as satirical humor. Des Moines Metro Opera assembled a stellar cast that committed to this crazy comedic marathon and had the audience laughing from start to finish.

Wynn Harmon played the spoken role of Voltaire, the author of the original novella and narrator of the musical adaptation. He served as the audience's guide but also interacted with the characters themselves. Harmon's constant presence gave some stability to the fluctuating storyline, a calming force as well as the impetus of key plot points.

[Kyle Albertson](/scene/people/kyle-albertson/) portrayed Candide's two opposing mentors, Dr. Pangloss the optimist and Martin the pessimist. Albertson's approach to these contrasting characters was so convincing that I didn't realize that he had played both of them until I checked the program afterwards. His rich vocal tone conveyed Pangloss's sunny disposition with natural ease but was equally effective in Martin's jarring, sarcastic tunes.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1562033274/media/2019/07/DMMOCandideDSC_5239.jpg){{% /md %}}

<figcaption>Candide, Des Moines Metro Opera, 2019. Photo: Duane Tinkey for Des Moines Metro Opera.</figcaption>

</figure>

[Eliza Bonet](/scene/people/eliza-bonet/) and [Emmett O'Hanlon](/scene/people/emmett-ohanlon/) were charming and hilarious in the roles of Paquette and Maximilian. Bonet as the promiscuous maid had a twinkle in her eye that made me think of Aubrey Plaza, snarky and sexy. Paquette may have been spreading syphilis all over Europe, but no one seemed to hold that against her. O'Hanlon gave the narcissistic Maximilian an over the top German accent worthy of an SNL skit. In any other opera, I would have found it strange that although all the main characters originated in Germany, Maximilian was the only one with said accent, but _Candide_ is just so silly that it worked.

[Jill Grove](http://www.jillgrovemezzo.com/) was a cheeky delight in the role of The Old Lady. (This character is missing one buttock so pun intended.) Grove's bold mezzo voice was a dominating presence onstage, and she had the audience roaring during her big number "I Am Easily Assimilated."

[Corey Bix](/scene/people/corey-bix/) sang the role of The Governor, a conniving character with music reminiscent of Gilbert & Sullivan. Although he had some vocal strain on the high notes, the tenor's performance made the unrepentant bad guy amusing and somehow likeable.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1562033294/media/2019/07/DMMOCandideDSC_5892.jpg){{% /md %}}

<figcaption>Candide, Des Moines Metro Opera, 2019. Photo: Duane Tinkey for Des Moines Metro Opera.</figcaption>

</figure>

Candide's third mentor, Cacambo, was performed by Corey Trahan. This character resembled a more realistic compromise between optimism and pessimism, and while Cacambo didn't get his own musical number, he was crucial to some of the best comedic moments. Trahan employed a couple of hilarious accents for his character, and whenever he came onstage, he was clearly an audience favorite.

[Deanna Breiwick](/scene/people/deanna-breiwick/) was a bubbly and beautiful Cunegonde, and her rendition of the famous "Glitter and Be Gay" aria was a dazzling delight. Her vocal runs managed to stay liquid smooth even as her character became more and more manic, and she doled out the plethora of high notes with seemingly no effort. The character of Cunegonde is intentionally two dimensional, objectified by the various men that come into her life. Breiwick's performance nailed the superficial nature of the noble lady, only cracking that façade at the very end of the story when she confronts Candide's condemnation of her. This brief glimpse at Cunegonde's true emotional state was powerful.

The title role of Candide was sung by [Jonathan Johnson](/scene/people/jonathan-johnson/), and the tenor's vocal clarity was the ideal depiction of the character's sincerity and innocence. Johnson's performance of Candide's first aria "It Must Be So" was truly haunting because it was simple and vulnerable in an otherwise bustling score. Candide shines like a beacon on the stage, a pure being amid the tumultuous world around him. Johnson brought a genuine likability to the character that had us rooting for him throughout the story even when he killed three different people! (We found out later that all three murders were miraculously unsuccessful but still not cool.)

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1562033310/media/2019/07/DMMOCandideDSC_5295.jpg){{% /md %}}

<figcaption>Candide, Des Moines Metro Opera, 2019. Photo: Duane Tinkey for Des Moines Metro Opera.</figcaption>

</figure>

There were a number of other minor characters that played a vital role in the hilarity, but I just don't have enough time to go into detail about each of them. _Candide_ is truly an ensemble comedy, and the background characters were crucial in setting the tone of each location the main characters encountered. Under the direction of Lisa Hasson, the chorus took on the varying musical styles and transported Candide and the audience to different countries. Without the vivacious ensemble of singers onstage, Bernstein's score would absolutely fall flat.

Because this story is so absurd, director Michael Shell and choreographer Todd Rhoades brought the same level of absurdity to the staging itself. There were disturbing scenes like rape and public execution going on, but somehow Shell managed to lighten the impact just enough to keep the audience from getting too uncomfortable. Some scenes featured so many characters that the potential to be overwhelmed was high. Shell created strategic vignettes that drew focus to key moments, however, and I found myself laughing at small interactions occurring amid crowded casinos, bloody battles, and overgrown gardens. No matter how much insanity was going on, I never lost track of the important plot points.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1562033338/media/2019/07/DMMOCandideDSC_6348.jpg){{% /md %}}

<figcaption>Candide, Des Moines Metro Opera, 2019. Photo: Duane Tinkey for Des Moines Metro Opera.</figcaption>

</figure>

Bernstein's _Candide_, on the surface, appears to be a lighthearted comedy, but don't let the upbeat tunes deceive you (especially the one about venereal disease). Once you start to comprehend the dark subject matter beneath the happy disguise, you realize that the music in reality is frantic and frenzied. The score was unrelenting, never resolving from location to location, and when we finally reached the end, there was no resolution to the narrative itself. The characters angrily demanded answers from Voltaire, but there were none. Bernstein addressed this lack of a satisfactory conclusion by bombarding the audience with a wall of vocal harmony, a glorious hymn that sounded confident but still left the moral of the story up to us. But that's reality, folks. Life is dark but also hilarious. People can be terrible but also wonderful. Philosophy can only take us so far. The rest is in our hands.

If you're looking for a theatrical farce that will leave you with a lot of questions about the human condition, then look no further than Des Moines Metro Opera's charming production of _Candide_.