+++
author = ["authors/loren-lester.md"]
categories = "Review"
date = "2018-02-16T21:30:00-05:00"
lastmod = "2018-02-16T22:24:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1518833177910/sq---cand_0016_pr.jpg.jpg"
primary_image_credit = "Kelsey Grammer as Voltaire in LA Opera's 2018 production of Candide. Photo: Ken Howard/LA Opera."
publishDate = "2018-02-16T21:30:00-05:00"
related_articles = ["articles/too-many-jewels-the-search-for-meaning-pbos-candide.md","articles/candide-projecting-the-best-of-all-possible-worlds.md","articles/grappling-with-daily-life-wnos-candide.md"]
related_companies = ["scene/companies/los-angeles-opera.md"]
related_people = ["scene/people/peabody-southwell.md","scene/people/jack-swanson.md","scene/people/brian-michael-moore.md","scene/people/matthew-scollin.md","scene/people/erin-morley.md"]
short_description = "All of Candide’s disasters could translate into a disastrous evening, but thanks to the clear and sure hand of director Zambello, the humor is allowed to speak for itself without too many additional bits and gags that often make a funny show tiresome and unwatchable."
slug = "candide-the-best-of-all-possible-productions"
title = "Candide: the Best of All Possible Productions?"
+++

Since its debut/flop on Broadway in 1956, Leonard Bernstein's *Candide* has been revisited, revised, tinkered with, and cut and pasted. Different versions have appeared on Broadway, off-Broadway, and in quite a few opera houses. The current Glimmerglass production at LA Opera features a new book by John Caird and a number of the numbers have either been excised or shuffled like a deck of cards. 

If you've never seen *Candide*, none of this matters, because the [LA Opera production](https://www.laopera.org/news/Gallery/201718-season/candide/) is a thoroughly satisfying feast of music and comedy (with a political undertone and a poignant, heartfelt finale). Starring the estimable Kelsey Grammer and national treasure Christine Ebersole, the enjoyable evening comes together courtesy of director Francesca Zambello, who also directed two of LA Opera's greatest triumphs, *Billy Budd* and *Florencia en el Amazonas*.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1518834026571/cand_6792_pr.jpg.jpg)
<figcaption>Jack Swanson (Candide), with Amber Liekhus (left) as the Queen of Eldorado and Robert Norman (right) as the King of Eldorado in LA Opera's 2018 production of *Candide*. Photo: Ken Howard/LA Opera.</figcaption>
</figure>

It would have been Leonard Bernstein's 100th birthday this year. *Candide* is an important part of his legacy because the score is one of his best. Though daring and completely original, it's filled with musical references to jazz, tango, Broadway show-tunes and classical composers. The show is described as operetta, with some of the songs unabashedly influenced by Johann Strauss and Gilbert & Sullivan. 

But this is not your mother's light opera - the story and songs depend on some very dark humor. Where else can you find an operetta with satirical songs about war, syphilis, greed and prostitution? There’s even a humorous story of cannibalism to explain why one of the characters has only one buttock. This is the satirical territory that would be mined in later years by musicals such as *Cabaret*, *Chicago*, *Urinetown*, etc.; Bernstein and his collaborators were way ahead of the curve. And in our current political climate, where political leaders paint pictures that are completely unconnected from reality, there is a message that is as strong as it was in the McCarthy 1950's.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1518834037953/cand_3079_pr.jpg.jpg)
<figcaption>Erin Morley (Cundegonde), Brian Michael Moore (Governor of Montevideo) and Danny Lindren (Montevideo Priest) in LA Opera's 2018 production of *Candide*. Photo: Ken Howard/LA Opera.</figcaption>
</figure>

Based on the novel of the same name by Voltaire (and written in the same genre), *Candide* is supported by laugh-out-loud lyrics which are credited to a number of writers from the show's various incarnations over the years. Some were even contributed by Stephen Sondheim.

The plot begins simply enough - a wide-eyed and naive young man (Candide) falls in love with the daughter of a Baron (Cunegonde.) He's poor, she's rich, and the girl's father makes sure that "boy loses girl." But before this event sends Candide on a series of ridiculous adventures that take him all the way from Germany to South America and finally to Venice, Italy, we meet Dr. Pangloss. Pangloss is a teacher and philosopher who believes in "Optimism" and he tutors Candide into believing that no matter what happens, we are living in "the best of all possible worlds." Not even war - the worst side of mankind - deters Pangloss.

**Pangloss**: "Though war may seem a bloody curse<br>
It is a blessing in reverse<br>
When canon roar<br>
Both rich and poor<br>
By danger are united!<br>
(Till every wrong is righted!)"<br>

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1518834049753/cand_1037_pr.jpg.jpg)
<figcaption>Kelsey Grammer as Dr. Pangloss and Jack Swanson as Candide in LA Opera's 2018 production of *Candide*. Photo: Ken Howard/LA Opera.</figcaption>
</figure>

Adding to the absurdity of it all, Candide finds himself in some near-fatal situations, but no one really dies. Look at this exchange between Candide and Cunegonde from “You Were Dead, You Know” and you’ll get the idea:

**Candide**: Dearest how can this be so? You were dead, you know. You were shot and bayonetted, too.<br>
**Cunegonde**: That is very true. Oh, but love will find a way.

Characters who we thought were killed, continue to pop up at the most unexpected times. It’s a running joke and finally someone exclaims, “Not another reunion!?"

All of Candide’s disasters could translate into a disastrous evening, but thanks to the clear and sure hand of director Zambello, the humor is allowed to speak for itself without too many additional bits and gags that often make a funny show tiresome and unwatchable.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1518834061746/cand_1281_pr.jpg.jpg)
<figcaption>Erin Morley as Cunegonde in LA Opera's 2018 production of *Candide*. Photo: Ken Howard/LA Opera.</figcaption>
</figure>

Candide and Cunegonde, like the boy and girl in *The Fantasticks*, have their rosy world view badly shaken, and by the end, they have matured. The world, it turns out, is not anything like what Pangloss described (or for us today, how it's described in Washington, D.C.). With their new understanding of life, they sing one of the most famous songs from the show, "Make Our Garden Grow." After all the crazy plot twists, the ending proves to be quite moving. The orchestra cuts out and allows the entire cast to sing a verse of the song in a room-shaking a capella. They will go on, they're telling us - and we must go on too.

Though a musical comedy in structure - most of the songs are short and sweet and don't linger too long like some opera arias are wont to do - the cast is almost entirely composed of opera singers. And they prove to be adept actors and comedians as well as first-class singers. Credit director Zambello here again for insisting on three-dimensional people (who happen to find themselves trapped in a two-dimensional world).

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1518834076456/cand_1980_pr.jpg.jpg)
<figcaption>Jack Swanson as Candide (with Brian Michael Moore, top centre, as the Grand Inquisitor) in LA Opera's 2018 production of *Candide*. Photo: Ken Howard/LA Opera.</figcaption>
</figure>

As Candide, [Jack Swanson](/scene/people/jack-swanson/) is very funny and endearing and he has our complete sympathy as the world crushes his hopes and dreams. In his three superbly sung solos "It Must Be So", "It Must Be Me" and "Nothing More Than This" he gives us a much needed break from all the hijinks, and shows us that, in spite of all the cheery "words" he's been taught by Pangloss, internally he's suffering. 

In a role originated by the late, great Barbara Cook, [Erin Morley](/scene/people/erin-morley/) lives up to her predecessor as Cunegonde. Ms. Morley is not only a skilled actress, but her high E-flats (or even higher?) during the famously challenging "Glitter and Be Gay" brought down the house and reminded us that she is also a highly accomplished coloratura soprano.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1518834086379/cand_8674-pr.jpg.jpg)
<figcaption>Jack Swanson (Candide), Christine Ebersole (Old Lady) and Erin Morley (Cunegonde) in LA Opera's 2018 production of *Candide*. Photo: Ken Howard/LA Opera.</figcaption>
</figure>

Christine Ebersole makes her LA Opera debut (as the inappropriately named "Old Lady") after conquering just about every other medium. A double Tony Award winner, she reigns in the Broadway world whenever she's there (most recently in *War Paint*). She is a musical-comedy performer in the truest sense of the phrase - she will wow you with her incredible voice one moment, then adroitly deliver a deadpan punchline with the next. Just witness her expert drollery in "I Am Easily Assimilated" (with clever lyrics by Bernstein himself.) Too bad "We Are Women" was cut from this production - Ms. Ebersole (and Ms. Morley) would have added even more brilliance to the proceedings with this duet.

Kelsey Grammer (Voltaire/Pangloss), who is no stranger to comedy (*Frasier*), is also no stranger to singing. Those of us who did not see him in *La Cage aux Folles* or *Finding Neverland* on Broadway, were introduced to his commanding singing voice here. He set the absolute right tone with his narration, allowing the action to speak at its own, often loud, volume. He also avoided the pitfall of trying to make Pangloss funnier than he is. Mr. Grammer gets all the laughs needed - nothing more or less.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1518834105812/cand_8885_pr.jpg.jpg)
<figcaption>Peabody Southwell as Paquette in LA Opera's 2018 production of *Candide*. Photo: Ken Howard/LA Opera.</figcaption>
</figure>

Theo Hoffman as the narcissistic Maxmilian, [Peabody Southwell](/scene/people/peabody-southwell/) as the sexy Paquette, [Matthew Scollin](/scene/people/matthew-scollin/) as the eccentric Martin, and Joshua Wheeker as the loyal Cacambo are some of the standout supporting players. [Brian Michael Moore](/scene/people/brian-michael-moore/) is excellent as the Governor and treats us to some big laughs and impossibly high notes.

The scenery by James Noone is a one-set affair, resembling a period backstage area with a platform, catwalk and spiral staircase. The action is allowed to remain fluid and fast-paced without interminable set changes and Noone delivers a simple and elegant solution.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1518834114688/cand_7371_pr.jpg.jpg)
<figcaption>Taylor Raven (centre) as Vanderdendur, with ensemble members  Tim Campbell (left) and Katherine Henly (right) in LA Opera's 2018 production of *Candide*. Photo: Ken Howard/LA Opera.</figcaption>
</figure>

There is a rule in show business: "Never wear a costume that's funnier than the role." Costume designer Jennifer Moeller lives by this creed and so the principals are all in authentic-looking, believable 18th-century attire while the chorus is mostly in period undergarments (stockings and empty hoops for the women, long-johns for the men) so that they can easily throw on one garment or another and change into various characters (depending upon what part of the world we're in). When there is a visit to Eldorado, the chorus gets to cover their underwear with something particularly flashy.

Conductor James Conlon, as always, is one of the stars of the evening and not only does he clearly love the music, but he appears to be channeling Bernstein's love of the music. With every note he seems to be saying "Happy 100th Birthday." This production is not only a nice gift to the memory of Mr. Bernstein, but to all of us. [Performances conclude Feb 17th and 18th](https://www.laopera.org/news/Gallery/201718-season/candide/).
