+++
author = ["authors/john-hohmann.md"]
categories = "Review"
date = "2018-04-24T21:33:00-04:00"
lastmod = "2018-04-25T19:27:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1524619677869/sqCH1380312.jpg.jpg"
primary_image_credit = "Patricia Racette as the Old Lady, Paul Appleby as Candide, Eric Morley as Cunegonde and (standing) Ryan Silverman as the Captain in Carnegie Hall's gala production of Leonard Bernstein's Candide. Photo: Chris Lee."
publishDate = "2018-04-25T19:27:00-04:00"
related_articles = ["articles/leonard-bernstein-nyfos-i-think-hed-be-pretty-proud-of-it.md","articles/candide-the-best-of-all-possible-productions.md"]
short_description = "There is the vexing notion that Bernstein was his own Dr. Pangloss, coaxing himself out of Westphalia into a musical and theatrical breach. If divine providence finally lights the way, it is energized more by the rigorous tug of theatrical absurdity and naive optimism, than Voltaire&#039;s satirical bite."
slug = "candide-projecting-the-best-of-all-possible-worlds"
title = "Candide: projecting the best of all possible worlds"
+++

*Candide* feels like a work in progress and perhaps that is part of its rangy charm. One has the feeling that if Leonard Bernstein were still with us and were watching - or more likely conducting - this Carnegie Hall fundraiser, he would be working on ways to improve it from the podium.

There is the vexing notion that Bernstein was his own Dr. Pangloss, coaxing himself out of Westphalia into a musical and theatrical breach. If divine providence finally lights the way, it is energized more by the rigorous tug of theatrical absurdity and naive optimism, than Voltaire's satirical bite. 

Fortunately Carnegie Hall's *Candide* was populated with a talented and nimble cast that succeeded in its own right. It also possessed the unexpected visual splendor of Wendall K. Harrington's sumptuous and gorgeously specific projections, Eldorado's red bejeweled sheep not being the least of them. Harrington joined with the dependable Orchestra of St. Luke's and celebrated Mansfield College Concert Choir, to give Bernstein's score and Hugh Wheeler's sketchy book a galloping cohesion.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1524619733476/CH1380285.jpg.jpg)
<figcaption>The Ensemble Dancers waging war in Carnegie Hall's gala production of Leonard Bernstein's *Candide*. Photo: Chris Lee.</figcaption>
</figure>

We entered the hall to images of Voltaire and Bernstein flanking an early *Candide* book plate. They remained constant throughout the celebrated overture, which here lacked Bernstein's ferociousness and sense of mischief. As overtures go, one would have to bring on Rossini to find a piece that so brightly captures the mayhem and fun to follow. If only the show was as tightly constructed.

Since this was a gala we could expect a certain amount of folly that availed itself with the luxury casting of Len Cariou as the Archbishop and Danny Burstein as Don Issachar, the Jew. Battling suitors of Cunegonde, they appeared and were eliminated in about the same amount of time that than it took to read this sentence. A resplendent Marilyn Horne swathed in red and sporting a formidable crown, made a cameo appearance as the non-singing Queen of Eldorado. If not Miss Horne's most coveted role, she had a grand title and was a classy reminder of the import of the occasion.

Rob Marshall, leading the St.Luke's players, provided blissfully supportive accompaniment, especially from the woodwinds whose evocation of springtime lingered. As for the Mansfield University group, whether in a supporting capacity or taking center stage, they were consistently magnificent. 

With the indispensible John Lithgow leading the way as a faux arch Voltaire and a wily Dr. Pangloss, this *Candide* boasted luxury casting in principal parts. It is reasonable to think that even Voltaire would have been comfortable with Lithgow's sly portrayals. 

[Paul Appleby](/scene/people/paul-appleby/), as Candide had a blooming tenor, engaging presence and a convincing cluelessness. [Erin Morley](/scene/people/erin-morley/) was a coloratura dream as Cunegonde. Singing "Glitter and be Gay," on the very stage where, in 1975, *Candide*'s first Cunegonde, the late Barbara Cook, launched her post-theater singing career, Morley's rich vocal embellishment were enriched by superb comic timing.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1524619752438/CH1380314.jpg.jpg)
<figcaption>Patricia Racette as the Old Lady and her boys led by Stephen Hanna with arm around her waist in Carnegie Hall's gala production of Leonard Bernstein's *Candide*. Photo: Chris Lee.</figcaption>
</figure>

[Patricia Racette](/scene/people/patricia-racette/) reveled in a star turn as the Old Lady, notably with Cunegonde on "We are Woman," and with her big number, "I Am Easily Assimilated." She was a terrific team player too in "What's the Use." Racette treated us to both a belting theater voice and her luscious operatic soprano, all while holding on to an accent as thick as it was unspecified. But with "Woman" and "Assimilated" clearly redundant, we didn't need both. Nor did we need a muddy sound design that would have rendered Racette unintelligible if that accent and her diction weren't so firmly in place.

The distinguished tenor, William Burden was warmly received as the Governor of Buenos Aires. Quite the rake, in his Act Two opener, "My Love," he registered a cunning energy in "Bon Voyage", a bona fide production number, if a concert can have such a thing. Ryan Silverman was appropriately narcissistic as Maximilian, Candide's cousin and effective as the Grand Inquisitor and ship's captain.  Bryonha Marie Parham was a fetching, if underused Paquette.

A team of dancers, led by Stephen Hanna, deftly fought a war and took on other tasks associated with Candide's adventures. They worked the stage with animated precision and stylishly characterized Josuha Bergasse's crisp and astute choreography.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1524619764696/CH1380289.jpg.jpg)
<figcaption>Marilyn Horne, William Burden, Patricia Racette, Paul Appleby, Erin Morley, Ryan Silverman, John Lithgow and Bryonha Marie Parham flanked by the Ensemble Dancers at the curtain call of
Carnegie Hall's gala in production of Leonard Bernstein's *Candide*. Photo: Chris Lee.</figcaption>
</figure>

As "Make Your Garden Grow," Bernstein's anthem to humanity, reached heart-swelling proportions, Harrington filled the stage wall with yellow flowers. At that moment *Candide* was beyond debate. Our hearts opened, and for a certain contingent at this fundraiser, hopefully so did their wallets. If those flowers, through our misted eyes, seemed to move, they did. Harrington informs that they were "growing slightly" during the closing sequence. So was *Candide*.
