+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2016-06-05T06:41:00-06:00"
lastmod = "2016-07-06T16:12:00-06:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1465330935560/2016-06-08---Toronto-London.jpg.jpg"
publishDate = "2016-06-07T15:54:00-06:00"
related_articles = ["articles/london-calling.md","articles/banffbound-2016.md","articles/the-future-of-opera-is-indie.md","articles/teeoh-eh.md"]
related_companies = ["scene/companies/royal-opera-house.md","scene/companies/english-national-opera.md","scene/companies/classical-opera.md","scene/companies/mahogany-opera-group.md","scene/companies/city-of-london-sinfonia.md","scene/companies/london-contemporary-orchestra.md","scene/companies/against-the-grain-theatre.md","scene/companies/indie-opera-to.md"]
related_people = ["scene/people/allan-clayton.md","scene/people/ermonela-jaho.md","scene/people/david-butt-philip.md","scene/people/rachel-kelly.md","scene/people/jennifer-france.md","scene/people/bryn-terfel.md","scene/people/diana-damrau.md"]
short_description = "It&#039;s been invigorating to hear such exciting voices that are new to our ears. Perhaps it&#039;s our bias showing, but the conclusion we draw is that Canadian singers are pretty fantastic. It&#039;s not a better-than situation, and we don&#039;t waste our time comparing the voices onstage over versus back home; but really, for a country that can struggle with niggling inferiority complexes, it&#039;s a neat thing to see that Canadian singers hold their own among the great voices working in one of the world&#039;s most established artistic centres."
slug = "canadians-abroad-the-quarterly-report"
title = "Canadians abroad: the quarterly report"
+++

It's been over three months since we left Toronto to set up shop in London, England. Next week, we'll be back across the pond, overshooting our beloved CN tower, and landing in the mountains of Banff, Alberta. We're not yet done with London, and although we're eager to pay a visit to the homeland and spend some time with the lovely folks of [Against the Grain Theatre](/scene/companies/against-the-grain-theatre/), the opera and classical music scenes in Britain's capital have us inspired and curious. It's a good time to do a first recap of sorts, taking stock of what we've had the chance to see and hear, and sharing our first impressions of what opera looks like on both sides of the Atlantic.

## New voices, new spaces

They do beautiful theatres very, very well here. We'll admit to some childish giddiness upon first stepping into the auditoriums of the rich and red Royal Opera House, the lush and ornate London Coliseum, and the grand and expansive Royal Albert Hall. We loved our trip to Chelsea's Cadogan Hall, full of pricey shopping, cool art, and alluring private gardens. It's a similar trip over to the famed Wigmore Hall, an unassuming spot along Wigmore Street that one could easy pass by, with little hint of the artistry that has happened inside.

Even more exciting than a new place to hear opera are the new voices that sing it. A few of these voices weren't entirely new, but it was a thrilling thing to hear our first live taste of folks like [Diana Damrau](/scene/people/diana-damrau/) in [*Lucia di Lammermoor*](/in-review-lucia-di-lammermoor-at-roh/) and [Bryn Terfel](/scene/people/bryn-terfel/) in [*Boris Godunov*](/in-review-boris-godunov/), both at the Royal Opera. British tenor [Allan Clayton](/scene/people/allan-clayton/) broke our hearts first as Tamino in [ENO's *The Magic Flute*](/in-review-enos-the-magic-flute/), and then again in the title role of Elgar's [*The Dream of Gerontius*](/great-nights-the-dream-of-gerontius/) at the Barbican Centre. [Ermonela Jaho](/scene/people/ermonela-jaho/) wowed us as [Suor Angelica at ROH](/in-review-il-trittico-at-roh/), and we're enthusiastic new fans of tenor [David Butt Philip](/scene/people/david-butt-philip/), whom we heard in *Boris*, and again as our favourite villain in ENO's *Madam Butterfly*. [Classical Opera](/in-review-classical-operas-il-vologeso/) showed us the thrilling mezzo of [Rachel Kelly](/scene/people/rachel-kelly/), and the ball of energy that is soprano [Jennifer France](/scene/people/jennifer-france/).

It's been invigorating to hear such exciting voices that are new to our ears. Perhaps it's our bias showing, but the conclusion we draw is that Canadian singers are also pretty fantastic. It's not a better-than situation, and we don't spend time actively comparing the voices onstage over here versus back home; but really, for a country that can struggle with niggling inferiority complexes, it's a neat thing to see that Canadian singers hold their own among the great voices working in one of the world's most established artistic centres. It's one of those intra-industry sayings in Canada, that our singers are well-trained and well-respected internationally. Fellow Canadians, that's a stereotype up to which you can be proud to live.

## Opinionated folks

We've noticed a curious duality here. London is home to opera of stunning quality, and its creators hold a deep respect for its place among the city's culture; at the same time, there's a beautiful sense of being relaxed, settled, and comfortable about making and consuming high art. There's something endearing about experienced opera-goers, lining the lobby of the Royal Opera House to dig into their little cups of intermission ice cream, benevolently ignoring the first and second warnings that they should all be taking their seats. It's a demeanour that Canadians would associate more closely with a night out at the movies.

The biggest differences can be summed up simply: audiences are louder about their opinions, and there's much more opera to see during a season. These two things are linked; the more shows to catch, the more listeners can learn about opera. And, the more they learn, the stronger their opinions grow. Londoners have an embarrassment of riches when it comes to sheer operatic quantity. The seasons are longer, and there's a distinct feeling that each time we attend something, we're missing three other things happening on the same night.

Maybe that's why we've encountered bold seat neighbours, who bravely spark conversation with us about what they're about to see, and pointedly ask our opinion on related matters. They assure us that the previous production was *much* better, and when they spot our little notebook, they ask if I wrote down anything about the horrendous costumes. Or, they writhe in their seat for three acts and finally let out their frustration with a cathartic *boooooo* at the curtain calls. It's refreshing, and much more fun than Canadian politeness.

## Indie opera

The bias may be strong, but one opera pocket that seems to be a small here in London, considering the size of the city, is the small, gritty, and imaginative work that's become associated with the idea of "indie opera". Interestingly, there seems to be more of this work being done by orchestras than anything else. Ensembles like the [City of London Sinfonia](/great-nights-sketches-of-miles/) and the [London Contemporary Orchestra](/robert-ames-deep-minimalism-lco/) have really exciting programming to offer, and their audiences cover plenty of young folk and cross-genre interest. On the operatic side, there are companies like [Mahogany Opera Group](/scene/companies/mahogany-opera-group/) doing work that's more off the beaten path, and the work of Opera ERRATICA is enticing, if not readily available to see.

It's a far cry from Toronto's collective work outside of traditional settings like the [Canadian Opera Company](/scene/companies/canadian-opera-company/) or [Opera Atelier](/scene/companies/opera-atelier/). In the past season alone, opera-goers have been able to mix their love of the genre with [reality game shows](/in-review-a-little-too-cozy/), [peep show-type](/opera-for-voyeurs-opera-peep-show/) setups, updated classics, and [exciting emphasis on dance](/in-review-against-nature/) and visual art.

Londoners, we're all ears for suggestions of non-traditional opera to see. And Torontonians, kudos on you. We're excited for our time in the UK to continue, and for our conclusions to become more and more educated. On the horizon are a few more trips to Wigmore Hall and the London Coliseum, and a late summer jaunt to the Glyndebourne Festival.

For the coming weeks, we'll relish our time back in Canada, where our accent is uninteresting and the public transit is laughable.
