+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2017-04-28T15:46:00-04:00"
lastmod = "2017-04-29T10:42:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1493476461488/2017-04-29---RBA.jpg.jpg"
publishDate = "2017-04-29T09:48:00-04:00"
related_articles = ["articles/in-review-opra-de-montrals-atelier-lyrique-joins-the-coc-ensemble-studio.md","articles/canadian-singers-their-great-reputations.md","articles/the-opera-party-monologue.md","articles/a-week-in-the-amphitheatre.md"]
related_companies = ["scene/companies/canadian-opera-company-ensemble-studio.md","scene/companies/latelier-lyrique-de-lopra-de-montral.md","scene/companies/lopra-de-montral.md","scene/companies/canadian-opera-company.md"]
related_people = ["scene/people/geoffroy-salvas.md","scene/people/caroline-gelinas.md","scene/people/danika-lorn.md","scene/people/kevin-geddes.md","scene/people/emily-dangelo.md","scene/people/stephane-mayer.md","scene/people/carolanne-fraser.md"]
short_description = "hat seemed like the true oversight, at least for this recital of Canadian young artists, is that no young, Canadian music made it onto the programme. These annual collaborations between two of Canada&#039;s biggest opera houses seem like a perfect opportunity to explore the huge library of 20th- and 21st-century opera, much of which comes in the form of short, self-contained scenes that are perfect for a showcase concert."
slug = "canadian-yaps-missed-opportunities"
title = "Canadian YAPs &amp; missed opportunities"
+++

Each year, the young artists of the [Canadian Opera Company Ensemble Studio](/scene/companies/canadian-opera-company-ensemble-studio/) head to Montréal to visit their operatic counterparts at the [l'Atelier lyrique de l'Opéra de Montréal](/scene/companies/latelier-lyrique-de-lopera-de-montreal/), and the singers of the Atelier return the favour with a trip to Toronto. In both cities, a week of work with the musical and artistic staff at the COC and l'OdeM culminates in a collaborative recital; here in Toronto, the young artists offered up arias and operatic scenes as part of the Free Concert Series in the Four Seasons Centre's Richard Bradshaw Amphitheatre.

COC Ensemble members [Emily D'Angelo](/scene/people/emily-dangelo/), [Danika Lorèn](/scene/people/danika-loren/), and [Stéphane Mayer](/scene/people/stephane-mayer/) (pianist) welcomed to the Amphitheatre [Kevin Geddes](/scene/people/kevin-geddes/), [Caroline Gélinas](/scene/people/caroline-gelinas/), [Geoffroy Salvas](/scene/people/geoffroy-salvas/), and [Carol-Anne Fraser](/scene/people/carol-anne-fraser/) (pianist) of the Atelier lyrique. They shared a programme of operatic hits, like the trio from *Così fan tutte*, the quartet from *Rigoletto*, and the dramatic final scene of *Carmen*; the visiting singers from Montréal took the spotlight with solo arias, to give Toronto audiences an extra taste of these emerging voices.

The young artists all showed clear skill, no doubt. Emily D'Angelo's performance of "Contro un cor" from *Il barbiere di Siviglia* was a total riot, and her duet from *Così fan tutte* with Danika Lorèn was both adorable and mature. Yet when we were most curious to hear the visiting singers from Montréal, it seemed a bit of a shame that the singers of the Atelier lyrique chose (or were encouraged to choose) repertoire that did little to show their true sounds. 

Salvas, a strapping, fiery baritone, sang "Fin ch'han dal vino" from *Don Giovanni*, and "Mab, la reine des mensonges" from *Roméo et Juliette*, two of the most frantic, wordy arias in the traditional repertoire; he sang both arias admirably and with ease, neither really gave Salvas the space to truly let out his sound. Kevin Geddes offered Verdi's "La donna è mobile" just before the famed *Rigoletto* quartet; it showed perhaps where the young tenor's voice will be in future seasons, but gave little indication of what he can do in the present. Gélinas showed off a clear, light "Habanera" from *Carmen*; her sound is lovely, but the choice of Bizet seemed to ignore all the signs pointing to a sweet spot in Handel, Mozart, or Rossini.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1493476305573/2017-04-29---Atelier-Ensemble.jpg.jpg)
<figcaption>Clockwise from top left: Emily D'Angelo, Geoffroy Salvas, Caroline Gélinas, Danika Lorèn, Kevin Geddes.</figcaption>
</figure>

There's boring repertoire nitpicking that can be done for eons, about whether or not a young singer should be performing Rameau or Wagner or anything in between. What seemed like the true oversight, at least for this recital of young, Canadian artists, is that no young, Canadian music made it onto the programme. These annual collaborations between two of Canada's biggest opera houses seem like a perfect opportunity to explore the huge library of 20th- and 21st-century Canadian opera, much of which comes in the form of short, self-contained scenes that are perfect for a showcase concert. 

Judging from what we've heard at [Tapestry Opera](/scene/companies/tapestry-opera/) events (like their [Booster Shots](/in-review-tapestry-briefs-booster-shots/) or [Songbook](/he-saidshe-said-songbook-vi/) series), or even the brilliant [*shadow box*](/in-review-shadow-box/) that [The Bicycle Opera Project](/scene/companies/the-bicycle-opera-project/) toured in 2015, there's an enormous library of imaginative opera to choose from. 

Perhaps it's a personal taste thing, that we'd love to hear these gems in the very public environment of the Amphitheatre; but the bigger opportunity lies in what new opera does for the development of these young singers. Works like these are not only indicative of what the near future holds for graduates of the Ensemble Studio and the Atelier lyrique, but performing this kind of opera hones the skills that they'll inevitably be asked to use in their 21st-century careers.

Maybe the real issue isn't about the merits between old and new opera; instead, it's about asking the heads of these young artist programmes about the goal, the artists' benefit of these collaborative concerts - and frankly, of their time as young professionals at major opera companies.
