+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2016-12-23T10:07:00-05:00"
lastmod = "2016-12-28T09:25:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1482857909449/2016-12-27---Canada.jpg.jpg"
publishDate = "2016-12-28T08:52:00-05:00"
related_articles = ["articles/canadian-yaps-missed-opportunities.md"]
related_companies = ["scene/companies/cosi-centre-for-opera-studies-in-italy.md"]
short_description = "Perhaps it&#039;s because we border the behemoth that is the United States, and perhaps it&#039;s because we&#039;re far-removed from the operatic centre that is Europe. In any case, it drives Canadian singers to meet the perceived standards of the &quot;biggest and best&quot;. Maybe we underestimate the quality of training available at home, and thus we head out into the world in over-prepared hordes. "
slug = "canadian-singers-their-great-reputations"
title = "Canadian singers &amp; their great reputations"
+++

Canadians are known for our polite dispositions, our hot-commodity maple syrup, and perhaps in recent years, our extremely dreamy Prime Minister. Canada is the friendly and soft-spoken neighbour to the United States, and a quaint spin-off of sorts of the British monarchy. It's home to beautiful, hardy cities and stunning landscapes of all ilks; Canadians can spend their whole lives traveling within their home borders and still experience a sense of awe and pride for their country.

Though opera may not be what comes to mind when one thinks of Canada, Canadian singers like Jon Vickers, Maureen Forrester, Louis Quilico, and Judith Forst have secured a place among the world's great operatic artists. Today, stars like Gerald Finley, Jane Archibald, and Adrianne Pieczonka share the stage with the best in the world. Canada's contribution to the opera world is no consolation prize, no excellent-for-a-Canadian situation; they're rightfully known as among the world's best.

If Canada has an unique reputation among the international opera industry, it's that its singers are known for being excellently-trained. The heads of opera companies and young artist programmes notice the attention to detail and high standards of singing that Canadians bring to the audition room; it's a flattering status to have, and it's a curious task to pinpoint precisely why Canadians seem to live up to their operatic hype.

The first, most concrete explanation lies in our familiarity to multiple languages. Linguistic skills are wildly important for any successful opera singer; though Canada's bilingual culture doesn't necessarily guarantee fluent speakers of both English and French, simple exposure to a second language throughout our formative years goes a long way. Sure, French and English make up only a portion of the important operatic languages; yet the difference between the two is significant. 

For an English-speaker, exposure to French offers a very different palette of sounds, including nasal vowels and subtle-yet-major differences in the various schwas. French exemplifies the grammar and syntax that's found in its fellow Romance languages, and the pronunciation rules of French are arguably more difficult to master than those of Italian and Spanish. It counts for a lot that Canadians grow up seeing bilingual signs and hearing French channels on the radio and television. After coaching university-level American singers in French diction, it's glaringly obvious that Canadians, even with a passive exposure to a difficult second language, have a huge advantage.

Of course, Canadians offer much more than a head-start on foreign languages. Like singers from around the world, Canadians seek out the best possible vocal training. There are two congruous tropes about Canucks: firstly, that Canada only fully embraces its singers who have returned home after pursuing high-level training abroad, and secondly, that Canadians suffer from an inferiority complex of sorts.

Canadian schools which offer good music programs may be few and far between for such a large country, but they continuously produce well-trained singers. Students are encouraged to hop across the pond to further their training and gain professional experience, and summer programs like the [Centre for Opera Studies in Italy](http://www.co-si.com/) (COSI) are an excellent way of bridging that gap. Before they're thrown into a German *Fest* contract or a French young artists programme, Canadians have the opportunity to travel with their fellow countrymen and women to Italy, where a high standard of training accompanies an introduction to the role of opera in a different culture.

Great teachers are found within Canada's borders, no doubt (and many of them make an annual summer pilgrimage to Sulmona with [COSI](http://www.co-si.com/)). Like the young, motivated singers, Canada's operatic mentors know the value of following great teachers, coaches, directors, and agents around the world. COSI is a great stepping stone for Canadians into the European audition circuit, offering freshly honed Italian language skills and a coveted proximity to operatic hubs in Italy and Germany. 

A word on that so-called inferiority complex: perhaps it's because we border the behemoth that is the United States, and perhaps it's because we're far-removed from the operatic centre that is Europe. In any case, it drives Canadian singers to meet the perceived standards of the "biggest and best". Maybe we underestimate the quality of training available at home, and thus we head out into the world in over-prepared hordes. 

Maybe it's of value that Canada doesn't have the same cultural association with opera as do Germany or Italy; we don't have the same insular level of national pride that keeps us from traveling the world in pursuit of the best available training, domestic or otherwise. In other words, maybe our egos are not in our way.

If you're on the hunt for an international boost in your operatic training, you'll be happy to know that [COSI has extended the application deadlines](https://www.yaptracker.com/applications/cosi-2017) for its Opera and Opera Scenes programs to **January 16, 2017**. For the Oratorio and Opera Chorus programs, you have until **February 20, 2017** to apply.
