+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2014-12-04T12:46:00-05:00"
lastmod = "2015-04-13T17:57:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428962193727/OperaMakingMoney.jpg.jpg"
publishDate = "2014-12-04T12:46:00-05:00"
related_articles = ["articles/opera-by-the-numbers.md"]
related_companies = ["scene/companies/canadian-opera-company.md","scene/companies/vancouver-opera.md","scene/companies/edmonton-opera.md","scene/companies/opera-lyra-ottawa.md"]
short_description = "Opera doesn&#039;t make money, it never has, and we all know it. I was recently asked about opera&#039;s economy and why opera companies have never functioned as a for-profit theatre company. The theoretical comparison was between the Canadian Opera Company and Mirvish Productions. "
slug = "can-opera-make-money"
title = "Can Opera Make Money?"
+++

Opera doesn't make money,&nbsp;it never has, and we all know it.&nbsp;I was recently asked about opera's economy&nbsp;and why opera companies have never functioned as a for-profit theatre company. The theoretical comparison was between the<a href="http://www.coc.ca/Home.aspx" target="_blank"> Canadian Opera Company</a> and <a href="http://www.mirvish.com/" target="_blank">Mirvish Productions</a>. My initial response to the question of a business model was that there was simply not enough money. Opera is expensive to put up, and expensive to maintain; Mirvish Productions was funded with Ed Mirvish's wealth, and designed to make money from its theatres and productions.&nbsp;As with most opera and theatre companies worldwide, the COC receives government grants, and both corporate and individual donations to supplement their revenue from ticket sales. Without that <a href="http://www.coc.ca/SupportTheCOC/CorporateSupport/OurCorporatePartners.aspx" target="_blank">kind of support</a>, the math simply wouldn't add up. We know this in the theatre industry; it's nothing new. So, with all the generous donors keeping opera afloat, why&nbsp;hasn't there been a notable attempt to invest in starting an opera company that will eventually self-sustain?</p><p>For an opera house&nbsp;to operate as a for-profit company, it can't rely on government grants or donations (only non-profit organizations can do that); its revenue needs to come from ticket sales. That's a huge shift from the current state of opera economics. For most companies, cutting grants and donations would wipe out around <a href="http://files.coc.ca/pdfs/1314_COCAnnualReport.pdf" target="_blank">half of their revenue</a>. They would have to rely on ticket sales, which currently make up about 25-40% of most companies' incomes. So, production costs would need to go way down (it was the number one expense, by far, for the <a href="http://files.coc.ca/pdfs/1314_COCAnnualReport.pdf" target="_blank">COC</a>, <a href="http://www.vancouveropera.ca/sites/default/files/2014-VOA-Financials.pdf" target="_blank">Vancouver Opera</a>, <a href="http://edmontonopera.com/pdf/season/2014/EO_financialstatements.pdf" target="_blank">Edmonton Opera</a>, and <a href="http://operalyra.ca/wp-content/uploads/2014/02/Audited-Financial-Statements-2012-13.pdf" target="_blank">Opera Lyra</a>), and the Canadian Actor's Equity Association would have to do an overhaul on the fee system. Performers under <a href="http://caea.com/EquityWeb/EquityLibrary/Agreements/Opera/IOPA/IOPASearchable.pdf" target="_blank">CAEA's Opera agreement</a> earn a weekly fee that's up to twice as much as performers under the <a href="http://caea.com/Equityweb/EquityLibrary/Agreements/Theatre/CTA/2012-2015CTAFeeBooklet.pdf" target="_blank">Theatre agreement</a>. I'm not saying opera companies pay their artists too much, let me be clear about that. But the fee structure isn't sustainable for a business model that depends on a 40-50 show run, as opposed to a standard opera run of 4-10 shows.</p><p>As I hunted for examples of for-profit theatre companies, I stumbled across <a href="http://www.gorillatango.com/" target="_blank">Gorilla Tango Theatre</a>, a Chicago-based, for-profit theatre distribution and promotion&nbsp;company. <a href="http://www.chicagoartistsresource.org/artist-stories/making-theater-makes-money" target="_blank">Dan Abbate</a> founded the company&nbsp;in 2006, in a different fashion than your everyday startup theatre company.&nbsp;<a href="http://www.gorillatango.com/" target="_blank">Gorilla Tango Theatre</a>&nbsp;provides all the large, upfront expenses for production, like performance and rehearsal space, lighting, sound, box office services, house management, etc. Shows being produced through GTT must make a minimum box office revenue of&nbsp;$250 per hour of performance; after the minimum has been met, GTT and the theatre company split profits 50/50. after which they split profits 50/50 with the theatre companies. The goal is to expand to various performance venues&nbsp;throughout the US (and hopefully Canada) in order to house more productions in more cities.&nbsp;"Our success is a direct function of our business model being based on profitability and sustainability, rather than a specific creative agenda. This enables GTT to be nimble and adjust our product mix based on market demand. We are not tied to a specific mission (which can be difficult to change in a nonprofit even when that mission is no longer working for the organization), nor is our ability to make quick decisions restrained by the group politics often found on non-profit boards."</p><p>Abbate isn't an artist first; he's a businessman first. I think the idea of starting a theatre company without first having a love for art is distasteful for many working artists. But shout it be? "Theater&nbsp;academics and authorities are stuck in tradition and 'the way things have always been done.' They are generally disconnected from the world around them, which is constantly changing and moving forward," Dan says. "The people who don't succeed in theater probably couldn't run any other sort of business either. I think that is the root of the problem. People who are interested in the creative side of theater should focus on being creative. They should not be starting companies." Business savviness though he may have, there's one big catch with Abbate's plan: Gorilla Tango Theatre won't distribute shows&nbsp;for Equity companies. "The projects they produce often don’t appeal to a broad market (Joe and Jill Everyperson are generally not terribly interested in traditional works) and their cost structures do not lend themselves to likely profit. I have seen many proposals for shows where the company would not make a profit even if every show were sold out."</p><p>Here in Toronto,&nbsp;<a href="https://www.soulpepper.ca/" target="_blank">Soulpepper Theatre Company</a>&nbsp;has also&nbsp;found a way around the standard, inflexible, method of programming a season. Says <a href="http://www.theglobeandmail.com/arts/theatre-and-performance/torontos-soulpepper-theatre-embraces-new-business-model/article564918/" target="_blank">J. Kelly Nestruck</a> at <em>The Globe and Mail</em>,&nbsp;"Plays are programmed for a set number of weeks - and whether they're hits or they're flops, they have about the same number of performances. There's very little relationship between supply and demand." It seems like an obvious oversight; Soulpepper artistic director Albert Schultz recognized that "no other business in the world operates this way and it just makes no sense." Soulpepper has begun scheduling shows and engaging artists in short-term increments of a few months, employing&nbsp;performers for multi-show contracts. This method leaves them free to adjust the remainder of their season according to the popularity of each show.</p><p>It seems so simple: listen to the demand, and give the audience what it wants. Why don't opera companies operate like this? Because their programming and casting have become inflexible. Productions and artists are booked multiple seasons in advance, and mid-season changes&nbsp;are almost impossible without losing cast members (particularly the biggest names). Again, the CAEA agreement and other unions would have to completely revamp their stipulations to accommodate shorter-term booking and mid-season changes according to audience demand. And since we're talking about a for-profit opera company, the creative decisions for the season would no longer be tied to receiving grant money and donations. It really could be about what the audience wants to see more and less onstage. &nbsp;What would that look like?&nbsp;Would it be nothing but&nbsp;<em>La bohème</em> and&nbsp;<em>The Phantom of the Opera</em>? Or would a "working on commission" mindset push creative teams to prove opera's relevance and deliver live theatre that fills the house the same way Mirvish's&nbsp;<em>Les misérables&nbsp;</em>can?</p><p>I think this brings us to the crux of the opera business model (really, any business model): if the product isn't in demand, you won't make money. I hate to think that the reason&nbsp;an opera company couldn't go for-profit is that not enough people will ever go. Since I'm sure I'm nowhere near the first person to ask these questions about opera's monetary potential, perhaps artsy economists have already figured out that non-profit status is the only way most opera and theatre can survive. If we grant that not enough bums are in seats at the opera, would cutting production costs, extending show runs, and actually listening to the audience demand be enough to change that? Is there an arts-loving investor willing to put down <em>lots of money</em> to see how long it takes to make any of it back? These questions are making me sound more and more naïve, aren't they?</p>
