+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2015-05-25T13:58:00-04:00"
lastmod = "2015-06-03T17:03:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1432606582797/BerlinSquare.jpg.jpg"
publishDate = "2015-05-26T08:11:00-04:00"
related_articles = ["articles/opera-on-steroids-budapest.md"]
related_companies = ["scene/companies/the-metropolitan-opera.md","scene/companies/staatsoper-berlin.md","scene/companies/deutsche-oper-berlin.md","scene/companies/bayerische-staatsoper.md","scene/companies/wiener-staatsoper.md"]
short_description = "Opera in New York has been pretty perilous the past few years, between NYCO&#039;s demise and potential rebirth, and the Metropolitan Opera&#039;s frustrating back-and-forth with several of its unions last summer. &quot;The smartest city in the world seems to think that opera is an old-fashioned, expensive toy — or worse, high camp, something so ridiculous you can’t help adding it to your list of guilty pleasures.&quot;"
slug = "can-nycs-opera-scene-take-good-advice"
title = "Can NYC&#039;s opera scene take good advice?"
+++

I like this *Observer* article, entitled, ["Who Can Fix Opera in New York? The Germans!"](http://observer.com/2015/05/who-can-fix-opera-in-new-york-the-germans/) 

Opera in New York has been pretty perilous the past few years, between NYCO's demise and potential rebirth, and the Metropolitan Opera's frustrating back-and-forth with several of its unions last summer. "The smartest city in the world seems to think that opera is an old-fashioned, expensive toy — or worse, high camp, something so ridiculous you can’t help adding it to your list of guilty pleasures." 

I concur, which is why the guidelines inspired by the German way of opera-making are smart and valid. There are problems, though, with encouraging opera bosses in New York (and the rest of North America, arguably) to "Rethink genre," or "Don't promise a masterpiece every time," or especially "Never, never forget that opera is for everybody."

A pretty huge part of the Metropolitan Opera's image is its grandeur, its rarity. Opera fans visiting New York City squeal about their rush tickets to see *La bohème* or some other show that features a big-name singer and awesome crystal chandeliers. The Met experience screams, *"This is not your average night out! You are part of something old and important and special!"*

In our panel on Regietheater, stage director Joel Ivany made a good point in the form of a Thanksgiving-dinner analogy. In North America, opera seasons are shorter and sparser, making each performance special (perhaps too special). Since opera, or Thanksgiving dinner, is a fairly rare occurrence, North American audiences are more hesitant to branch out from their premature expectations of what an opera is. In Germany, opera is less like Thanksgiving dinner, and more like Sunday brunch: not an every-day thing, but common enough to want to branch out from bacon and eggs. When the Germans (the hypothetical ones in this article) advise New York to "have fun" with their opera, and "remember that a little controversy is not going to kill you," they're basically asking North American audiences to change what they want to see. 

I mean, it shouldn't be such a laughable concept, to think of a show like *Carousel* or *Into The Woods* hitting the stage at the Met, but it is. Partly to blame is the notion that opera is a sub-genre of Classical music, not theatre. Perhaps Met-types see additions like *Sweeney Todd* and *Carousel* as, at worst, selling out to the masses, and at best, an unfortunate divergence away from what opera "really is." Hilarious, considering the musical complexity of Sondheim compared to Bellini.

People in North America want to see *Tosca* and other classics they way they imagined it, partly because it might be one of their only chances to see it live. They don't want risky productions or re-imaginings of their opera, and it would be an immediate detriment to a place like the Met. Whether or not that's a good reason to keep producing more and more traditional operas in traditional productions, that's another question.

I think the Germans' tips could work with not this generation of opera bosses (and donors, frankly), but the next. The mindset of a generation is in place; in the meantime, however, I think we should address the loud fact that opera is a borrowed art form. In Europe, so many of the barriers are non-existent; people speak German in Germany, for one. For them, opera grew organically out of other combos of music and text. For North Americans, it's fancy (except it's not; the stories are about oppressed women and conflicted men on the best and worst days of their lives).

Contemporary opera is held back from potential new audiences, setting it apart from shows like *Carmen* and *Rigoletto*, which are rumoured to be good gateway-operas for newbies. Contemporary opera is like "varsity-level opera," and not everybody gets to play. Since opera is an adopted cultural element with once-removed connections to its audience, perhaps a newcomer would see more magic in *Two Boys* than *Traviata*. And why not? There's no language barrier, the story is contemporary, and the grandeur of *Two Boys*, anyway, still remains.

I'm not done with this topic, but I'm basically saying that before New York can learn from Germany, they've got to admit there's something to learn. It's not even about getting wacky with productions; this is about putting forward the new, not necessarily the beloved. I love the *Observer*'s bit about not promising your audience a masterpiece each time. I suppose that's a bit of the American way, though.
