+++
author = ["authors/loren-lester.md"]
categories = "Review"
date = 2022-11-15T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = "Regina Opera Company's production of [_The Telephone_ and _The Medium_](http://www.reginaopera.org/menotti.htm) is double-cast.  The performers described in this review return on November 20th."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1668565280/media/2022/11/sqTheTelephone_StevenPisano__09512_wxvlzj.jpg"
primary_image_credit = "Chris Drago Fistonich as Ben in The Telephone, Regina Opera Company, 2022. Photo: Steven Pisano."
related_articles = ["articles/no-explanation-needed.md", "articles/counterculture.md", "articles/two-different-servings-from-the-opera-fest-menu.md"]
related_companies = []
related_people = ["scene/people/chris-drago-fistonich.md"]
short_description = "Both The Telephone and The Medium end with an unexpected turn and so the two operas result in a night of surprises."
slug = "calls-from-two-worlds"
title = "Calls From Two Worlds"
youtube_url = ""

+++
Opera companies producing full productions post-pandemic are hard to find in New York outside of the Met at Lincoln Center. Many companies have gone dormant, so it's very good news to report that the [Regina Opera Company](http://www.reginaopera.org/) (now in its 53rd season) is still alive and singing.

It's obvious from their choice of two short Menotti chamber operas (and the ultra-low budget production values of each) that the company has limited resources. However, as in the past, the singers and musicians are top tier.

_The Medium_ and _The Telephone_, with music and libretto by Gian Carlo Menotti, were a sensation in the late 1940's. It’s hard to imagine this today, but the double bill was actually presented on Broadway. As a curtain raiser, the comedy of _The Telephone_ is a wonderful contrast to the angst in _The Medium_ which follows, and so the programming continues to be revived as a satisfying pairing.

Both _The Telephone_ and _The Medium_ end with an unexpected turn and so the two operas result in a night of surprises.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1668565523/media/2022/11/TheTelephone_-StevenPisano__00013_xkhzlj.jpg){{% /md %}}

<figcaption>Brooke Schooley as Lucy and Chris Drago Fistonich as Ben in The Telephone, Regina Opera Company, 2022. Photo: Steven Pisano.</figcaption>  
</figure>

Menotti enjoyed his greatest success from the late 1940's through the 1950's. In a sea of musical modernism, the composer lived on an ever-shrinking island where he had picked up the baton from Puccini and the verismo tradition. Though he rejected the atonality of his contemporaries, you can hear their influence in the spooky dissonance of _The Medium_, which, nevertheless, also contains beautiful melodic arias. 	The subject matter of _The Telephone_ speaks to us today, even though technology has advanced to a cellular world where all noses seem to be buried in screens. You could see an opera like this being written today where the iPhone is the main prop. But with a score that includes a rotary phone and a plot point involving "cutting the phone cord", _The Telephone_ is clearly a period piece, albeit a timely one.

Splendid coloratura Brooke Schooley plays the gossipy Lucy, who can't stay away from incoming calls, even as her boyfriend attempts to get her attention long enough to become her fiance. Schooley's voice expertly trills and soars as her character fauns, cajoles, argues and laughs, sometimes like a comical singing hyena, with her unseen (and unheard) telephonic friends. Strong baritone Chris Drago Fistonich is the hapless boyfriend Ben who can't compete with Lucy's other lover - the one that's constantly ringing. (The libretto notes that the phone has created a _ménage à trois_.) The ending has an unexpected twist that gives you a well-needed chuckle before the drama unfolds in the second show of the evening.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1668565662/media/2022/11/TheTelephone_StevenPisano__9670_lonnny.jpg){{% /md %}}

<figcaption>Chris Drago Fistonich as Ben and Brooke Schooley as Lucy in The Telephone, Regina Opera Company, 2022. Photo: Steven Pisano.</figcaption>  
</figure>

Schooley returns after the intermission to assume quite a different role in _The Medium_. Schooley plays Monica, the obedient daughter of fraudster "medium" Madame Flora (Lara Michole Tillotson.) The casting here of Schooley and Tillotson is somewhat problematic as we’re supposed to accept that Schooley is Tillotson's daughter (with no attempt to age-up Tillotson who sings of being "old and sick.") Fortunately, the talents of both actresses help to suspend our visual disbelief, but not completely.

The plot centers around Madama Flora and her con game conducting phony séances, where she is aided by her daughter Monica and an orphaned mute she has adopted named Toby. Milos Kleiman, as Toby, is excellent at managing the difficult task of a non-singing, non-speaking role. He evokes pathos as he offers love and loyalty but suffers abuse from Flora, who is revealed to be a half-mad alcoholic. Tillotson, who made a tremendous Azucena here in _Il Trovatore_ is a powerful, tortured and frightening Madame Flora, even though she gets no help in the make-up or costuming department.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1668565736/media/2022/11/TheMedium_StevenPisano__01549_ycoa5j.jpg){{% /md %}}

<figcaption>(l-r) Chris Drago Fistonich (Mr. Gobineau), Monica Camafreita (Mrs. Gobineau), Lara Tillotson (Madam Flora), and Anna Viemeister (Mrs. Nolan) in The Medium, Regina Opera Company, 2022. Photo: Steven Pisano.</figcaption>  
</figure>

Schooley again shines as she sings the famous hits from the show, "Monica’s Waltz" and "The Black Swan". And her plaintive "mother, mother" as the fake ghost during the séance is, well, haunting.

Madame Flora's three gullible customers are all tragic figures. They've all lost children and long for a true connection to the afterlife. Monica Camafreita and Chris Drago Fistonich (from _The Telephone_), play Mrs. & Mr. Gobineau, and are actually happy, in a self-delusional way, believing that they are hearing their deceased two-year-old son laughing from the great beyond. Anna Viemeister plays a frightened Mrs. Nolan, who is attending her first séance, hoping to hear from her deceased teenage daughter. Camafreita, Fistonich and Viemeister form a moving trio and all three, especially Viemeister, have exceptional solo moments.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1668566046/media/2022/11/TheMedium_StevenPisano__04737_tgblog.jpg){{% /md %}}

<figcaption>Lara Tillotson as Madam Flora and Milos Kleiman as Toby in The Medium, Regina Opera Company, 2022. Photo: Steven Pisano.</figcaption>  
</figure>

The 19-piece orchestra, featuring first-rate strings and horns was led expertly by veteran conductor Gregory Ortega.

Regina Opera should have considered an evening on a bare stage with black curtains. With no budget, the set truly looked like something from a junior high school production. The costumes were half-baked - some were authentic fun finds from the 1940’s while others appeared to be out of the performers’ closets.

In a case like this, let the music speak for itself which it did here, and quite notably.