+++
author = ["authors/oliver-munar.md"]
categories = "Interview"
date = 2021-09-28T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = "After nearly a year-long search, [Calgary Opera](/scene/companies/calgary-opera/) has named Jonathan Brandani its new Artistic Director.\n\nBrandani is the fourth person in four years to be named to the key leadership role with the opera company, following the long-time tenure of the late Bob McPhee (General Director and CEO from 1998-2017), and two shorter stints by Keith Cerny (General Director and CEO from January-August 2018), and Bramwell Tovey (Artistic Director from January 2019-October 2020).\n\nOur Calgary-based contributor Oliver Munar, who will be returning to the Calgary Opera Chorus this season, caught up with his new boss."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1632840390/media/2021/09/sqBrandani_JennaMahr_qdwdng.jpg"
primary_image_credit = "Photo: Jenna Mahr."
related_articles = ["articles/calgary-opera-delivers-comedy-gold-with-wellcast-barber.md"]
related_companies = ["scene/companies/calgary-opera-emerging-artist-development-program.md", "scene/companies/calgary-opera.md"]
related_people = []
short_description = "The Italian-born conductor led Calgary Opera production of La bohème in 2019."
slug = "calgary-opera-names-jonathan-brandani-new-artistic-director"
title = "Calgary Opera names Jonathan Brandani new Artistic Director"
youtube_url = ""

+++
**Oliver Munar: Let's start by getting to know you a little better. What attracted you to the world of opera?**

**Jonathan Brandani:** I didn’t start as an opera person, I started as a piano player. Being a pianist, I had my first experiences playing for my best friends who were singers. They exposed me to the beautiful world of opera and I was fascinated and wanted to know more, and they asked me to play for rehearsals, voice lessons and performances. I didn’t even notice that I was into opera: at one point, I just realized that I love this artform and it felt so natural.

I remember playing as a repetiteur for an outdoor performance in Austria of Donizetti’s La fille du régiment: the cast was amazing, the costumes were fantastic and the whole experience felt so moving. It was at that moment where I realized I would love to continue this fantastic journey where all sorts of art meet and join forces to really create a powerful performance.

**You share a hometown with the great opera composer Giacomo Puccini (Lucca, Italy) so I have to ask: what's an opera, or perhaps a composer, that you would never get tired of programming?**

**Brandani:** I truly love Puccini but not because he’s from my hometown. He’s truly one of the greatest composers ever. There is so much humanity and feeling in his music. The vocal writing is amazing, orchestral writing is phenomenal, and he really wants to talk to the hearts of people: to tell beautiful stories in a compelling way.

**Do you have a favourite Puccini opera?**

**Brandani:** I really love _La fanciulla del West_. Compared to _Tosca_ or _La bohème_ it is not performed nearly as often, but it represents a great mix of symphonic writing, a very powerful story of redemption through love, and it’s one of the few operas that doesn’t end with a dead person on stage - it’s a happier ending and I really love it.

There’s so much tragedy in opera already and _La fanciulla_ is a serious and profound opera, but it really shows the power of love and how you, as an individual, can influence other people’s lives and create redemption. It gives a big message of hope that yes, we can shape the world for the better and yes, our actions can really create a better environment for everybody.

**Because _La fanciulla_ is not performed nearly as often as _La bohème_ and _Tosca_, can we perhaps assume or anticipate that _La fanciulla_ may make its way to Calgary Opera in the near future?**

**Brandani:** It’s too early to say, but there are so many things to take care of right away, but definitely it’s on my radar.

**What attracted you to this post with Calgary Opera, and to the city of Calgary in general?**

**Brandani:** I was in Calgary in the Fall of 2019 to conduct La bohème with Calgary Opera. I was there with my wife and two young boys and we loved our time there. We loved the city, we loved the surrounding area, and we loved the people. I thought the company and I had a nice chemistry: very friendly and collaborative. I really felt a human connection, not just an artistic one, and I remember very clearly that I would love to come back.

When I heard about the position being available, I thought why not give it a try? I had my heart filled with very good memories.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1632839948/media/2021/09/Brandani_CalgaryOpera_LaBoheme_JoannaLatini_ybttvh.jpg){{% /md %}}

<figcaption>Maestro Brandani, centre, surrounded by the principals of key production team of Calgary Opera’s celebrated 2019 production of Puccini’s La bohème. Photo: Joanna Latini.</figcaption>

</figure>

**What are you looking forward to the most, both in terms of your new role, as well as moving to Calgary?**

**Brandani:** We’re really excited to become part of the community in Calgary. I’m really looking forward to learning more about Canada, Calgary, and all the arts people and institutions on Treaty 7 territory. I’m looking forward to learning more about Indigenous cultures, traditions and people, to make new friends and to start this adventure with passion, commitment, and a desire to the best for both the company and the community we serve.

**You mentioned wanting to learn more about Indigenous culture. Have you or the company had those conversations about commissioning works or making inroads and relationships with local Indigenous communities towards works that can be featured by Calgary Opera?**

**Brandani:** Personally, I’m enrolled in a class at the University of Alberta to learn more about Indigenous cultures; I really see this as a priority to learn more. We have also started collaborations with members of the arts community in Calgary who are also members of various Inidgenous communities. A few months ago, the company started Opera Labs in which we featured _The Seeds of Namwayut_. I can tell you that this is just the start. We really want to embark on new adventures and we’re open to the possibility of learning more from the richness of Indigenous culture.

**We talked about what you look forward to, what do you anticipate as the greatest challenge as you assume this new role?**

**Brandani:** As a company, we need to be visionaries but we also need to be practical. I think the biggest challenge in the short-term will be how to deal with COVID-related financial losses and uncertainties. That’s something we cannot control entirely but we are making plans to deal with this in a successful way. We will be challenged to reconcile our vision, our willingness to do a lot of things with the reality of what we can actually do.

**What are some of the specific barriers that you see in making opera an artform for everyone?**

**Brandani:** One is education. I think we should invest more in education and allow opera to be known to people. We will definitely do more on that path. We also started the Community Ambassadors Program and we will definitely pursue additional opportunities along that path.

Another barrier could be financial. We want to continue with the Allegro program and to give more facility to people with fewer means to access our artform. We want to demonstrate that opera is not for a few. Opera can really speak to everybody. There is so much in opera that you can bring home with you: the power of the music, the power of the text, acting, costumes and lights. We are definitely open to explore new ways for promoting and producing operas so that we can attract younger audiences, different audiences, diverse audiences, and our hope is that we can accomplish all those things.

**How would you respond to criticism that opera is male-dominated, that its view of women can be unflattering, and how we reconcile what would have been a snapshot in time and making it current and relevant for today’s audiences?**

**Brandani:** When we deal with arts of the past, we are confronted sometimes with different world views and values. That doesn’t mean we endorse or want to subscribe or approve of everything that was done in the past. But we also believe in the power of art as transformative, something that can truly make society better. So when we present operas, we will ensure we don’t align with prejudices, but rather show the novelty of what’s fresh and beautiful, and maybe even take an opportunity to discuss what we don’t like. Life is full of beautiful things but there are also things we don’t like. We just have to be very clear about ideas we don’t like so we don’t repeat mistakes of the past.

Yes, women can be portrayed in ways that we would not portray them today. I think we should acknowledge this, start a conversation about what we would like to do differently, and use it as an opportunity to discuss how we can change things. Unfortunately, some things that we don’t like from the past are still present today.

**I read with great interest that you're a passionate interpreter of Early Music. I can’t remember the last time I saw an Early Music opera on the mainstage. Any chances that we may see some earlier opera make their way to the Calgary Opera mainstage in the near future?**

**Brandani:** I have a lot of experience playing harpsichord with some period-instrument ensembles in Europe, and I really love the opportunity to perform that repertoire. Early Music is fascinating and beautiful and we can both learn a lot and grow a lot. Yes, we’re thinking about that. When you venture outside the mainstream, you take bigger risks. I think we should start talking about those risks and talk about how we may bring those productions to Calgary.

**Your predecessors were also fervent supporters of commissioning works. Will commissions, especially by Canadian composers, continue to be on the menu at Calgary Opera?**

**Brandani:** Yes, it’s definitely something that continues to be important for the company. It has increased the reputation of Calgary Opera in the past and we should definitely pursue that. It’s part of a greater strategy to grow the operatic repertoire that hasn’t yet made its way to Calgary.

I think the best option is to keep our options open in each world - operas of the past, operas of the future. It’s a strategy that’s very dear to me because I have experienced first-hand how successful those operas can be. And definitely, we have started conversations about new operas and the role they can play in the future of Calgary Opera so I’m very excited to continue along that path..

**Because you’re so well travelled, you’ve had a chance to work with so many different artists. How do you balance the casting, in terms of making sure not only big names being brought to Calgary but also ensuring other Canadian voices (i.e., our Emerging Artists) and even those who are in our city can also have opportunity?**

**Brandani:** Balance is the key word. We should try to give opportunity for the audience in Calgary to experience famous or renowned singers, especially Canadian talents. At the same time, we are so proud of our Emerging Artists, it’s a great program that has been running for years that has produced great talents. We want to nurture Canadian talent, we want to prepare younger talent for the stage. The company is on a really good track and we really need to make sure we continue doing these good things, but also consider new ways of thinking about it.

Once I get settled in the city, I look forward to meeting members of the chorus and local talent to see who would be a good fit for various opportunities in our productions.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1632840373/media/2021/09/JonathanBrandani_JennaMahr_2_rlibt7.jpg){{% /md %}}

<figcaption>Photo: Jenna Mahr.</figcaption>

</figure>

**Calgary Opera celebrates its 50th anniversary in 2022-23. What ideas are currently being discussed? Any works or productions that are on your list?**

**Brandani:** We are finalizing some details but unfortunately not anything I can share just yet. As soon as the moment will come, I’ll be very excited to share with the community what the plans are and I really hope you love them.