+++
author = ["authors/oliver-munar.md"]
categories = "Review"
date = 2022-11-15T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1668567252/media/2022/11/sqCalgaryOpera_RihabChaieb_ClairePicheyre_v0jr69.jpg"
primary_image_credit = "Calgary Opera's 2022 production of Bizet's Carmen stars mezzo-soprano Rihab Chaieb. Photo: Claire Picheyre."
related_articles = []
related_companies = ["scene/companies/calgary-opera.md"]
related_people = ["scene/people/nmon-ford.md", "scene/people/david-pomeroy.md", "scene/people/brenna-corner.md", "scene/people/rihab-chaieb.md"]
short_description = "Carmen was born in the wrong century,” says Chaieb. “She’s no queen, she doesn’t come from a family with a lot of money. But Carmen has power and decisiveness. And she is the only character from the beginning to the end of the opera who doesn’t change who she is and how she expresses herself.”"
slug = "calgary-opera-launches-50th-anniversary-season-with-gritty-take-of-bizets-carmen"
title = "Calgary Opera launches 50th Anniversary Season with gritty take of Bizet’s Carmen"
youtube_url = ""

+++
In a lot of ways, Bizet’s _Carmen_ may be the ideal vehicle for opera companies to attract patrons back to live opera performance after two years of COVID. Arguably one of the most recognizable scores and stories in the operatic canon, Bizet’s score is full of earworms such as the "Habanera" or the "Toreador Song" that even the most passive music lover may recognize. What better way to launch the company’s golden anniversary season?

But says director [Brenna Corner](/scene/people/brenna-corner/), _Carmen_ offers much more than catchy music. "Bizet wrote a piece of theatre and just wrote all the subtext in the orchestra, and he wrote all the nuances of how he wanted it delivered in the musical line the singers sing," she tells Schmopera. "But _Carmen_ is a story of intimate partner abuse. Quite frankly, it's a dangerous and tragic story that still happens today to men and women alike, and that's a problem. We still have people who can’t be free, controlled by the people who are supposed to love them."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1668567008/media/2022/11/CalgaryOpera_ChaiebCorner_lllhs1.jpg){{% /md %}}

<figcaption>Director Brenna Corner and mezzo Rihab Chaieb spoke with Schmopera.com about Calgary Opera’s grittier take of Bizet’s Carmen at the Southern Alberta Jubilee Auditorium on November 19, 23 and 25. Photos courtesy of Calgary Opera and Rihab Chiaeb.</figcaption>  
</figure>

As the iconic Carmen, [Calgary Opera](/scene/companies/calgary-opera/) has cast Tunisian-Canadian mezzo [Rihab Chaieb](/scene/people/rihab-chaieb/), a graduate of the prestigious Metropolitan Opera Lindemann Young Artist Program, in her company debut. "Carmen was born in the wrong century," says Chaieb. "She's no queen, she doesn't come from a family with a lot of money. But Carmen has power and decisiveness. And she is the only character from the beginning to the end of the opera who doesn't change who she is and how she expresses herself."

## Keeping the story of _Carmen_ relevant

Corner acknowledges that for a long time, the story of _Carmen_ was told in a specific way, through the lens of a time in history when women had limited rights and freedoms. "For so long in the operatic tradition, we have honoured an older paradigm. That paradigm is not the world we live in now, and is not the story we should be telling," she says. "While we have to be smart about honouring what the composer and librettist originally wanted, we have to be smart in honouring our audience in what they need."

"The story of _Carmen_ is not really about how society was to women when Bizet first composed the opera," says Chaieb. "It's shame on us for not having evolved from that society, from an opera that was written almost 200 years ago." She points out the recent story of Mahsa Amini, the Iranian woman who died in police custody on September 22nd, who had been arrested in Tehran for wearing her hijab 'incorrectly'. "We still live this today and it’s almost 2023: how is this OK?"

## Keeping the story of _Carmen_ "real"

For an opera as well-known as _Carmen_, Corner says the challenge is to ensure moments of profound intimacy are not overshadowed by the pomp and circumstance that comes with grand opera. Corner says it was especially important not to set the story of _Carmen_ in a world where the victim can or should be blamed. "The idea of being able to withdraw consent at any point is one of the big reasons why it’s important to keep telling this story," she says.

"What I like about this staging is that I'm given _carte blanche_ to be playful," says Chaieb. "People are attracted to this character because of a certain _je ne sais quoi_ that is rooted in her power and confidence. She knows what she wants and knows her sexuality but is the victim of a very dark circumstance that still happens today." No spoilers on exactly how Chaieb's _Carmen_ will meet her end (after all, it’s opera), but both Chaieb and Corner say it is in keeping with how the story of _Carmen_ is about intimate partner abuse.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1668567036/media/2022/11/CalgaryOpera_FordPomeroy_pgvemd.jpg){{% /md %}}

<figcaption>Baritone Nmon Ford (Escamillo) and tenor David Pomeroy (Don José) also star in Calgary Opera’s production of Bizet’s Carmen to kick off the company’s 2022-23 season. Photos courtesy of Calgary Opera.</figcaption>  
</figure>

Chaieb plays opposite Panamanian-American baritone [Nmon Ford](/scene/people/nmon-ford/) as Escamillo (who is also making his debut with Calgary Opera) and Newfoundland tenor [David Pomeroy](/scene/people/david-pomeroy/) as Don José. Ford made his role and company debut as Crown in the English National Opera/Metropolitan Opera co-production of _Porgy and Bess_ and is the composer, librettist, and title-role performer for _House of Orfeus_, a 2024 co-production with Lincoln Center and Opera Carolina. Pomeroy was one of the company's guest artists in its 50th-anniversary celebration in mid-September and was celebrated as Prince Calaf in Calgary Opera's 2017 production of Puccini's _Turandot_. Asked how it felt to put together this intimate story of _Carmen_, Chaieb says it was likely more difficult on Pomeroy than for her.

"I throw myself on the floor. It's tough on my knees. David's the one always grabbing and reacting," she says. "But Brenna, with her background in stage combat, and our fight coordinator John Knight have created a safe space for us to tell this story in a very real way."

"My hope is that for people who may have had that experience of dealing with intimate partner abuse, they’ll recognize that we acknowledge the reality of it and not paint it up in a pretty opera picture," says Corner.

Calgary Opera performances of Bizet’s _Carmen_ are scheduled for November 19, 23 and 25 at the Southern Alberta Jubilee Auditorium and will be conducted by Mark Morash with the Calgary Philharmonic Orchestra, members of Calgary Opera’s McPhee Artist Development Program, the Calgary Opera Chorus and members of Cantare Children’s Choir. Tickets are available via [calgaryopera.com](https://calgaryopera.com/). Calgary Opera has issued an onstage violence advisory for this production, recommending it for youth in grades seven and above.