+++
author = ["authors/oliver-munar.md"]
categories = "Review"
date = "2017-11-19T11:38:00-05:00"
lastmod = "2017-11-20T14:03:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1511192573327/2017-11-20---square---Barber-2.jpg.jpg"
primary_image_credit = "John Tessier (Count Almaviva), Russell Braun (Figaro) and Andrea Hill (Rosina) in *The Barber of Seville*, Calgary Opera, 2017."
publishDate = "2017-11-20T10:46:00-05:00"
related_articles = ["articles/in-review-the-barber-of-seville-at-roh.md", "articles/in-review-the-barber-of-seville-at-the-coc.md"]
related_companies = ["scene/companies/calgary-opera.md"]
related_people = ["scene/people/russell-braun.md", "scene/people/peter-mcgillivray.md", "scene/people/christopher-mokrzewski.md", "scene/people/aaron-dimoff.md", "scene/people/annemarie-macintosh.md", "scene/people/andrea-hill.md"]
short_description = "With Barber, Calgary Opera gets the laughs, thanks to a roster of principals at the top of their craft who are well cast for their respective roles. More importantly, it does justice to one of the most beloved works in the operatic repertoire, by casting singers who can handle the vocal acrobatics of Rossini."
slug = "calgary-opera-delivers-comedy-gold-with-well-cast-barber"
title = "Calgary Opera delivers comedy gold with well-cast Barber"

+++
I have a confession to make. Despite my love of opera, the only experience I had with Gioachino Rossini's *The Barber of Seville* was from Saturday mornings watching cartoons.

That said, even the hilarity of Warner Brothers' adaptation paled in comparison to Calgary Opera's production. 

Compared to drama, comedy can be hard to pull off successfully because humour is many things to many people. But judging by the reaction from the capacity audience at Saturday night's premiere, Calgary Opera has all the necessary ingredients for a memorable run that will appeal to even the most fussy patron. The entire company realized the vision of Alain Gauthier, stage director, through their sense of timing and comedic ensemble. Whether they rattled off Italian conversationally in a moment of recitative or spat out lyrics in one of Rossini's famous fast sections, there are no weak moments.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1511192630928/2017-11-20---Barber-1.jpg.jpg)
<figcaption>John Tessier (Count Almaviva), Andrea Hill (Rosina), and Russell Braun (Figaro) in *The Barber of Seville*, Calgary Opera, 2017.</figcaption>
</figure>

The titular barber -- Figaro -- was sung with gusto and aplomb by baritone [Russell Braun](/scene/people/russell-braun/). The role is not easy to navigate vocally, but Braun soared through each note without breaking a sweat, adding the odd flourish in his well-developed higher register for good measure. Even an unplanned slip on some shaving cream did nothing to derail the richness and depth of his effervescent singing. This was Figaro as it was meant to be sung, by one of Canada's most celebrated voices.

Baritone [Peter McGillivray](/talking-with-singers-peter-mcgillivray/) is also to be celebrated in his role as the buffoonish Doctor Bartolo. McGillivray's resonant singing filled the auditorium with a vibrant sonority that helped translate the comedic vision for his character to the audience. McGillivray's Bartolo was an audience favourite for good reason: he embodies the essence of his character, and backs it up with rich, round singing.

The lovers at the centre of the comedy, Count Almaviva and Rosina, were played by tenor [John Tessier](/scene/people/john-tessier/) and mezzo-soprano [Andrea Hill](/scene/people/andrea-hill/), respectively. The Calgary-born Hill is a well-cast Rosina: a warm, sparkling voice that is well suited for both lyric and demanding coloratura passages. In one aria alone, her voice sails through a staggering two octaves with rich, secure and consistent tone that drew audible gasps of appreciation from the audience.

Tessier offers a truly virtuosic Almaviva in terms of both comedic acting and vocal quality. Tessier's voice soared well into the melismatic stratosphere in each of his character's big moments; you're left to wonder if there is a note Tessier can't hit with security, richness and ease. As a comedic actor, Tessier is certainly on par with the other principals. His turns as a drunken soldier and as a joyous, peaceful substitute voice teacher show off the tenor's comedic and acting range. He truly shines in his interactions with Hill, McGillivray, and especially Braun. The two offer a number of hilarious moments as a scheming duo in this production.

Special mention should be made for bass-baritone [Aaron Dimoff](/scene/people/aaron-dimoff/) and soprano [Anne-Marie MacIntosh](/scene/people/anne-marie-macintosh/), who appear in the supporting roles of Don Basilio and the housemaid Berta, respectively. Dimoff's rendition of the aria "La Calunnia" is a highlight for this production, while MacIntosh plays up her exasperation as the long-suffering housemaid to a tee. Indeed, MacIntosh's performance earns a fair share of laughs. Her sing of the aria "Il vecchiotto cerca moglie" shows an intimacy and vulnerability that endears itself to the audience.

The set design also deserves high praise. This particular imagining of *Barber* is set in the early 20th century, instead of the 18th century. The walls of Bartolo's residence are mostly white, which allows each colorful character to emerge. From Rosina's flowing coral dress to the leopard-printed housecoat for Bartolo, this colourful palette complements the bright singing of each character. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1511192727259/2017-11-20---Barber-3.jpg.jpg)
<figcaption>John Tessier (Count Almaviva), Russell Braun (Figaro) and Andrea Hill (Rosina) in *The Barber of Seville*, Calgary Opera, 2017.</figcaption>
</figure>

With *Barber*, Calgary Opera gets the laughs, thanks to a roster of principals at the top of their craft who are well cast for their respective roles. More importantly, it does justice to one of the most beloved works in the operatic repertoire, by casting singers who can handle the vocal acrobatics of Rossini. This is a production to be celebrated as imaginative, hilarious, and musically stunning.

>Calgary Opera's production of *The Barber of Seville* runs November 18, 22 and 24 at the Southern Alberta Jubilee Auditorium. For details and ticket information, [click here](https://www.calgaryopera.com/17-18/barber-of-seville).