+++
author = ["authors/oliver-munar.md"]
categories = "Review"
date = "2024-05-08T00:00:00-00:00"
lastmod = "2024-05-08T00:00:00-00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1715187585/sqCO_Rheingold_Justine_Ledoux.jpg"
primary_image_credit = "Justine Ledoux as Welgunde in Das Rheingold, Calgary Opera, 2024. Photo: HarderLee Photography."
publishDate = "2024-05-08T00:00:00-00:00"
related_articles = ["articles/fantasy-is-for-the-birds.md","articles/the-price-of-vengeance-rigoletto-at-roh.md", "articles/mo-carmen.md", "articles/in-review-siegfried.md"]
related_companies = ["scene/companies/calgary-opera.md"]
related_people = ["scene/people/catherine-daniel.md", "scene/people/kenneth-kellogg.md", "scene/people/phillip-addis.md", "scene/people/aviva-fortunata.md", "scene/people/lucia-cesaroni.md", "scene/people/neil-craighead.md"]
short_description = "On this night, the chemistry and blend were first-rate, setting the tone for the night's performance. Each embodied a mischievous playfulness in their encounter with Alberich that sets the action of Das Rheingold in motion."
slug = "calgary-opera-caps-23-24-season-with-innovative-run-of-wagners-das-rheingold"
title = "Calgary Opera caps 23-24 season with innovative run of Wagner's Das Rheingold"

+++
I now understand the appeal of Wagner's _Ring_ Cycle. Or at least the first of its four movements.

Truth be told, I had never seen any Wagner opera until this [Calgary Opera production of _Das Rheingold_](https://www.calgaryopera.com/23-24/rheingold), considered the "preliminary evening" of the famous _Ring_ Cycle that includes _Die Walküre_ (_The Valkyries_), _Siegfried_, and _Götterdämmerung_ (_Twilight of the Gods_). My love of the _Lord of the Rings_ trilogy and Norse mythology (perhaps through the Marvel Cinematic Universe) definitely found lots of things to enjoy about the story: the fight between love and power revolving around an all-powerful ring that is the source of conflict to whomever possesses it.

With such strong fantastical elements, one could expect a production that, along with its larger-than-normal orchestra, would conjure up a set that is worthy of a Hollywood blockbuster. For this production of _Das Rheingold_, directed by Brian Staufenbiel, Calgary Opera found innovative ways to tell the story in unconventional ways.

Strictly speaking, the set was rather minimalist. With an expanded orchestra taking up most of the space on the stage itself, the set comprised a bridge suspended above the orchestra for Wotan and his family, eliciting a sense of divine discourse. When the action leaves the heavens for the depths, projections changed to images that matched the locale – stalactites and stalagmites for the descent into Nibelheim, or currents and bubbles for the visit with the Rheinmaidens.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1715187586/CO_Rheingold_Justine_Ledoux_Juliana_Krajcovic_Yenny_Lee.jpg)
<figcaption>Justine Ledoux, Juliana Krajoĉoviĉ, and Yenny Lee as the Rheinmaidens in Das Rheingold, Calgary Opera, 2024. Photo: HarderLee Photography.</figcaption>
</figure>

The trio of Rheinmaidens – Juliana Krajočovič, Justine Ledoux and Yenny Lee – were positively liquid in their portrayals of Woglinde, Welgunde and Flosshilde, respectively. On this night, the chemistry and blend were first-rate, setting the tone for the night's performance. Each embodied a mischievous playfulness in their encounter with Alberich that sets the action of _Das Rheingold_ in motion. All three should be commended for their bright, spinning tone that sparkled throughout the auditorium.

Baritone Boaz Daniel was a standout performer as Alberich, the chief of the Nibelung race of dwarves and the main antagonist of _Das Rheingold_ and the whole of the _Ring_ Cycle. Daniel's piercing tone is blessed with a richness and authority that commanded attention every time he was on stage. The use of reverb to alter his voice when he cast a spell made Daniel's voice sound even more magical, echoing from every corner of the auditorium as he becomes invisible, or transforms into a dragon.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1715187768/CO_Rheingold_Boaz_Daniel.jpg)
<figcaption>Boaz Dnaiel as Alberich in Das Rheingold, Calgary Opera, 2024. Photo: HarderLee Photography.</figcaption>
</figure>

Bass-baritones Kenneth Kellogg and Guido Jentjens also loom largely in their roles of the giants Fafner and Fasolt, respectively. As the giants who built Valhalla for Wotan, they seize Freia, the goddess of love, youth and beauty, as payment for their handiwork. Only when Wotan settles the debt – which includes turning over the mythical ring at the centre of the conflict – is Freia returned to her family. It was interesting how technology was used to project images of the giants to the suspended bridge to interact with Wotan _et al_, while the audience was able to see Kellogg and Jentjens sing and perform so beautifully on a different part of the stage.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1715187585/CO_Rheingold_Kenneth_Kellogg_and_Guido_Jentjens.jpg)
<figcaption>Kenneth Kellogg and Guido Jentjens as the giants Fafner and Fasolt in Das Rheingold, Calgary Opera, 2024. Photo: HarderLee Photography.</figcaption>
</figure>

The production boasted a sparkling cast of supporting characters, each of whom making the most of limited stage time. In her mainstage debut with Calgary Opera, soprano Anna Pompeeva shined as Freia, capturing the character's sense of helplessness and desperation as the pawn between both Wotan and the giants. Her sister Fricka, played by mezzo-soprano Jill Grove, shimmered with warmth and authority befitting the goddess of marriage. The brother-gods Donner and Froh, played by baritone Copper Hoppenbrouwers and Elias Theocharidis of the McPhee Artist Development Program, each displayed poise and impressive vocal technique as the gods of thunder and spring, respectively; the tenor Theocharidis, in particular, impresses with a brightness in his tone that made his interpretation of Froh appealing to the ears. And tenor Gordon Gietz (formerly of Calgary) offered an impressive, nuanced portrayal of Mime, the long-suffering brother of Alberich. Gietz's clear grasp of the German language, combined with effortless vocal production, make him a fan favourite on this night.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1715187585/CO_Rheingold_Catherine_Daniel.jpg)
<figcaption>Catherine Daniel as Erda in Das Rheingold, Calgary Opera, 2024. Photo: HarderLee Photography.</figcaption>
</figure>

Special mention should be made for Catherine Daniel in her portrayal of Erda, the goddess of the earth. Daniel's vibrant voice poured out a divine, molten legato tone befitting a goddess. Her performance of the aria "Weiche, Wotan, Weiche!" was a true highlight of the evening; Daniel commanded authority with round, sumptuous tones that drew the audience into the story in a pivotal scene in which she warns Wotan about the all-powerful ring. I look forward to what she brings to the role of Fricka in Edmonton Opera's production of _Das Rheingold_ at the end of May.

On this night, the performance was anchored by three standout performances.

First, the Calgary Philharmonic Orchestra, led adeptly and expertly by Jonathan Brandini. With an expanded orchestra to support Wagner's writing, Brandini succeeded in making the orchestra an equal contributor to the action. At no point did the orchestra overpower the voices, allowing each vocalist to perform at their best. Special mention should be made of the stage blocking that allowed the voices to soar over the orchestra – singing from in front of or above the instrumentalists to ensure their sound carried through the auditorium. I especially enjoyed the expanded brass section that joined the orchestra on stage.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1715187585/CO_Rheingold_James_Rutherford.jpg)
<figcaption>James Rutherford as Wotan in Das Rheingold, Calgary Opera, 2024. Photo: HarderLee Photography.</figcaption>
</figure>

Second, the commanding performance of James Rutherford as Wotan. Rather than portray the king of the gods as someone who tends to get his way, Rutherford offers nuance and vocal colours that hint of vulnerability, which offers the character depth and dimension. His reliance on Loge to provide him with a solution has an air of desperation, while his leader-to-leader interaction with Alberich is positively regal. Rutherford handles Wagner's vocal writing with ease and booming authority.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1715187585/CO_Rheingold_Rodell_Rosel.jpg)
<figcaption>Rodell Rosel as Loge in Das Rheingold, Calgary Opera, 2024. Photo: HarderLee Photography.</figcaption>
</figure>

The true showstopper, however, was tenor Rodell Rosel as the scheming Loge. Portraying the demi-god of fire, Rosel lit up the stage with a virtuosic performance that inserted him into the centre of most of the action. Rosel's performance underscored how well the character disarms his opponent with undeniable charm, which the tenor backs up with some of the easiest and liquid singing among the cast. His efforts were met with thunderous applause at the end of the night.

With a minimalist cast and innovative ways to present a larger orchestra while maintaining optimal support for the vocalists, this production of _Das Rheingold_ was a divine way for this writer to be introduced to the magic of Wagner's epic storytelling.

## 2024-25 announced

Leading into the run of _Das Rheingold_, Calgary Opera announced its [2024-25 season](https://www.calgaryopera.com/2024-25).

- The season opens November 2, 6 & 8 with Mozart's _Don Giovanni_. Conducted by Jonathan Brandani and directed by Anna Theodosakis, the production stars Phillip Addis as Don Giovanni, and features Midori Marsh as Donna Anna, Aviva Fortunata as Donna Elvira, Guido Loconsolo as Leporello, Chuan Wang as Don Ottavio, and Neil Craighead singing the roles of both Masetto & the Commendatore.
- The company presents Donizetti's _Don Pasquale_ on February 1, 5 & 7, 2025. Starring John Fanning as Don Pasquale, with Lucia Cesaroni as Norina, John Tessier as Ernesto, and Phillip Addis as Doctor Malatesta. The show will be directed by Stefania Panighini and conducted by Jacques Lacombe.
- The company presents a double bill on April 5, 9 & 11, 2025, with productions of both Bartók's _Bluebeard's Castle_ and Puccini's _Gianni Schicchi_. The pairing of these operas, both of which premiered amidst the aftermath of World War One and the Spanish Flu pandemic, reflect the era's disillusionment and existential questioning. Both shows will be conducted by Jonathan Brandani, and directed by Alain Gauthier.

Tickets for the 2024-25 season are available at [calgaryopera.com](https://www.calgaryopera.com/2024-25).