+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2015-07-21T14:38:00-04:00"
lastmod = "2015-07-30T14:05:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1437527302596/noopera.jpg.jpg"
publishDate = "2015-07-22T07:00:00-04:00"
related_articles = ["articles/5-reasons-to-get-your-drama-fix-from-oratorio.md"]
short_description = "Before I got into opera, I dealt with a certain list of composers. J.S. Bach, Beethoven, Mozart, Haydn, Debussy, Chopin, Scriabin, Liszt - all these guys wrote some pretty fantastic music for solo piano. Then, I started working with chamber ensembles, and my composer pool expanded to Bartók, Brahms, Sarasate, Chaminade, Poulenc, Fauré, and Piazzola. I began looking at song repertoire with singers, so I found Hugo Wolf, and realized what the big deal was with Schubert and Schumann. "
slug = "but-why-didnt-they-write-opera"
title = "But, why didn&#039;t they write opera?"
+++

Before I got into opera, I dealt with a certain list of composers. J.S. Bach, Beethoven, Mozart, Haydn, Debussy, Chopin, Scriabin, Liszt - all these guys wrote some pretty fantastic music for solo piano. Then, I started working with chamber ensembles, and my composer pool expanded to Bartók, Brahms, Sarasate, Chaminade, Poulenc, Fauré, and Piazzola. I began looking at song repertoire with singers, so I found Hugo Wolf, and realized what the big deal was with Schubert and Schumann. Folks like Verdi and Wagner weren't really on my list at all until opera came into my life; for a while I thought that Richard Strauss was famous for simply loving the French horn (#shame).

My current pool has some significant overlap with my previous worlds of solo and chamber music: Mozart is ubiquitous, but there's more Handel and less Beethoven, more Verdi and less Scarlatti, and very little Liszt or Chopin (two notable exclusions for a pianist). I came across [this article](http://www.theguardian.com/music/2015/jul/14/mendelssohn-midsummer-nights-dream-overture-garsington-opera) in *The Guardian* about Mendelssohn's famous overture to *A Midsummer Night's Dream*, and how it's odd that he never followed up with an opera. There's evidence that Mendelssohn and his sister Fanny Hensel were both outlining sketches for an opera based on the *Nibelungenlied*, but no final products from either composer.

The article got me to thinking, just the same. Like the Mendelssohns and plenty of the other composers above, these guys are seriously great at writing music, and some of them prove to be masters of writing for the voice. So, why didn't opera appeal to them? Without years of research as an option, I'll turn to some educated speculation: here are four notable composers who avoided opera:

### 1. Mahler

Really, why no opera? He obviously loved the voice, chose and set texts carefully, and he certainly had the genes for the grandiose. Mahler conducted lots of opera in Vienna and New York City; his inspiration may have been constantly fed, but perhaps his conducting schedule stretched him too thinly to really focus on a full-scale opera. Then again, it's not like his symphonies are simple little ditties.

Mahler composed in the summers, and I've always thought that image went perfectly with my sense of existentialism in his music, free from definitive forms and full of big questions. On the one hand, this cerebral/dreamy mix is great for opera; on the other, perhaps the idea of a plot and parameters set by a libretto were too confining for Mahler's taste. If we were able to ask him today, there's probably a 50% chance that he'd scoff and ask us if his 8th Symphony and *Das Lied von der Erde* weren't enough.

<figure data-type="video">
<iframe width="854" height="510" src="https://www.youtube.com/embed/NSYEOLwVfU8" frameborder="0" allowfullscreen></iframe>
<figcaption>Leonard Bernstein conducts Mahler's 8th Symphony with the Vienna Philharmonic Orchestra.</figcaption>
</figure>


Bonus: this [*Operavore* article](http://www.wqxr.org/#!/story/135570-mahler-opera-not-such-stretch-actually/) on how Mahler may have inspired *Death in Venice*.

### 2. Bach

Was  J.S. too busy writing weekly cantatas? It's probably a fair factor. Maybe he took the sacred music thing a bit too seriously, seeing opera as something shallow and of the devil? That's a stretch, since his sacred arias have all the stuff of opera's heightened expression and word painting; he absolutely appreciated what the voice could do with text, even if he forgets to give singers a place to breathe (*cough, Beethoven, cough*). 

My gut says it came largely down to time and funding. Brand new music for every Sunday service is no small task, and the patrons with whom Bach worked would have been connected to the church, not the theatre.

And yet:

<figure data-type="video">
<iframe width="854" height="510" src="https://www.youtube.com/embed/7F7TVM8m95Y" frameborder="0" allowfullscreen></iframe>
<figcaption>Harry Bicket conducts Bach's B minor Mass at the BBC Proms in 2012.</figcaption>
</figure>

### 3. Chopin

Chopin, writer of Nocturnes, Mazurkas, Polonaises, the odd sonata: without a doubt, he loved singing. Chopin was a lover of the *bel canto* style of singing; he was was friends with Bellini, and close with Pauline Viardot. He did write [a few songs](https://en.wikipedia.org/wiki/List_of_compositions_by_Fr%C3%A9d%C3%A9ric_Chopin_by_genre#Voice_and_piano) for voice and piano, all set to [Polish texts](https://www.youtube.com/watch?v=7iYqa49LJvY); but he never even attempted a full-scale opera. Chopin always struck me as a soft-spoken guy, certainly more of a wallflower than Liszt. Maybe he just didn't have the *chutzpah* to write an opera, and face a potentially intimidating opera scene.

Somewhat ironically, there's an opera named [*Chopin*](https://en.wikipedia.org/wiki/Chopin_(opera), written by Italian composer Giacomo Orefice (the score is available via [IMSLP](http://imslp.org/wiki/Chopin_(Orefice,_Giacomo)).

Here's one of my favourite Chopin Nocturnes, recorded by Rubinstein:

<figure data-type="video">
<iframe width="854" height="510" src="https://www.youtube.com/embed/WJ8RVjm49hE" frameborder="0" allowfullscreen></iframe>
</figure>

### 4. Brahms

My buddy Brahms just didn't seem to *like* opera that much. He preferred "absolute music" to anything connected with a specific text or story; he was the foil to Wagner and R. Strauss, who were becoming opera rock stars and stretching the limits of storytelling. Brahms was an overthinker, I believe; you can almost *see* it on his scores. No *bel canto* ornamentation, but measured, moderated ways of enhancing a melody. His piano music doesn't flourish the way Liszt's do, but I find the reward between Brahms and Liszt is a little like the Tortoise and the Hare (Brahms is the Hare).

Brahms, like Chopin, did write some deliciously beautiful songs fot voice and piano; if you ask me, the best of Brahms' vocalism is in his instrumental music. This is Itzhak Perlman and Daniel Barenboim playing the Third Violin Sonata, 2nd movement. It's no opera, but it certainly sings:

<figure data-type="video">
<iframe width="854" height="510" src="https://www.youtube.com/embed/-L5nSwAND3Y" frameborder="0" allowfullscreen></iframe>
</figure>



>Who have I missed on this list? Let us know in the comments below!
