+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2015-04-10T23:20:00-04:00"
lastmod = "2015-04-10T23:20:00-04:00"
preamble = "<p>\n\t<em>Tenor and guitarist </em><a href=\"http://www.budroach.com/index.html\" target=\"_blank\">Bud Roach</a><em> is the founder of </em><a href=\"http://capellaintima.com/index.html\" target=\"_blank\">Capella Intima</a><em>, an ensemble of singers and instrumentalists that has \"carved out a niche for itself in the Toronto early music scene.\" Known for their work with 17th century Italian Baroque music, Capella Intima is joining forces with the</em><a href=\"http://www.galleryplayers.ca/\" target=\"_blank\">Gallery Players of Niagara</a><em> for their next performance on March 6th at the Trinity-St. Paul Centre, which includes Henry Purcell's </em><a href=\"http://capellaintima.com/index.html\" target=\"_blank\"><em>Dido and Aeneas</em></a><em>. Bud Roach has a huge passion for what he does, and he was kind enough to answer a few of my questions about his work in Early Music (spoiler: he's in it for the foul language).</em>\n</p>"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428722332082/BudRoach.jpg.jpg"
publishDate = "2015-03-03T09:20:00-05:00"
short_description = "Tenor and guitarist Bud Roach is the founder of Capella Intima, an ensemble of singers and instrumentalists that has “carved out a niche for itself in the Toronto early music scene.” Known for their work with 17th century Italian Baroque music, Capella Intima is joining forces with the Gallery Players of Niagara for their next performance on March 6th at the Trinity-St. Paul Centre, which includes Henry Purcell’s Dido and Aeneas. Bud Roach has a huge passion for what he does, and he was kind enough to answer a few of my questions about his work in Early Music (spoiler: he’s in it for the foul language)."
slug = "bud-roach-on-capella-intima"
title = "Bud Roach, on Capella Intima"
+++

<h2>1. Where did your passion for Early Music come from?</h2>
<p>
	I had a real epiphany when I participated in the <a href="http://www.tafelmusik.org/education/artist-training/tafelmusik-baroque-summer-institute" target="_blank">Tafelmusik Baroque Summer Institute</a>. My musical training in school was on the oboe, and I worked with orchestras, both Canadian and American, for a number of years before I started singing. So back in 2006, when I was just starting out as a tenor, the world of Carissimi and Monteverdi was all very new. My voice seemed to be suited to composers like Bach and Handel, but the earlier my exploration went, the more fascinated I was by the turn of the 17th century, and how the groundwork was laid for what we now think of as the principals of Western music. That basic idea of conveying text in an emotional, meaningful way for an audience is something I find incredibly appealing – and challenging! And the performance tradition of this "New Music", as Caccini labelled it, was self-accompanied, which has been the most satisfying part of my Early Music inquiry. Singing to my own accompaniment on the Baroque guitar is the furthest musical point from playing a Mahler symphony or Strauss tone poem in an orchestra. But it's endlessly interesting to me now, because of this whole new world of the beginnings of tonality. It's as though my formal education as an oboist excluded some of the most exciting parts of our Western musical heritage – almost like an English major whose reading list starts a full century after Shakespeare!
</p>
<h2>2. How have singing and guitar become balanced parts of your work as a musician?</h2>
<p>
	I don't think of myself as a "real" guitarist (and most guitarists would agree!). I'm a singer specializing in the performance traditions of the early Baroque, and that means learning an instrument well enough to provide my own accompaniment. Of course it's possible to sing in a stylistically compelling way without strumming or plucking at the same time, as almost all singers do, but I've found that the best way to figure out how to make this music as freely expressive as the composers clearly intended is to work it all out as a solo performance. And now that I've done this for a little while, with a couple of recordings and many solo concerts under my belt, I have a much clearer sense of how to approach any repertoire, whether it be sacred music, opera, solo, or ensemble. As far as my work as a musician, I can certainly attest to the fact that seventeenth-century <a href="http://www.maestros-of-the-guitar.com/alfabeto.html" target="_blank">alfabeto</a> arias are NOT paying the bills! However, my efforts have been noticed internationally, and the feedback has been universally encouraging, so I will continue down this path, and see where it takes me.
</p>
<h2>3. You mention that audiences can get "context" from performances of 17th century music that "has only come to light in recent years" with a revival of Early Music interest. Can you elaborate?</h2>
<p>
	This quote from the <a href="http://capellaintima.com/" target="_blank">Capella Intima website</a> actually refers to the use of readings in some of our concerts. Probably the best example of this would be a programme of music by Benedictine nuns from Milan ("Celestial Sirens") that we have revived several times. The work of composers like <a href="http://en.wikipedia.org/wiki/Chiara_Margarita_Cozzolani" target="_blank">Maria Cozzolani</a> has only re-emerged in the last decade or so, thanks mainly to the efforts of one particular scholar. Cozzolani composed with a very unique voice. She was published, and her music was widely known. Today most concertgoers do not even recognize her name, let alone understand how remarkable her accomplishments were. Incorporating readings from the period can really help to convey to an audience the cultural, and specifically musical, climate at the time.
</p>
<p>
	The 17th century was a period of great change in musical styles, but we hear so little of it in concert that it can be difficult to really get a sense of how it all fits together. Composers like Vivaldi did not just appear out of nowhere. He inherited much of his harmonic and rhythmic language from the composers of generations before. What Capella Intima attempts to do is fill in some of these gaps, outside of what is thought of as the "standard" repertoire.
</p>
<p>
	<br>
</p>
<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428722379012/CapellaIntimaHeader.jpg"><img data-resize-src="http://lh3.googleusercontent.com/XbEwfVrrse9ZlMVZNNeLkxpH3CMhKGtZ69Po9Z8KAmTae7SN0VU2hxuBogssYGoEZTUoPC34AWyxMz_urRLBB1HRmsB8CQ" src="http://lh3.googleusercontent.com/XbEwfVrrse9ZlMVZNNeLkxpH3CMhKGtZ69Po9Z8KAmTae7SN0VU2hxuBogssYGoEZTUoPC34AWyxMz_urRLBB1HRmsB8CQ=s1200"></a></figure>
<h2>4. How do you go about choosing a programme for Capella Intima?</h2>
<p>
	Capella Intima programmes always start with a trip to the library. Often those visits spark an interest in a specific direction that requires some online hunting, which seems to become easier every month, since people are sharing scores, and libraries are digitizing their collections. One of my favourite places to visit (both online and in person!) is the <a href="http://www.museomusicabologna.it/biblioteca.htm" target="_blank">Biblioteca della musica</a> in Bologna. If you show up at this library prepared, knowing what it is you need, and take no breaks at all, it is possible to leave at the end of the day having taken about 2,000 photographs of scores! And the people there are so kind and helpful. In virtually every book I've seen that deals with the music of the Italian Baroque, the authors thank the staff of this library for their generosity, and it makes me smile when I think of these librarians, and this very special place.
</p>
<p>
	From that point, I just look over the part-books (most works were never published in full score, so you can only see the soprano part in one book, the continuo line in another, and so on) and see what jumps off of the page. Sometimes it's a melodic motif that I think is interesting, or a text that grabs my attention. And then…lots of time at the computer, creating a clean edition. Then I usually have a few visits with my friend Gabriele Erasmi, who does all of the Italian and Latin translations. He, too, has been extremely generous, and his guidance continues to be an invaluable part of Capella Intima's development. A core principal of the ensemble is to present the unfamiliar. It's a completely different concert experience for an audience to hear a piece of music for the first time, and this sort of presentation really interests me. It does make our concerts a tougher sell than programmes of Bach or Handel, but the reward for doing all of the organization and administration for Capella Intima is the ability to choose the repertoire I really want to do. Putting together unique programmes with great people is a very musically satisfying experience!
</p>
<h2>5. What do you look forward to about your upcoming <em>Dido and Aeneas</em>? You mention this concert is a "departure"; how so?</h2>
<p>
	Well it is most definitely new ground for us. For a start, this is the very first time that Capella Intima has presented a concert in English! And secondly, it will be our first programme where most of the audience is familiar with the main work. When it comes to <em>Dido and Aeneas</em>, this is hardly a Toronto premiere! And yet, this has been a very happy challenge to put together. The first time that we know <em>Dido</em> was done in concert was not, as you might think, in these current days of no time and little money. It was actually performed in concert in 1787, and this is the sort of performance that we are trying to recreate. At the same time as popular concerts featuring <a href="http://en.wikipedia.org/wiki/Concerts_of_Antient_Music" target="_blank">"Antient Music"</a> were being presented, the taverns were full of music provided by Singing Clubs. Catches, rounds, and glees were all the rage, so our first half consists of some of Purcell's more popular airs, interspersed with interesting bits from the period of this first, concert performance of <em>Dido and Aeneas</em>. Most of these short pieces are on a "musical" theme – and most of them unknown – with one notable exception that includes a lot of foul language. So everyone should come out on Friday, even if it's just for the swearing!
</p>
