+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-12-22T16:14:00-05:00"
lastmod = "2016-12-29T13:01:00-05:00"
preamble = "In 2017, [The Bronx Opera Company](/scene/companies/bronx-opera/) celebrates its 50th season. Its **50th season**! Other than [The Metropolitan Opera](/scene/companies/the-metropolitan-opera/), Bronx Opera is the only New York-based opera company to produce work each year since 1967. To celebrate 50 years of putting opera onstage, Bronx Opera offers up a season that nods to Shakespeare's infamous Sir John Falstaff, including Ralph Vaughan Williams' [*Sir John in Love*](http://bronxopera.org/2017-season/) (January 14-22) and Verdi's beloved comedy, [*Falstaff*](http://bronxopera.org/2017-season/) (April 29-May 7).\n\nWe spoke with Artistic Director Michael Spierman and Managing Director Benjamin Spierman about Bronx Opera's longevity, and why Sir John is the right man to help celebrate the company's major milestone."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1482441578505/2016-12-22---Ben-Spierman.jpg.jpg"
primary_image_credit = "Benjamin Spierman, Managing Director of Bronx Opera."
publishDate = "2016-12-29T11:46:00-05:00"
related_articles = ["articles/spotlight-on-claire-kuttler.md","articles/talking-with-singers-karolina-pilou.md","articles/interviewing-the-greats-virginia-zeani.md","articles/dont-miss-the-2nd-annual-new-york-opera-fest.md"]
related_companies = ["scene/companies/bronx-opera.md"]
short_description = "&quot;It took our company a number of seasons, since its inception in 1967, to even realize that there was a possibility for its longevity. When this rather startling thought took hold, we had already formulated our basic missions: to give talented operatic artists an opportunity for meaningful experience and exposure (57 to date have gone to the Met), to nurture new audiences for opera...to expose outstanding and rarely performed works to audiences each winter and to proudly represent the quality of life in our home borough.&quot;"
slug = "bronx-opera-50-years-counting"
title = "Bronx Opera: 50 years &amp; counting"
+++

## Why has Bronx Opera gone with a *Falstaff*-themed line-up for 2017, the company's 50th anniversary season?
 
**Benjamin Spierman**: It's actually a series of reasons. BxO has produced three of Vaughan Williams' operas (*Hugh the Drover* and *The Poisoned Kiss* in addition to *Sir John in Love*), so his operatic output has been very important to our company. For our 50th season, it seemed really appropriate to bring back *Sir John*, especially since we haven't produced it since 1988. Given that idea, *Falstaff* seemed to be the ideal "other" production. It enables us to substantially use the same scenery, it enables us to think in somewhat similar ways about the two productions, and, most importantly, it's a masterpiece. Doing both in the same season (and in the same theatres) creates a fascinating comparison. Looking at how two masters (three, when you include Boito) create great stage works out of the same story is terrific for people with an insider’s interest in music drama. And, both *Sir John* and *Falstaff* are so good that coming to both won't be painful to anyone :).

**Michael Spierman**: Many great composers have viewed the Falstaff story from the unique perspective of their individual geniuses.  This special season gives our audiences an opportunity to experience two very different, and at the same time first-rate, examinations of this topic.  The result allows audiences an interesting perspective and, at the same time, makes the point that no work of art is definitive on a given subject, only compelling in its own right.  

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1483032525742/2016-12-29---Michael-Spierman-with-Ralph-Vaughan-Williams-widow-.jpg.jpg)
<figcaption>Michael Spierman with Ursula Vaughan Williams, widow of Ralph Vaughan Williams.</figcaption>
</figure>

## How has the company's mission evolved over 50 season, and how has it maintained that mission over changing artistic climates?

**Michael**: It took our company a number of seasons, since its inception in 1967, to even realize that there was a possibility for its longevity.  When this rather startling thought took hold, we had already formulated our basic missions: to give talented operatic artists an opportunity for meaningful experience and exposure (57 to date have gone to the Met), to nurture new audiences for opera by presenting all operas in English, having modest ticket prices, small theatres and an Arts in Education Program which has introduced our art to thousands of Bronx youngsters ("I thought opera sucked, no more" one wrote to us), to expose outstanding and rarely performed works to audiences each winter and to proudly represent the quality of life in our home borough.  We have maintained these missions over the decades even as demographics have changed.

**Benjamin**: The mission has always been focused in two areas: service to the opera professionals in the NYC area, and service to The Bronx. The most major evolution has been the increased ways in which we serve our borough. When we were celebrating our 25th Season, we’d never introduced a child directly to opera, developed a chorus at a senior center, helped a school with its after-school musical, or taught drama, music, dance or speech at a community center. In the last 25 years we have done all those things, and will continue to do as much of all of that as we can. We still serve operatic artists as much as we always have, but now we bring those artists into our community in ways that we never did in our first 25 years.
 
## Why do you think Bronx Opera has been able to lead such a long legacy?
 
**Benjamin**: Fiscal responsibility combined with a good product when we present. 

**Michael**: Our long legacy is based on consistent quality, careful organization, respect for our participants and a group of missions, detailed above, that can adapt to changing times.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1483032617918/2016-12-29---Cinderella-BOC.jpg.jpg)
<figcaption>A scene from *Cinderella* at Bronx Opera Company.</figcaption>
</figure>
 
## What do you like the most about Sir John Falstaff?
 
**Michael**: The Falstaff character is a multifarious one, at times loveable and at times to be despised.  This combination is similar to the life experiences of so many of us… imperfect and complex.  It is fascinating to sense how the above is viewed by different creative geniuses.  

**Benjamin**: Most of all, I like the philosophical way in which he handles his shaming. He did something wrong, he gets found out, he takes everyone’s shots, apologizes, and moves on. I think that how we handle looking bad says a lot about each of us, and I admire Falstaff for how he behaves once his plans fall apart. And…he has a great sense of humor to balance out his pride.

>For full details and ticket information about The Bronx Opera's 50th season, [click right here.](http://bronxopera.org/2017-season/)
