+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2015-05-18T11:48:00-04:00"
lastmod = "2015-05-23T23:01:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1432405067979/ReneeLettermanSquare.jpg.jpg"
publishDate = "2015-05-23T14:18:00-04:00"
related_articles = ["articles/netflix-why-not-opera.md","articles/roundup2014.md"]
related_people = ["scene/people/renee-fleming.md"]
short_description = "In an earlier post, I was hunting for operatic tributes to David Letterman as his retirement quickly approaches. Few and far between as they may be, there seems to have been a definite &quot;Golden Age&quot; of opera on late-night television. From the 1950s to the 80s, folks like Plácido Domingo, Marilyn Horne, Maria Callas, Leontyne Price, Richard Tucker, Martina Arroyo, and Beverly Sills made appearances on late-night shows with Johnny Carson, Ed Sullivan, and Merv Griffin."
slug = "bring-back-opera-on-latenight-tv"
title = "Bring back opera on late-night TV"
+++

In an earlier post, I was hunting for operatic tributes to David Letterman as his retirement quickly approaches. Few and far between as they may be, there seems to have been a definite "Golden Age" of opera on late-night television. From the 1950s to the 80s, folks like Plácido Domingo, Marilyn Horne, Maria Callas, Leontyne Price, Richard Tucker, Martina Arroyo, and Beverly Sills made appearances on late-night shows with Johnny Carson, Ed Sullivan, and Merv Griffin. Today's late-night hosts don't chat as much with opera singers, save for Kristin Chenoweth on Conan, Renée Fleming singing for Letterman's Top 10, Josh Groban singing Kanye West tweets on Jimmy Kimmel. Oh, and [Nathan Gunn talking Papageno with Stephen Colbert](http://www.ovguide.com/tv_episode/the-colbert-report-season-4-episode-61-nathan-gunn-365962).

<figure data-type="video">
<iframe width="854" height="510" src="https://www.youtube.com/embed/kZiGk5mTIHM" frameborder="0" allowfullscreen></iframe>
</figure>

Why has late-night opera taken a nosedive? Is it because publicists for opera singers can't get them a TV spot? Are talk shows not a priority for getting a singer's name out there? Perhaps the real focus for publicicists in today's industry is on showing singers to heads of companies, rather than advertising to the general public; the former certainly helps pay the bills, while the latter is more of a big picture gesture.

It's sort of a chicken-and-egg thing, too. One one hand, you could argue that the film and television industry spent more energy making sure opera's grand history was recorded than recording it in the present day. Big stars, a connection to the Metropolitan Opera, these things do one of two things. If you were born closer to the beginning of the 20th century, opera on TV can capture part of your culture, your personal nostalgia. If you're born after 1950, and were more likely to get your culture and media from TV, seeing an opera singer sing old music in Italian almost highlights the museum-like nature of opera singing without context.

<figure data-type="video">
<iframe width="854" height="510" src="https://www.youtube.com/embed/xXE0DAPOfVI?list=PL5dRY_RcMeenoViJjsZzQ_K842DpI7pPP" frameborder="0" allowfullscreen></iframe>
</figure>

To be fair, during these decades the production of new opera had slowed and received less funding. There simply wasn't the hype or notoriety surrounding contemporary opera singers; the fame of Pavarotti and Domingo was much rarer. For TV talk shows, this would have been a decidedly poor use of air time.

Think what it could do for the public's perception of opera and opera singers, to have them as a small but steady representation of the industry today. I suppose there is some gamble, for a TV network, to have a potentially "boring" guest on their show. I'd entrust that gamble with someone like Joyce DiDonato, who could show the non-savvy public that the people are interesting and entertaining, and most importantly, that there is a tangible point of entry into the art form for the public.

<figure data-type="video">
<iframe width="854" height="510" src="https://www.youtube.com/embed/G7V7kX8n3xs" frameborder="0" allowfullscreen></iframe>
</figure>

In the meantime, if you're itching to catch some of these "Golden Years" interviews, Johnny Carson is where it's at. [Plácido Domingo](https://www.youtube.com/watch?v=VaC3YhvaDDs) and [Marilyn Horne](https://www.youtube.com/watch?v=2f4yWsmKIVE) have both paid him a visit, as well as my personal favourite, Martina Arroyo.

<figure data-type="video">
<iframe width="854" height="510" src="https://www.youtube.com/embed/y3bY7qMTCsU" frameborder="0" allowfullscreen></iframe>
</figure>

Plus, it's hard to find for free online, but you can [purchase this huge collection, *Great Moments in Opera*](http://www.edsullivan.com/products/great-moments-in-opera/), featuring a seriously impressive list of opera stars who sang on Ed Sullivan. We're talking Maria Callas and Franco Corelli, impressive.

Maybe it's a charitable, plant-tress-under-which-you'll-never-sit-type of thing to say that opera singers (and their publicists) should look to mainstream, still-popular television outlets. Maybe they won't sell a meaningful amount of tickets to a particular show, but opera singers could become less of a rare bird in the general media. Eventually, we might even evolve beyond asking questions like "How can you sing so high?" Well, maybe not.
