+++
author = ["authors/arturo-fernandez.md"]
categories = "Review"
date = 2023-05-19T03:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1684608958/sqElixir_BosOpCollab042523-0926.jpg"
primary_image_credit = "Boston Opera Collaborative's production of L'elisir d'amore, 2023. Photo: Dan Busler Photography."
related_articles = ["articles/lighter-fare-vancouver-operas-the-elixir-of-love.md", "articles/aria-guides-come-paride-vezzoso.md", "articles/aria-guides-una-furtiva-lagrima.md"]
related_companies = ["scene/companies/boston-opera-collaborative.md"]
related_people = []
short_description = "Unmemorable tunes, a certain lack of dramatic forethought, and far too prolific for his own good, I can really only enjoy Donizetti in small bursts."
slug = "bright-frothy-fun-in-box-lelisir-damore"
title = "Bright, frothy fun in BOC L'elisir d'amore"
youtube_url = ""

+++
I have mentioned in past Schmopera reviews that I am not a fan of _bel canto_ operas as a movement. Until now, however, I have never really had to talk about the operas of Donizetti. I have considered myself lucky for this, for the simple fact that I consider Donizetti to be the face of everything I find wretched about the _bel canto_ movement. Unmemorable tunes, a certain lack of dramatic forethought, and far too prolific for his own good, I can really only enjoy Donizetti in small bursts.

[_L'elisir d'amore_](https://www.bocopera.org/elixir), then, is an interesting creature, because it is one of three Donizetti operas that I find palatable, and even then there are still asterisks over a vast chunk of it. I find most of the music fairly forgettable, and its liberal use of all the _bel canto_ musical clichés does more to illustrate all of my issues with the genre than even the sub-par libretti usually used here. But on the other hand, it is one of Donizetti's most dramatically in-tune scores: it is the only opera of his other than _Lucia di Lammermoor_ in which I find the music in any position to propel the action forward, and it is concise in a way most bel canto operas aren't, and the numbers that aren't utterly forgettable are genuinely good numbers. In other words, _L'elisir_ is one of only a tiny handful of Donizetti operas that I feel actually earns a place in the operatic repertory, and even then I'm not necessarily the biggest fan of it.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1684608958/Elixir_BosOpCollab042523-0790.jpg){{% /md %}}

<figcaption>Boston Opera Collaborative's production of L'elisir d'amore, 2023. Photo: Dan Busler Photography.</figcaption>
</figure>

Getting me along for the ride, then, requires the production company to really find exactly the right notes to hit. Enter [Boston Opera Collaborative](/scene/companies/boston-opera-collaborative/), which has handled productions of classics in the repertory with great insight before, and which definitely scored a home run with this production. As with most productions, this _Elisir_ was updated to an ambiguously modern brewery bar, which makes sense with setting it in the beer hall at The Substation at Roslindale. Dulcamara literally pours beers to make his false elixir, Nemorino is set up as kind of an employee of Adina's, and the liquor flowed freely even for the audience.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1684608958/Elixir_BosOpCollab042523-0915.jpg){{% /md %}}

<figcaption>Boston Opera Collaborative's production of L'elisir d'amore, 2023. Photo: Dan Busler Photography.</figcaption>
</figure>

But the production absolutely sparkled, thanks to incredible stage direction from director Alyssa Weathersby. From the moment conductor Ken Yanasigawa came onstage to finish setting the chairs to reveal his baton sitting in one of them, and then the subsequent bit with the audience he had after the fact (well, more specifically, me, actually), I was absolutely laughing my behind off through the entirety of the performance. There was a lot of stagecraft that was thrown throughout the beer hall, and while some of the blocking did feel like it was more towards the front of the house than to the side row that I ultimately sat in, it was still bubbly and hilarious stage work, from when the four-person chorus threw popcorn at Belcore during his very first aria in the show; to Dulcamara breaking out into the Gangnam Style dance in the wedding banquet that opens the second act; to the pause as Nemorino waits for Dulcamara to "brew”"the elixir; to even Nemorino softening his volume and then roaring back to Dulcamara trying to pull away later in that same moment.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1684608958/Elixir_BosOpCollab042523-0828.jpg){{% /md %}}

<figcaption>Boston Opera Collaborative's production of L'elisir d'amore, 2023. Photo: Dan Busler Photography.</figcaption>
</figure>

There were lots of funny little stage moments here, and what helped these along was that this _L'elisir_ was perfectly cast in every way imaginable. The ever-reliable Junhan Choi was with us once again as Belcore in this production, and to absolutely nobody's surprise he knocked it out of the park in just about every way imaginable. He played Belcore with just a bit more menace than usual, but the effect still remained as pompously enjoyable as always. Sarah Joyce Cooper made for a wonderfully coquettish Adina, and she made the undoubtedly difficult vocal writing sound insanely easy throughout the whole run. Then there was David Rivera Bozón as Nemorino: I felt he took a little bit to warm to his character, but once he did there was an incredible sincerity of intention he brought to the character, and he had incredible chemistry with Cooper; and by the end it was easy to see what Adina sees in him. But of course, Jorgeandrés Camargo absolutely stole the show as Dulcamara: here is a man with an impeccable sense of comic timing, who has incredible acting chops, and probably the most sprightly, agile bass voice I've heard in a long time. He was absolutely a joy to watch, and the second he came onstage was when the whole production really started to come alive.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1684608958/Elixir_BosOpCollab042523-0888.jpg){{% /md %}}

<figcaption>Boston Opera Collaborative's production of L'elisir d'amore, 2023. Photo: Dan Busler Photography.</figcaption>
</figure>

Both the direction and the singer-actors were strong enough that, for just a moment, I was able to mostly forget a lot of my issues with Donizetti as an opera composer and just enjoy the antics happening onstage. For sure, _L'elisir_ is still not an opera I actively seek out most of the time, but as I have had to say recently in other spheres, a great performance can uplift a mediocre piece, and by God did this production lift up its source material. The result was a very fun time, and when dealing with a piece I'm not as fond of, what more can one ask for?