+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-01-12T15:56:00+00:00"
lastmod = "2016-05-22T23:10:00+01:00"
preamble = "This summer, Westben Arts Festival Theatre is presenting the premiere of Brian Finley's new opera, *The Pencil Salesman*. Finley is a pianist and composer, and he's also the Artistic and Managing Director of the Westben Theatre. *The Pencil Salesman*, based on an idea by Agnes M. Herzberg, will be directed by [Michael Mori](/scene/people/michael-mori/), Artistic Director of [Tapestry Opera](/scene/companies/tapestry-opera/), and the cast of singers includes John Fanning, Virginia Hatfield, Alexander Dobson, and Donna Bennett. \n\nWe spoke with Finley about *The Pencil Salesman*, the story of a man who struggles \"to find meaningful human connection amidst a world distracted by and obsessed with technological advancement.\""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1452620143015/2016-01-12---PencilSalesman.jpg.jpg"
publishDate = "2016-01-13T14:00:00+00:00"
related_articles = ["articles/john-fanning-on-the-pencil-salesman.md"]
related_companies = ["scene/companies/westben-arts-festival-theatre.md"]
related_people = ["scene/people/john-fanning.md","scene/people/virginia-hatfield.md","scene/people/michael-mori.md","scene/people/alexander-dobson.md"]
short_description = "This summer, Westben Arts Festival Theatre is presenting the premiere of Brian Finley&#039;s new opera, The Pencil Salesman. Finley is a pianist and composer, and he&#039;s also the Artistic and Managing Director of the Westben Theatre. The Pencil Salesman will be directed by Michael Mori, Artistic Director of Tapestry Opera, and the cast of singers includes John Fanning, Virginia Hatfield, Alexander Dobson, and Donna Bennett."
slug = "brian-finleys-the-pencil-salesman"
title = "Brian Finley&#039;s The Pencil Salesman"
+++

## What does *The Pencil Salesman* have to say about change, and how people react to it?

Change. On the one hand, I like the way things are, and I can be incredibly slow to change anything (I’ve got the t-shirts to prove it!).  Yet change can also be extremely invigorating, fostering growth through the unleashing of potential and new perspectives. All this makes for a wonderful clash of dramatic possibilities.

In *The Pencil Salesman*, change is everywhere: its potential, its threat and its inevitability. Confronted by an ever-changing world, Boris Ball takes refuge in the only place he can understand and control: the past. The patriarch of a family of inventors, he has chosen to stop his world at his favourite moment: when his wife Rose was still alive, and when he was revered as the ingenious inventor of the Personal Touch ™ Typewriter.

Boris refuses to accept or acknowledge the growing fascination of the technologically obsessed world swirling around him. In particular, he is puzzled by his own son Edward’s bizarre fascination with new technology and he cannot believe that Edward’s own invention – a computer keyboard – can actually surpass his own creation. As Edward struggles desperately to prove himself to his father, Boris digs in even deeper. 

An exchange of ill-conceived birthday gifts brings true feelings to the fore. The result is a total family breakdown; all communication disintegrates. Boris locks himself away with his wife and his typewriter, ignoring the ensuing alienation, redundancy and loneliness that reverberates through the disintegrated family. Most poignantly, he is totally unaware of his granddaughter Violet, who, as the unhappy metaphor for the future of this family, is teetering dangerously on an emotional abyss. 

It is ultimately the Pencil Salesman – the seller of simplicity – who supplies the way for granddaughter and grandfather to connect, and in so doing, helping Boris let go of his beloved past to embrace a new future.  

Each character in *The Pencil Salesman* personifies a unique aspect of change.  Boris resists it adamantly. Edward craves it. Boris’s wife Rose is tired of it while his brother Aaron tries desperately to ride its ebbs and flows, relying on his wife Flo to keep him in the know. Edward’s wife Daisy tries to help everyone else understand it, while her daughter Violet tries to make sense out of it all.  Around this, the Pencil Salesman just keeps it simple! 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1452617233689/2016-01-12---Brian-Finley.jpg.jpg)<figcaption>Brian Finley, composer and Westben Theatre Artistic & Managing Director.</figcaption>
</figure>

## What drew you to this story, and why did you think it would make a good opera?

*The Pencil Salesman* is ultimately about human connection. Throughout history, humans have been obsessed with finding easier and more effective ways to connect. In doing so, it is truly astounding to consider what we have created, from cave drawings to language and writing to smartphones and the internet. But progress has had a price. 

This story grew out of my fascination with the cost of advancement in human terms. How do we find meaningful human connection amidst a world distracted by and obsessed with technological advancement? What happens when the things we create to help us connect actually do the opposite? As an anachronistic yet timeless foundation, the Pencil Salesman sells communication through his simple tool: the pencil, or simplicity in an unnecessarily confused world. At first he is totally ignored. But then…? And, as the story ultimately asks, is it really that simple? 

As the story is original, my intent was to make it a great opera story from the very beginning. In addition to a classical approach of involving strong characters in a universal theme, it was the music – wordless Truth – that was at the very core of the conception. Opera happens when music (in particular, the human voice) takes a story and gives it wings, lifting it up to a realm to which it could never go with words alone.  For me, it is the ultimate art form of human expression and therefore, one of the most powerful methods of communication. What better form to use to explore a story about connecting?  

## Whom do you think this story is for?

The story is for anyone who has ever tried to connect with another human being. 

Using the technology of communication as a foil, it really deals with the connection between people, and the resultant impact (or impasse). Differences between the generational approach to the topic interested me greatly, so virtually all generations are represented in the opera from hand-held device-carrying youngsters to smartphone-toting teenagers, phone-obsessed adults, newcomers to computers, computer whizzes, typewriter afficionados and even letter-writers. (And pencil users, of course!)

Almost anyone can see themselves or someone they know in one of the characters, and everyone will be able to understand the alienation, redundancy and loneliness. 

Certainly, everybody will enjoy the fun! In short, *The Pencil Salesman* is a very human story about trying to hang on to old ways when bombarded by new ideas; connecting is really as simple as letting go.

>To get a taste of the opera, and meet the creative team, check out Westben Theatre's preview of *The Pencil Salesman*:

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/bmgkK6cMaXY" frameborder="0" allowfullscreen></iframe>
</figure>
