+++
author = ["authors/erik-flaten.md"]
categories = "Review"
date = "2018-09-22T14:00:00-04:00"
lastmod = "2018-10-03T13:54:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1537638374029/sqLucia4.jpg.jpg"
publishDate = "2018-09-22T14:00:00-04:00"
related_articles = ["articles/sky-on-swings-a-mustsee-of-o18.md","articles/a-stunning-premiere-elizabeth-cree.md","articles/racette-an-unmissable-elle-in-o18s-ne-quittez-pas.md","articles/the-astonishing-product-glass-handel-at-o18.md"]
related_companies = ["scene/companies/opera-philadelphia.md"]
related_people = ["scene/people/brenda-rae.md","scene/people/christian-van-horn.md","scene/people/adrian-kramer.md"]
short_description = "As a musical force, opera is an art form that relies on the power of the unamplified human voice to move audiences. The voices of this cast undoubtedly provide the power to bring this opera to life. Whether you have never seen Lucia before, or you are a bel canto connoisseur, these vocalists and musicians make for a rewarding and awe-inspiring night at the opera."
slug = "brenda-rae-earns-her-ovation-in-o18-lucia"
title = "Brenda Rae earns her ovation in O18 Lucia"
+++

On Friday night, [Opera Philadelphia](/scene/companies/opera-philadelphia/) unveiled a new co-production with the Wiener Staatsoper of Donizetti's [*Lucia di Lammermoor*](https://www.operaphila.org/whats-on/on-stage-2018-2019/lucia-di-lammermoor/). This bel canto staple is O18 festival's most "conventional" offering, but it still delivers plenty of cutting-edge, vibrant and fresh elements. A popular 19th-century tragedy, *Lucia* balances out the rest of the O18 festival's less traditional offerings. Excellent casting and impressive musical preparation make this production an excellent reminder of why we love opera.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1537638883301/Lucia3.jpg.jpg)
<figcaption>Alisa (mezzo-soprano Hannah Ludwig) pleads with Lucia (soprano Brenda Rae) to give up her love Edgardo. *Lucia di Lammermoor*, Opera Philadelphia, 2018. Photo: Kelly & Massa for Opera Philadelphia.</figcaption>
</figure>

The evening featured world class bel canto lines, alongside mind-blowing vocal pyrotechnics, making it some of the best singing that the Academy of Music has heard in a while. [Brenda Rae](/talking-with-singers-brenda-rae/), in the titular role, earned herself impassioned applause from the audience after both of her major arias, as well as in her final curtain call. She sang expressively, and in perfect synchronicity with the orchestra, and the musical chemistry she shares with conductor Corrado Rovaris is clear. Rae's voice truly came to shimmering life in her ornamentations. Her choices in the embellished delivery of "Quando rapito in estasi" were tasteful, elegant, and vibrant. Rae's virtuosic mad scene earned her a mid-scene standing ovation by patrons seated in the orchestra.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1537638892006/Lucia8.jpg.jpg)
<figcaption>Raimondo (bass-baritone Christian Van Horn) tells Lucia (soprano Brenda Rae) to marry Arturo for the good of her family. *Lucia di Lammermoor*, Opera Philadelphia, 2018. Photo: Kelly & Massa for Opera Philadelphia.</figcaption>
</figure>

The entirety of the young North American cast was outstanding. Tenor [Michael Spyres](/scene/people/michael-spyres/), as Edgardo, had a particularly resonant and legato sound from one vowel to the next. While the Academy's acoustics are known to be, at times unfavorable for many tenors, Spyres voice had no chance of being swallowed up. A Philadelphia favorite, baritone Troy Cook, sang the role of Enrico with his beautiful and passionate sound. All of the supporting roles were sung at the highest level, as well. Andrew Owens (Arturo), [Adrian Kramer](/scene/people/adrian-kramer/) (Normanno), and recent AVA grad, Hannah Ludwig (Alisa), all made terrific Opera Philadelphia debuts.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1537638908061/Lucia10.jpg.jpg)
<figcaption> in *Lucia di Lammermoor*, Opera Philadelphia, 2018. Photo: Kelly & Massa for Opera Philadelphia.</figcaption>
</figure>

Audiences are fortunate to have the opportunity to hear [Christian Van Horn](/talking-with-singers-christian-van-horn/) in the role of Raimondo, who is the 2018 Richard Tucker Award winner. Van Horn delivers a stupendous sound with artistic nuance that leaves you wanting to hear more. 

The orchestra, conducted by Corrado Rovaris, was in prime form from the very first tones of the overture. Maestro Rovaris kept an energetic forward momentum throughout the evening, while also reining in moments that seemed to want to to race ahead. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1537638918840/Lucia13.jpg.jpg)
<figcaption>"I shall die, but other blood shall flow with mine," sings Edgardo (tenor Michael Spyres) as he confronts Enrico and Arturo at the wedding. *Lucia di Lammermoor*, Opera Philadelphia, 2018. Photo: Kelly & Massa for Opera Philadelphia.</figcaption>
</figure>

The production itself casts a bleak and ethereal portrayal of a Scottish landscape. Problematic is the state of Lucia from her initial entrance in Act One. She appears unhinged and greatly disturbed when we first see and hear her onstage, which unfortunately causes her character to lose some of its infamous narrative arc. The production abandons the possibility of shock and anticipation for Donizetti's most famous writing, Lucia's Mad Scene. Nevertheless, Rae's sublime singing and physicality is still effective and breathtaking, as she sings the famous duet with the glass armonica while lying on her back.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1537638936126/Lucia16.jpg.jpg)
<figcaption>Lucia (soprano Brenda Rae) reemerges at the wedding festivities, covered in Arturo's blood. *Lucia di Lammermoor*, Opera Philadelphia, 2018. Photo: Kelly & Massa for Opera Philadelphia.</figcaption>
</figure>

The opening night performance had some unfortunate extra-musical interruptions, such as a tripped opening curtain, an all-too-visible exit sign from the backstage area for a large part of Act II, and a noisy cart being pushed in the hallway during delicate moments of the score. In spite of these intrusions, however, opening night of *Lucia di Lammermoor* was a great accomplishment for Opera Philadelphia. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1537638962147/Lucia19.jpg.jpg)
<figcaption>Brenda Rae as Lucia in the famous "mad  scene" of *Lucia di Lammermoor*, Opera Philadelphia, 2018. Photo: Kelly & Massa for Opera Philadelphia.</figcaption>
</figure>

As a musical force, opera is an art form that relies on the power of the unamplified human voice to move audiences. The voices of this cast undoubtedly provide the power to bring this opera to life. Whether you have never seen *Lucia* before, or you are a bel canto connoisseur, these vocalists and musicians make for a rewarding and awe-inspiring night at the opera.

>*Lucia di Lammermoor* runs at Opera Philadelphia runs through September 30. For details and tickets, [click here.](https://www.operaphila.org/whats-on/on-stage-2018-2019/lucia-di-lammermoor/)
