+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2015-06-02T16:31:00-04:00"
lastmod = "2015-06-03T19:32:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1433362311696/03.-Elizabeth-DeShong-Maria-Kanyova-HANSEL-GRETEL-DR2_0100-c.-Dan-Rest.jpg.jpg"
primary_image_credit = "Elizabeth DeShong (Hänsel) and Maria Kanyova (Gretel) in Lyric Opera of Chicago's Hänsel and Gretel. Photo by Dan Rest."
publishDate = "2015-06-03T16:37:00-04:00"
related_articles = ["articles/a-truly-otherworldly-space-heartbeat-operas-drag-extravaganza.md"]
related_companies = ["scene/companies/lyric-opera-of-chicago.md"]
related_people = ["scene/people/alice-coote.md","scene/people/elizabeth-deshong.md","scene/people/danielle-de-niese.md"]
short_description = "The value of the male soprano voice comes from an aesthetic of another time. It&#039;s a curiously stubborn aesthetic, too. There was obvious value placed on a high voice with agility and expression, and yet turning to women to provide that kind of sound was bluntly off the table. The castration of promising young singers was, according to history, a better option than training women and letting them perform."
slug = "breeches-trousers-and-pants"
title = "Breeches, trousers, and pants"
+++

I have to hand it to the opera composers of the 18th and 19th centuries for that whole "trouser role" thing. 

The castrato soprano tradition was losing favour and, to use a Dan Savage phrase, squicking people out. Instead, mezzos were taking the castrato's place, playing young men and other unmanly roles in drag. In the same way that the tenor is a hero, the bass is an old man, and the coloratura soprano is an optimist, the trouser-role we know today is a young man, unmarried, at a crisis point in his short life. 

There's an interesting evolution of male soprano roles. It coincides with the eventual decline of the castrato, and the allowance (and later, celebration) of women on the stage. Handel's castrato roles were the leading men in *Giulio Cesare*, *Rinaldo*, *Ariodante*, and Ruggiero in *Alcina*. The same goes for the title roles in Gluck's *Orfeo ed Euridice* and *Paride ed Elena*. 

The castrato roles in Mozart's operas are a bit different, in that they are supportive characters like Idamante in *Idomeneo*, and Arbate & Sifare in *Mitridate, re di Ponto*. While mezzo-soprano Dorotea Bussani debuted the iconic trouser role of Cherubino in *Le nozze di Figaro*, the more noble Sesto (*La clemenza di Tito*) was premiered by castrato Domenico Bedini. It's important to note that at the same time as women were allowed on the opera stage, the male soprano roles that could be sung by a woman became not only supportive characters, but ones with lower status and laughably immature problems. In the 18th century, it seemed it was the status and seriousness of the character that dictated what gender of singer would premiere it.

By the time we get to Verdi's Oscar or Humperdinck's Hänsel or Massenet's Prince Charming or Strauss' Octavian, these male roles were written knowing they'd be sung by female mezzos. There are clear stylistic reasons for characters like pre-pubescent Hänsel, or Cherubino-inspired Octavian, but these roles are by no means subordinate. I think it's fascinating that the *meaning* of the male soprano voice outlasted the male sopranos themselves. I'm always slightly amused, too, at how gender-bending and cross-dressing is all over opera, yet opera as a whole has a reputation for being stuffy, perhaps a bit Victorian.

The value of the male soprano voice comes from an aesthetic of another time. It's a curiously stubborn aesthetic, too. There was obvious value placed on a high voice with agility and expression, and yet turning to women to provide that kind of sound was bluntly off the table. The castration of promising young singers was, according to history, a *better option* than training women and letting them perform. Of course the issue of women's rights in the 18th century extends far beyond getting stage time next to the men, but in hindsight, it's a shocking display of digging in one's artistic heels.

There is, of course, something secretly exciting about seeing a woman in drag. I think of this often when I see Octavian in *Der Rosenkavalier*. His trysts with the Marschallin are based on Cherubino's with Rosina, and the reference makes operaphiles think of sex-crazed teenaged boys, having affairs with older women in their sexual prime. Strauss was already a singer-phile; you can hear it in his music. I can't imagine that he wasn't aware that the audience would be watching two glamourous female opera divas, re-enacting one of theatre's most sexually charged stories? Why not allow for those secret, unspoken thrills among the most chaste of listeners? After all, that final trio in *Rosenkav* packs a bigger punch when you're invested.

With women singing the majority of trouser roles today, this extra layer of interest now comes with Handel and Monteverdi, too. It's hard to describe, other than as a meta-theatrical drag show. Example: [this](https://www.youtube.com/watch?v=-26AS6DhHbY) is sexier than [this](https://www.youtube.com/watch?v=_isL0E-4TsQ).

So, with the trouser-role tradition in place and the moving forward of women's rights, mezzos today revel in their chances to play the opposite sex. It's sort of a form of reappropriation, women today *owning* their male roles, even the ones written without them in mind. Among singers, mezzos are envied for their chances to gender-bend; they get to march around in comfortable shoes and stuffed pants (metaphorical or otherwise). When sopranos get cast as Oscar, one of their rare fun trouser roles, all the other sopranos are jealous.

If you've not yet read it, Alice Coote wrote a beautiful piece for *The Guardian*, called ["My Life as a Man,"](http://www.theguardian.com/music/2015/may/13/alice-coote-mezzo-breeches-roles-my-life-as-a-man?CMP=share_btn_tw), where she shares details of her craft, and what it does to a woman who spends hours each day as a dude.
