+++
author = ["authors/oliver-munar.md"]
categories = "Review"
date = "2018-04-21T20:52:00-04:00"
lastmod = "2018-04-24T10:35:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1524358290021/sqTosca.jpg.jpg"
primary_image_credit = "Ambur Braid (Tosca) and Gregory Dahl (Scarpia) in Tosca, Calgary Opera, 2018. Photo: Trudie Lee."
publishDate = "2018-04-22T10:16:00-04:00"
related_articles = ["articles/talking-with-singers-jennifer-rowley.md"]
related_companies = ["scene/companies/calgary-opera-emerging-artist-development-program.md"]
related_people = ["scene/people/ambur-braid.md","scene/people/gregory-dahl.md","scene/people/luc-robert.md","scene/people/geoffrey-schellenberg.md"]
short_description = "Her performance was made more exquisite by the fact she sang the whole aria on the floor, often in positions that would make most voice teachers and coaches cringe. And yet, her sound never suffered, maintaining her presence well above the swell of the orchestra, in nothing short of a world-class performance."
slug = "braid-brilliant-in-tosca-role-debut"
title = "Braid &quot;brilliant&quot; in Tosca role debut"
+++

When you debut a role as iconic as Floria Tosca, when do you suppose you have your best performance during the course of a three-show run?

Admittedly, I didn't attend the first two of her performances, but soprano [Ambur Braid](/scene/people/ambur-braid/) was positively brilliant as [Calgary Opera](/scene/companies/calgary-opera/) completed its run of Puccini's *Tosca*. The production was brought to life by veteran stage director Robert Herriot, and conducted by Jacques Lacombe.

Braid's voice soared on this night with jealous rage, tender vulnerability, and unquenchable passion in a triumphant role debut. Her interpretation of the aria "Vissi d'arte", in which Tosca sings of the two driving forces in her life (love and music), was both poignant and breathtaking. Her performance was made more exquisite by the fact she sang the whole aria on the floor, often in positions that would make most voice teachers and coaches cringe. And yet, her sound never suffered, maintaining her presence well above the swell of the orchestra, in nothing short of a world-class performance.

As Tosca's lover Mario Cavaradossi, [Luc Robert](/scene/people/luc-robert/) filled the auditorium with a secure, piercing tenor laced with warmth and conviction, whether he sang on stage or from the wings. On this night, Robert's performance of the famous aria "E lucevan de stelle", in which Cavaradossi sings of his love for Tosca and of life, was world-class, fittingly wrought with powerful emotion of a condemned man. And in the unaccompanied final duet with Tosca, in which the lovers sing with hope at a life of freedom, Robert and Braid soar together in unencumbered passion which, after two-and-a-half acts of singing, is challenging at the best of times.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1524357960542/CalgaryOperaTosca2.jpg.jpg)
<figcaption>Aaron Dimoff (Sacristan) in *Tosca*, Calgary Opera, 2018. Photo by Trudie Lee.</figcaption>
</figure>

By contrast, as the chief of police Scarpia, [Gregory Dahl](/scene/people/gregory-dahl/) was deliciously diabolical. Dahl is a no stranger to Calgary Opera audiences, having been seen in the company's critically acclaimed productions of *Filumena* (Estacio/Murrell), *Dead Man Walking* (Heggie), and *Carmen* (Bizet); no wonder he garnered an enthusiastic response for this portrayal of Scarpia. Simply put, Dahl played the calculating, conniving Scarpia to perfection. His sonorous, rich baritone commanded attention, and his stage presence made it hard not to take your focus away from him. It will be interesting to see how Dahl follows up this performance in Calgary next season, when he takes on the title role in Calgary Opera's production of Verdi's *Rigoletto*.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1524358041190/CalgaryOperaTosca3.jpg.jpg)
<figcaption>Daevyd Pepper (Spoletta) and Gregory Dahl (Scarpia) in *Tosca*, Calgary Opera, 2018. Photo by Trudie Lee. </figcaption>
</figure>

Kudos should also go out to past and present members of Calgary Opera's Emerging Artists Program for their respective performances. Bass-baritone [Aaron Dimoff](/scene/people/aaron-dimoff/) was an entertaining Sacristan in Act I, holding his own in a duet with the sparkling tenor of Luc Robert. He offered a convincing confusion and fear when faced with Scarpia's allegations.

As the off-stage Shepherd (a role admittedly close to my heart) for the aria "Io de' sospiri", soprano [Anne-Marie MacIntosh](/scene/people/anne-marie-macintosh/) elected for a more controlled, almost non-vibrant tone than what she has been singing in recent memory. Singers spend years developing operatic vibrancy, and MacIntosh has developed her instrument into a most exciting sound. On this night she effectively imitated the purity and simplicity of a treble voice heard in the distance.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1524358050071/CalgaryOperaTosca4.jpg.jpg)
<figcaption>Gregory Dahl (Scarpia) and Ambur Braid (Tosca) in *Tosca*, Calgary Opera, 2018. Photo by Trudie Lee. </figcaption>
</figure>

Baritones Johnathan Kirby (Angelotti) and [Geoffrey Schellenberg](/scene/people/geoffrey-schellenberg/) (Sciarrone) made the most of their limited stage time. Kirby, in particular, convincingly channeled the desperation of an escaped prisoner although I would have liked to have heard that desperation reflected a bit more in his singing voice. Schellenberg and tenor [Daevyd Pepper](/scene/people/daevyd-pepper/) (Spoletta) played their roles as Scarpia's henchmen with the same level of cold calculation as their Dahl. They didn't flinch as they dragged Cavaradossi about the stage, and watched stoically as Scarpia played Tosca for his sadistic purposes.

The scenery, provided by the [Lyric Opera of Kansas City](/scene/companies/lyric-opera-of-kansas-city/), was a real winner for this production. A beautiful design, each of the sets -- the church of Sant-Andrea della Valle, an apartment above the Farnese Palace, atop the Castel Sant'Angelo -- gave the singers a lavish backdrop to tell the story of *Tosca*. The lighting design of Harry Frehner also deserves praise, particularly with the setting sun streaming through the window of Scarpia's apartment at the top of Act II, and the passage of time through Act III as Cavaradossi awaits his fate. The decision to extinguish the stars at the end of "E lucevan de stelle" and paint the sky a foreboding purple added an exciting element to the climax.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1524358056396/CalgaryOperaTosca5.jpg.jpg)
<figcaption>(l-r) Gregory Dahl (Scarpia),Luc Robert (Cavaradossi), Ambur Braid (Tosca), and the cast of *Tosca*, Calgary Opera, 2018. Photo by Trudie Lee. </figcaption>
</figure>

The other big winner? The performance of the Calgary Philharmonic Orchestra conducted by Jacques Lacombe. Many of the musicians on this night were involved in the CPO's concert version of *Tosca* five years ago, and it showed. The orchestra played with bravura and security, while still offering space to the singers as necessary. Of course, with voices the calibre of Braid's, Robert's and Dahl's, the orchestra added that extra sparkle.

*Tosca* caps a successful season on the mainstage that also included *The Barber of Seville* (Rossini) and *Eugene Onegin* (Tchaikovsky). Indeed, the bar has been set mighty high for Keith Cerny, Calgary Opera's new General Director and Chief Executive Officer who started in January, as the company prepares for a bold new season.
