+++
author = ["authors/arturo-fernandez.md"]
categories = "Interview"
date = 2022-04-25T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = "As Boston Baroque geared up for its recent star-studded run of Handel's [_Amadigi di Gaula_](https://baroque.boston/handel-amadigi-di-gaula-2022), featuring Anthony Roth Costanzo and Daniela Mack, contributor Arturo Fernandez sat down with director Louisa Muller to chat about obscure Handel operas, and what to do with all those _da capo_ arias:"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1650905442/media/2022/04/sqDanielMack_PhotoCreditGBHProductionGroup_tec1jn.jpg"
primary_image_credit = "Daniela Mack (right) as Dardano in Boston Baroque's in Amadigi di Gaula, 2022. Photo: GBH Production Group."
related_articles = ["articles/talking-with-singers-daniela-mack.md", "articles/arc.md"]
related_companies = ["scene/companies/boston-baroque.md"]
related_people = ["scene/people/amanda-forsythe.md", "scene/people/daniela-mack.md", "scene/people/anthony-roth-costanzo.md"]
short_description = "\"I think the way that I've approached it has been a little bit more of thinking about time expanding and thinking about the things that happen, not happening in real time, so that we take and use da capo arias, we just take a real dive into people's emotional states.\""
slug = "boston-baroques-louisa-muller-on-amadigi-di-gaula"
title = "Boston Baroque's Louisa Muller on Amadigi di Gaula"
youtube_url = ""

+++
**Arturo Fernandez:** How many projector screens is that \[in the space\]?

**Louisa Muller:** Let's see. Oh, it's a good question. So there's six in the back and then five on the sides and then we're still sorting out exactly what's happening across the front \[of the stage\]. I think those ones are all moving up to where that one is, but then and also it will just be the level of the stage.

**AF:** So how do you produce a magic opera in a space like this?

**LM:** Well, video is a large part of it. I mean, there's sort of two sides of it. One is that I think this opera, although it is a magic opera, that the magic isn't the central focus of it. It feels like the magic is always sort of really in support of story or sort of emotionally driven, so rather than making it about sort of special effects or about stage machinery, there's something that's really wonderful about creating this immersive world, which when all the lights are out and the video screens are really on, it feels like you're sort of in it. And then I think that aspect of the sort of emotional drive of the magic then makes more sense.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1650905285/media/2022/04/AmadigidiGaula_PhotoCreditGBHProductionGroup_k0cywb.jpg){{% /md %}}

<figcaption>Anthony Roth Costanzo (front, centre) in the title role of Boston Baroque's Amadigi di Gaula, 2022. Photo: GBH Production Group.</figcaption>

</figure>

**AF:** Yeah. So the immersive side of it is more like you sort of just plunge the audience into it. You're not really thinking of it as, "Oh, the singers are within the audience".

**LM:** No. I think the thing that's special about is there's nothing in between the audience and the performance itself.

**AF:** I also imagine that with a room like this, once the overhead lights go out, it's going to get pretty dark.

**LM:** Yeah, absolutely. Today was one of the first days that we had all the lights on. You can really feel like it's sort of focused in on the stage.

**AF:** And also, it looks like it's going to be pretty close to the action.

**LM:** Yeah, really close.

**AF:** So I see that you've sort of created a kind of proscenium here, but I know that this is technically a recording studio for broadcast, right?

**LM:** Yeah. Television studio.

**AF:** How do you pull that together in a space like this and what are some considerations that you have to do for sound and staging and all that?

**LM:** Well, we're lucky because we're coming at the end of Boston Baroque's whole season that has been in this space and so everyone's become really an expert on how to use this space, which is amazing. I think the sound is a very special thing and we have a great sound engineer to help us with that. But also, I mean, there's capabilities that this space has. It already has this whole lighting grid with so many instruments in it already in place. It has the capability of closing off with the black curtains. It already has sort of a lot of benefits. A lot of things that are built into the space and then we sorted out how we were using it. They've been having some version of this stage for all their concerts that they have, but we've expanded it quite a bit and added space all around the orchestra.

**AF:** I imagine that would help a lot with people just trying to move around \[the orchestra\] if it actually calls for it.

**LM:** Yeah, exactly.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1650905499/media/2022/04/AmandaForsythe_DanielaMack_AnthonyRothCostanzo_PhotoCreditGBHProductionGroup_bphins.jpg){{% /md %}}

<figcaption>(l-r) Daniela Mack as Dardano, Anthony Roth Costanzo as Amadigi, and Amanda Forsythe as Melissa in Boston Baroque's Amadigi di Gaula, 2022. Photo: GBH Production Group.</figcaption>

</figure>

**AF:** Why _Amadigi_ in particular? I don't really know _Amadigi_ super well.

**LM:** No one else does either.

**AF:** So, that's probably the main thing.

**LM:** Yeah. Martin Pearlman and I were talking about why has it not been done more? And we haven't really come up with a satisfactory answer because it's actually a real jewel of a piece. It has one aria that most people have heard, but besides that, it has lots of other really wonderful set pieces and it's just four singers. I mean, it feels eminently practical for sort of the moment that we're in with lit different spaces, and coming out of a big opera house.

**AF:** They probably still do a million _da capo_ arias.

**LM:** Well, of course! We wouldn't want to disappoint. And some really great ones, you know?

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1650905602/media/2022/04/CamilleOrtizasOriana_PhotoCreditGBHProductionGroup_mung4a.jpg){{% /md %}}

<figcaption>Camille Ortiz as Oriana in Boston Baroque's Amadigi di Gaula, 2022. Photo: GBH Production Group.</figcaption>

</figure>

**AF:** How do you cater a production to be able to be livestreamed while also keeping in mind a live audience?

**LM:** I think some of the trick is in how we light it or how we prepare the space, but I am really firmly of the belief actually that a good opera performance of real dramatic commitment for the singers will work on a close-up and will work in a huge house. I really don't subscribe to the idea that you have to have an entirely different style of movement or acting for a screen. So I think the way we've prepared it is really how I would prepare something with-

**AF:** Literally with anything else.

**LM:** Yeah, absolutely. Just really making sure that we are clear about the story that we're telling and we're clear about what each individual moment means and yeah.

**AF:** And with Handel, I mentioned before with the abundance of _da capo_ arias, but I imagine keeping that in mind is even more critical because it can be really hard to sort of direct Baroque opera because of that particular idiosyncrasy of the style and the time.

**LM:** It's interesting because this is my first Handel opera. Certainly, I've seen plenty of Handel stagings that have a ton of business and that that's how you sort of fill every moment, and that's how you get through the _da capo_ arias. I think the way that I've approached it has been a little bit more of thinking about time expanding and thinking about the things that happen, not happening in real time, so that we take and use _da capo_ arias, we just take a real dive into people's emotional states.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1650905732/media/2022/04/DanielaMackasDardano_PhotoCreditGBHProductionGroup_hhiyb2.jpg){{% /md %}}

<figcaption>Daniela Mack as Dardano in Boston Baroque's Amadigi di Gaula, 2022. Photo: GBH Production Group.</figcaption>

</figure>

**AF:** Is this your first Baroque opera you've been directing or not?

**LM:** I guess it is. I mean, I've done chunks of things.

**AF:** Never an entire production?

**LM:** No. But it's something I've always wanted to do because I think there's something in the flip side of it being maybe sort of daunting to direct an opera like this. I think it's also really writing for a director because there's nothing prescriptive about it. So much of the storytelling is these sort of universal themes and I feel like you can really shape the narrative. It's much different than sort of something where it says exactly in the libretto exactly, which props that they're using and whatever. And so if you decide to not do that, you're making a real choice to sort of go against it. In this case, I think it's left so open, and that's exciting for a director.