+++
author = ["authors/arturo-fernandez.md"]
categories = "Review"
date = "2024-04-28T00:00:00-00:00"
lastmod = "2024-04-28T00:00:00-00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1714345992/sqBB_DonG_3B0A0319.jpg"
primary_image_credit = "Hilary Scott."
publishDate = "2024-04-28T00:00:00-00:00"
related_articles = ["articles/searching-for-superlatives-locs-suberb-rigoletto.md","articles/the-price-of-vengeance-rigoletto-at-roh.md"]
related_companies = ["scene/companies/boston-baroque.md"]
related_people = ["scene/people/sidney-outlaw.md", "scene/people/julie-boulianne.md", "scene/people/susanna-phillips.md", "scene/people/patrick-carfizzi.md"]
short_description = "Boston Baroque's casting absolutely knocked it out of the park when it came to casting this particular production. It's a very rare time at the opera where I can say I feel everyone was memorable in their own way, but this performance had probably one of the best ensemble casts I've had the pleasure to watch."
slug = "in-transition-boston-baroques-don-giovanni-shows-very-few-bumps"
title = "In transition, Boston Baroque's Don Giovanni shows very few bumps"
+++
[Boston Baroque](/scene/companies/boston-baroque/) has always had interesting productions in their old WGBH studio productions, with their large projection walls right behind the action and their very short distance from the stage. Aside from performing their opera productions on period instruments, this was mostly what a big draw of their productions was. What, then, is a company to do when they drastically shift venues and they still don't really want to change much of their _modus operandi_? And how does that look in a different format?

Boston Baroque tested the waters for this on the Huntington Theater's stage, performing a classic of the repertory as brilliantly as they always do. Being a period orchestra, of course, they also do so with historical attention, even leaving an entire note in the program about _Don Giovanni_'s version history involving numbers that changed between its premiere in Prague and its Vienna premiere -– a factoid about this opera I didn't even know. As I've mentioned in my review of last year's [_Iphigénie en Tauride_](/soula-parassidis-shines-in-iphigenie-en-tauride/), the orchestral playing is sensitive and wonderful, so I don't think I need to go into that.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1714346034/BB_DonG_3B0A0041.jpg)
<figcaption>Sidney Outlaw as Don Giovanni and Kevin Deas as the Commendatore in Don Giovanni, Boston Baroque, 2024. Photo: Hilary Scott.</figcaption>
</figure>

What is more worthy of attention is the staging, which was different from Boston Baroque's usual fare in more than one way. For one thing, the production was updated to the present day, and the projections on the back screen were updated to handle this. They often presented photos as backdrops of modern cityscapes (I think from around Boston?), and these were as if they were pictures meant to be posted to Instagram.

For sure, there were a few fun touches with this staging: unlike with previous productions they did fully stage the chorus for this one, and it was very interesting to see Don Giovanni given the celebrity-versus-knight treatment in the subtitles and thus update the class disparity between some of the characters that perhaps would not be so obvious to a modern audience watching the story unfold. And then, there were other brilliant touches, such as Don Giovanni bribing an actual mandolin player at the start of his serenade and the fact that Don G is dragged into hell on his sinking yacht. Overall, there were several clever ways they updated the production.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1714345990/BB_DonG_3B0A0326.jpg)
<figcaption>Susanna Phillips Donna Anna in Don Giovanni, Boston Baroque, 2024. Photo: Hilary Scott.</figcaption>
</figure>

There were definitely issues with their (to my knowledge) first attempt at a modernized production, though, but for the most part I felt they were more staging issues than projection issues. First, the Instagram-style photos sometimes weren't in the best taste, as with the dead Commendatore right at the top of the show. I also have to ask what was up with their gun choreography. Between Don G effectively using it like a knife to kill the Commendatore, Donna Anna and Don Ottavio waving it around carelessly, and… whatever that whole thing was at the end of the first act -- where Don Giovanni took the gun from Ottavio but then proceeded to act like he was not in a position of power over the others before throwing it back at Don Ottavio and scampering offstage -- the use of the gun in this production encompassed the most bizarre uses of a prop I have ever seen in an updated opera production.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1714345988/BB_DonG_3B0A0454.jpg)
<figcaption>Julie Boulianne as Donna Elvira, Nicholas Phan as Don Ottavio, and Susanna Phillips as Donna Anna in Don Giovanni, Boston Baroque, 2024. Photo: Hilary Scott.</figcaption>
</figure>

The projections that have become a staple of their productions were not one of the issues I had with them. If anything, I think there are just some strange growing pains that need to be undertaken before the Huntington Theater grows into the projections; due mostly to how there were no walls around the stage for additional projections, I think they did sometimes get lost just because they weren’t as omnipresent as they were in the WGBH studio. But that is not to say they were bad; to make up for the fact that they were not as present, the production did much more with them. From the Instagram photos to the portrayal of the Don’s yacht sinking at the end, and to flashes of the Commendatore’s face when the Don and Leporello invite him to dinner, the projections are doing a lot more than they did previously, and it never distracted from what was happening onstage. And for what it’s worth, the Instagram-style photos are my favorite part of the update, for when they work (as they do throughout Zerlina and Masetto’s wedding) they really do amplify what the singers are doing in their acting performances on-stage.

And really, that is a credit to the singers: somehow, Boston Baroque's casting absolutely knocked it out of the park when it came to casting this particular production. It's a very rare time at the opera where I can say I feel everyone was memorable in their own way, but this performance had probably one of the best ensemble casts I've had the pleasure to watch. Pretty much every character had a memorable portrayal, and more was that even the scoundrels were likeable entirely by how they were acted. Masetto, for instance, actually came around to placing his jealousy at the correct party upon seeing Zerlina's very clear discomfort at the Don's trying to put moves on her later in the opera, and it just made that couple more interesting. The normally thankless Don Ottavio actually has a spine this time around, and acts as someone who does try to act in Donna Anna's best interest. And do not get me started on Leporello, either.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1714345989/BB_DonG_3B0A0402.jpg)
<figcaption>David McFerrin as Masetto and Maya Kherani as Zerlina in Don Giovanni, Boston Baroque, 2024. Photo: Hilary Scott.</figcaption>
</figure>

Ironically, probably the weakest part of the cast was [Sidney Outlaw](/scene/people/sidney-outlaw/) as Don Giovanni himself, and it was entirely because, while he was very effective at playing the seduction game and also had a really lovely singing voice, he was just surrounded by so many people that matched or even exceeded the smooth, playful nature he brought to the character that it didn't dominate the stage like you would expect the Don to do. [Julie Boulianne](/scene/people/julie-boulianne/) as Donna Elvira, for instance, brought an intense comic energy to the character, where her reactions during the Catalogue Aria were hilarious. Maya Kherani also made a huge stamp as Zerlina: her acting chops were just as good as her agile, youthful voice, and I quite enjoyed watching her work. David McFerrin was a very fun Masetto, and I actually think that he and Maya actually made for a more believable couple than you sometimes get with these two. Nicholas Phan and [Susanna Phillips](/scene/people/susanna-phillips/) as Don Ottavio and Donna Anna also made for the perfect foils to the shenanigans surrounding them, being able to effectively ground the seriousness of their characters’ plights without distracting from the scenes around them. It’s also worth noting that it was announced at the top of the show that Susanna Phillips was recovering from a cold, and I genuinely could not tell. 

But it was [Patrick Carfizzi](/scene/people/patrick-carfizzi/) as Leporello who the audience really went wild for at the end. If you want to talk about a scene-stealing performance at the opera, this was it: Carfizzi played Don Giovanni’s hapless servant to a T. He chewed the scenery all around him, with a pitch-perfect characterization in both his mannerisms and his voice, he had a great rapport with the cast, and it was so genuinely hilarious to watch that it almost overshadowed Sidney Outlaw’s turn as the Don.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1714346005/BB_DonG_3B0A0189.jpg)
<figcaption>Patrick Carfizzi as Leporello and Julie Boulianne as Donna Elvira in Don Giovanni, Boston Baroque, 2024. Photo: Hilary Scott.</figcaption>
</figure>

For sure, this was a night with a few hiccups, for there were some weird choices made with a few staging details. But mostly due to the cast and partly due to the projections, this was a delightful Don Giovanni. Was it my favorite production of Don Giovanni? I’m not sure. But it was a very good time at the opera, and if the Huntington Theater is going to be an outlet for future productions I can’t wait to see what it looks like when they’ve ironed out some of the kinks.