+++
author = ["authors/jenna.md"]
categories = "Review"
date = 2021-09-06T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1630549893/media/2021/09/Simmonds_Monster_cover_ehqzca.jpg"
primary_image_credit = ""
related_articles = ["articles/4-secrets-for-better-high-notes.md", "articles/4-tips-for-when-there-are-too-many-notes.md"]
related_companies = []
related_people = []
short_description = "The Monster I Am Today is an excellent pick for the contemporary opera fan. It's grand and operatic, with its emotional peaks and depths. For me, it's a completely new — and frankly, overdue — perspective on this beloved art form. It's a fresh read, and I highly recommend."
slug = "an-opera-fans-must-read-the-monster-i-am-today"
title = "An opera fan's must-read: The Monster I Am Today"
youtube_url = ""

+++
Immediately after reading [Kevin Simmonds' new book](https://nupress.northwestern.edu/9780810143746/the-monster-i-am-today/), _The Monster I Am Today: Leontyne Price and a Life in Verse_, I went on a YouTube spree. Listening to Leontyne Price's Aida was all that made sense after reading this biography-in-verse, where Simmonds tells the story of how Price was the source of his love for singing. He blends poetry, prose, quotes from interviews, quotes from critics, and even fantastical FBI memos regarding Leontyne's power for social change.

_The Monster I Am Today_ (TriQuarterly Books, Northwestern University Press) is probably the most evocative story I've read about falling in love with singing. It's really a combination of biography— Leontyne, of course — and autobiography — [Kevin Simmonds](https://www.kevinsimmonds.com/), the poet, composer, and singer. Within those stories are other stories, like about "acousmatic blackness" — or having a vocal timbre that's associated with being Black — and about being a young Black singer who is gay and not yet out, attending an American music school with a dream to sing like Price.

_Monster_ finds nostalgia in the whiffs of choir life, music-nerd jokes ("Leontyne "Pree-chay"), that first great music teacher, even that first pretty horrible music teacher. A lot of the book is familiar, particularly that thing about being able to pinpoint the exact start of one's obsession with a singer. Simmonds is thorough with his adoration of Leontyne Price, even devoting a poem to the three-minute ovation Price received after "O Patria Mia" at the Met in 1985.

<figure data-type="image">{{% md %}}

![](https://res.cloudinary.com/schmopera/image/upload/v1630549334/media/2021/09/LeontynePrice_xinedq.jpg){{% /md %}}

<figcaption>Leontyne Price.</figcaption>

</figure>

Other things feel less familiar to me, because I'm a white woman: the continuous feedback from white voice teachers that Simmonds' voice was too dark, from white voice teachers who worked to "brighten" and "thin" his sound. When I think back to all the voice lessons I witnessed, and all the push for a specific sound, I'm ashamed to say that I never made the connection that the desired sound was a white one. The Marian Anderson quote that Simmonds included hit me hard: "There were things that happened to my voice that should not have happened."

<figure data-type="image">{{% md %}}

![](https://res.cloudinary.com/schmopera/image/upload/v1630587991/media/2021/09/Kevin_Simmonds_wcqihh.jpg){{% /md %}}

<figcaption>Kevin Simmonds, author of The Monster I Am Today: Leontyne Price and a Life in Verse.</figcaption>

</figure>

Simmonds' poetry bubbles up with imagery and references, like Leontyne Price's turban and the civil rights movement. His writing is taut and vivid, a single line packing a punch the size of American racial inequality. Even through sparse pages, I get major statements: music school has a caste problem; when it's hard for gay men to come out, the cost is enormous; Leontyne Price's sound, ironically, can be dark.

In my YouTube spree, I listened to that "O Patria Mia" from the Met in 1985 — and I watched the three-minute ovation with Simmonds' timestamped notes of Price's every move. And having just read Simmonds' book, I felt a fresh rush of awe for what Leontyne does, making constantly beautiful, constantly interesting sound that holds you captive. It reminded me how particularly high the standard is for Black artists, and how it wasn't even enough for Price to make the kind of sound she did. She also had to rise above the hate, the discrimination, the colleagues trying to relegate her to only Aidas and Besses, the critics whose "imagination still cannot accommodate itself to a black in the role of a white."

<figure data-type="video">{{% md %}}<iframe width="1010" height="758" src="https://www.youtube.com/embed/XD3tCTA8kfo" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>{{% /md %}}

</figure>

_The Monster I Am Today_ is an excellent pick for the contemporary opera fan. It's grand and operatic, with its emotional peaks and depths. For me, it's a completely new — and frankly, overdue — perspective on this beloved art form. It's a fresh read, and I highly recommend.

You can purchase _The Monster I Am Today_ via [Northwestern University Press](https://nupress.northwestern.edu/9780810143746/the-monster-i-am-today/), or at your local bookstore.