+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2017-02-06T12:37:00+00:00"
lastmod = "2017-02-07T20:25:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1486465176595/2017-02-08---Statler-Waldorf.jpg.jpg"
publishDate = "2017-02-07T16:35:00+00:00"
related_articles = ["articles/opera-haters-they-exist-thats-alright.md","articles/in-review-lucia-di-lammermoor-at-roh.md","articles/take-a-joke-have-a-nap.md"]
related_companies = ["scene/companies/royal-opera-house.md","scene/companies/teatro-alla-scala.md"]
short_description = "Those who are brave enough to boo are also brave enough to make sure that everyone knows who exactly they&#039;re booing. Curtain calls can be a cruel set-up, the bowing artist well aware of when the crowd turns from admiration to disappointment. Seasoned artists have a thick skin, but it can&#039;t be a good feeling to stand in front of a crowd of people who are unhappy and who want you to know it."
slug = "booing-at-the-opera-why"
title = "Booing at the opera: why?"
+++

When it comes to operatic culture shock between North America and Europe, more jarring than scandalous sets or onstage nudity is the practice of booing in the opera house. In North America - and particularly in Canada - the opposite of applause is simply less enthusiastic applause. In Europe, it's booing. We've heard the loud, well-directed jeers and boos hurled from the audience; they're usually directed at the creative team, but on rare occasions, individual singers [fall prey](https://www.theguardian.com/music/musicblog/2006/dec/12/neverletlascalasbooboyss) to the ululating critics.

Our first encounter with operatic booing came from disappointed Italians after a failed high-C attempt by a young Rodolfo; but it was the howls following Katie Mitchell's production of [*Lucia di Lammermoor*](/in-review-lucia-di-lammermoor-at-roh/) at the Royal Opera House that showed booing to be a true form of audience feedback. In Italy, booing has become nearly institutionalized, when one considers the famed *loggionisti* in Milan; the group of vocal protesters have monopolized a cluster of seats of La Scala, famously preying on the likes of [Roberto Alagna](https://www.theguardian.com/music/musicblog/2006/dec/12/neverletlascalasbooboyss) and [Luciano Pavarotti](https://www.theguardian.com/music/2014/sep/07/la-scala-roberto-alagna-werther-loggionisti-alexander-pereira).

In his editorial on *Slipped Disc*, [When Booing Has to Stop"](http://slippedisc.com/2017/02/when-the-booing-has-to-stop/) Norman Lebrecht calls booing "a habit for some operagoers - a bit of fun, a dare." Lebrecht cited two instances of boos in close succession, both at the Vienna State Opera. "The first was a lone protestor who had something against the (excellent) conductor," he writes. "The second was a spattering of hoots at Daniele Abbado's fine design team for *Trovatore*. The Vienna rag *Kurier* this morning made the – brief and unrepresentative – booing their main headline."

On the one hand, it's nice to hear of opera audiences who are this passionate about what they see and hear. It speaks to a culture that's educated about its traditions, familiar enough with opera to have opinions.

On the other hand, booing seems a bit basic, especially for something like opera. Perhaps it's because we're sympathetic to the enormous work it takes to produce an opera, and perhaps it's because we're Canadian, but hearing an audience boo a show is positively cringe-inducing. 

Those who are brave enough to boo are also brave enough to make sure that everyone knows *who exactly* they're booing. Curtain calls can be a cruel set-up, the bowing artist well aware of when the crowd turns from admiration to disappointment. Seasoned artists have a thick skin, but it can't be a good feeling to stand in front of a crowd of people who are unhappy *and who want you to know it*.

It's enough to make us wonder, what are these irate operagoers hoping to accomplish with their booing? Are the singers, directors, and designers supposed to do something with this unsolicited feedback? Is the director supposed to go back to the drawing board with his production based on boos? Is the singer supposed to cancel all future gigs until she "fixes" what the *loggionisti* don't like about her voice? Or is booing a social mating call of sorts for those seated, letting everyone know that you're *too smart for this nonsense*?

If it's more about making one's opinions literally heard, booing at the opera is kind of like that Jerry Seinfeld bit about men who honk their horns at women as they drive by them, thinking, "I think I made my point." If it's about operagoers who want their neighbours to know they're opera-savvy, that's about as fun as being the only person in the room who's seeing that cult classic film for the first time.

Booing falls under the umbrella free speech, in all fairness; but does mean it's not rude. Lebrecht puts it well: "The people who do it would never stand up in a crowded restaurant and boo a dish they did not like. If they did, they would be banned for life. Or beaten up by the chef."

>Feature image: [Brett Kiger](https://www.flickr.com/photos/brettkiger/6078995711/in/photolist-agbrCT-8SvKFK-6dUYSe-6dUYJ8-xXFKa-9Cse7C-bA3YtP-cecfBW-39Faku-eWvbH8-pshaWh-63e3t2-ceceTN-cecfaL-6k7iaS-6prMK4-d4ChRf-aRqeUx-ceceFY-bxUpGz-6crgh4-7zoDyu-8izRK2-qmRxrP-bWPSDF-ceceYu-bWPSUM-cecfHh-ceceNL-bWPTcH-bWPSQa-gxDCFb-6Zox3T-6edsxW-dtCrfR-bn97Wb-6JZTZh-bwu8tp-6aP9nA-4GgriW-aFMbJa-cecezs-akTJ6C-cecf55-MGFk3U-b2ejiD-QZRcQQ-cecfjN-54gN4i-dvx8Z3) via [Flickr](https://creativecommons.org/licenses/by-nc-nd/2.0/legalcode).
