+++
author = ["authors/arturo-fernandez.md"]
categories = "Review"
date = "2019-03-31T22:39:58+00:00"
disclaimer = "Content Warning: A real-life experience with sexual assault is discussed in this review. Permission was granted from the victim to discuss the assault in question. Reader discretion is heavily advised."
image_gallery = []
postamble = "Boston Opera Collaborative's production of _Don Giovanni_ runs through April 6. For details and ticket information, [click here](https://www.bostonoperacollaborative.org/don-giovanni-march-19)."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1554072100/media/2019/03/sqBOCDonG032619-2964.jpg"
primary_image_credit = "Junhan Choi (Don Giovanni) in Boston Opera Collaborative's production of Don Giovanni, 2019. Photo: Dan Busler."
related_articles = ["articles/in-review-tcherniakovs-don-giovanni.md", "articles/when-don-giovanni-is-the-don.md", "articles/rehearsing-trauma-how-working-on-an-opera-helped-me-heal.md"]
related_companies = ["scene/companies/boston-opera-collaborative.md"]
related_people = ["scene/people/jessica-jane-jacobs.md", "scene/people/fran-rogers.md", "scene/people/john-bitsas.md", "scene/people/junhan-choi.md"]
short_description = "From the beginning, the production ensures that you do not forget this is about the Me Too movement: the show begins with a slideshow of people like Harvey Weinstein and others that is prefaced with Trump's now-infamous \"grab them by the pussy\" comments. "
slug = "bocs-don-giovanni-smart-and-relevant"
title = "BOC's Don Giovanni smart and relevant"
youtube_url = ""

+++
It is a very common thread in present-day opera performance that directors will often try to mold a classic of the operatic repertoire in a way that comments on themes and topics relevant to the modern day and not necessarily to the time of the opera's origin. Frequently, this is met with disastrous results, as the works typically do not have the plasticity necessary to stand up to such a treatment. However, some parts of the operatic repertory do stand up to reinvention better than others: of these, perhaps the likeliest candidates for reinterpretation are Wolfgang Amadeus Mozart's collaborations with Lorenzo da Ponte: after all, these are works whose gender politics have had to be constantly reinterpreted as time has marched on.

Thus, we come to [Boston Opera Collaborative](/scene/companies/boston-opera-collaborative/)'s production of _Don Giovanni_, which is presently playing in the Ben Franklin Institute of Technology. _Don Giovanni_ in particular has such strong themes surrounding gender politics and sexual violence that producing it today will brush up with the #MeToo movement in some way. Perhaps realizing that a production of an opera about a serial womanizer which begins with an off-stage rape would engage with #MeToo no matter how it's played, stage co-directors Patricia-Maria Weinmann and Greg Smucker choose to completely embrace the #MeToo element in practically every part of the production, and it does so in ways that are surprising and incredibly smart in a way that ties into Mozart and Da Ponte's work beautifully.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1554072510/media/2019/03/BOCDonG032619-2859.jpg){{% /md %}}

<figcaption>Junhan Choi (Don Giovanni), Andrew Miller (Leporello), and Ensemble in Boston Opera Collaborative's production of Don Giovanni, 2019. Photo: Dan Busler.</figcaption>

</figure>

From the beginning, the production ensures that you do not forget this is about the Me Too movement: the show begins with a slideshow of people like Harvey Weinstein and others that is prefaced with Trump's now-infamous "grab them by the pussy" comments. From here, the symbolism only deepens in how the men behave towards the women of the show, and nobody is safe. Masetto here is depicted as a toxic man whose jealousy drives him to blame Zerlina for the things Don Giovanni does pretty much as soon as he comes onstage. Don Ottavio, while generally played as supportive of Donna Anna, generally tries to brush off what happened to her as being not as severe as she feels it is, a decision that ends up not working out well for him. Even Leporello grows tired of Don Giovanni, throwing bribe money at Don G's feet at the end over how disgusted he is both at Don G's treatment of Donna Elvira, and perhaps at his own willingness to enable him earlier in the opera.

> I thus had an extremely visceral reaction to the way the scene played out that stayed with me long after I left

But of course, it all comes down to Don Giovanni himself, and in this production he is nothing short of a complete snake. Here, he is played as a famous photography artist, whose oeuvre is implied to consist of photographs of women thanks to projections on the two screens that stood on either side of the main performing area. Junhan Choi adds a touch of menace in how he characterizes the Don, both in his smug countenance as he manipulates his way into these women's hearts, the violence with which he acts when things don't entirely go his way (and even when they do), and how he curls his voice around the character's various turns. He is equal parts menacing and charming. Perhaps no part of the show was more indicative of this than how the production played the famous duet "Là ci darem la mano", in which Don Giovanni seduces the dearling Zerlina. Here, Don G works by using Masetto's previously mentioned anger at Zerlina to his advantage: Don G manages to turn Masetto's behavior into a tool with which he paints himself as a better option, and it is in this way that Giovanni works his way into Zerlina's dress despite her protests. The duet here serves to cement this by letting Choi engage his smooth, lyrical voice to pull Zerlina in the rest of the way that his cool, collected mannerisms did elsewhere.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1554072525/media/2019/03/BOCDonG032619-2748.jpg){{% /md %}}

<figcaption>Jessica Jacobs (Donna Anna), Francis Rogers (Don Ottavio) in Boston Opera Collaborative's production of Don Giovanni, 2019. Photo: Dan Busler.</figcaption>

</figure>

Some people may dismiss this as an example of typical operatic excess staged by directors seeking to make a point. Those people would be wrong, and alas, I would know this all too well: the whole scenario depicted here reminded me of a very dear friend of mine who, just two years before the #MeToo firestorm took hold, was raped by a manager at the grocery store he worked at. The way he describes this manager's rape fits all too closely to how this duet plays out in this production: said manager took advantage of the fact my friend had just come out of a painful breakup from a nearly eight-year-long relationship, getting what he wanted out of my friend using mind games similar to what Don G. successfully pulls when he gets Zerlina to flirtatiously chorus "Andiam, andiam, mio bene, a ristorar le pene d'un innocente amor," and unfortunately my friend had no Donna Elvira to intervene and prevent the assault.

I thus had an extremely visceral reaction to the way the scene played out that stayed with me long after I left the Ben Franklin Institute of Technology. This is no mere operatic hyperbole: this is Smucker and Weinmann recognizing that sexual assault is as much a form of psychological violence as it is a physical one. Because of this one small facet, and the fact that they both lean into the undercurrent already present in Mozart and Da Ponte, it lends an honesty to the production's intentions that cannot - and should not - be ignored.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1554072535/media/2019/03/BOCDonG032619-2712.jpg){{% /md %}}

<figcaption>Sarah Cooper (Zerlina), Junhan Choi (Don Giovanni) in Boston Opera Collaborative's production of Don Giovanni, 2019. Photo: Dan Busler.</figcaption>

</figure>

There is an additional far-reaching decision that amplifies the production's themes that, admittedly, is perhaps a touch sacrilegious to Mozart's score: Smucker and Weinmann opted to change the gender of the Commendatore, so that she is now Donna Anna's mother (and also "Commendatrice"). I typically would balk at the idea of changing a character's gender in such a way, but here it has the effect of amplifying the misogyny that Don Giovanni is already blatantly guilty of in Da Ponte's libretto to a degree that cannot be ignored by the audience. This small change in focus essentially sends shockwaves through the entire rest of the work, and it reframes the men's actions in such a way as to amplify the theme of feminist anger. This even extends into the final scene in which Don Giovanni is dragged into hell (this production wisely opted to cut the epilogue that ends the work), for it is a chorus of women that taunts Don Giovanni with the promise of eternal suffering and not men as printed in Mozart's score. This ultimately provides a necessary catharsis to the whole work, one that is only made sweeter by the feeling that karma has been dealt by the very women that Don Giovanni has mistreated throughout the whole of the work.

> Smucker and Weinmann have clearly done their homework when it comes to the variety of experiences people have with sexual assault.

Of course, to bring this story to life the way it has here also requires a cast who meets the demands of this production. As always, in this Boston Opera Collaborative delivered. I have already spoken of [Junhan Choi](/scene/people/junhan-choi/), but mention must also be given to Andrew Miller's Leporello: it is not a very easy thing to play Leporello as anything other than the quirky tool that accompanies Don Giovanni on his misadventures, but Miller manages to find something in the character's pathetic nature that does allow the audience to feel some amount of sympathy for him. [John Bitsas](/scene/people/john-bitsas/) did a great job playing a more forceful Masetto than usual, and [Francis Rogers](/scene/people/fran-rogers/) fleshed out the normally thankless role of Don Ottavio with a kind of disbelief that permeates the character. The women also had some great singers as well: Isabelle Zeledón's Donna Elvira was played with a fire that burned without ever flaming out, [Jessica Jacobs](/scene/people/jessica-jane-jacobs/) provided a spurned Donna Anna who was simply trying to deal with what happened to her in the only way she can think of, Shannon Grace's Commendatrice proved authoritative to the degree that left me comfortable with the gender flip of the role, and Sarah Cooper's Zerlina provided some much needed levity and playfulness to the show, especially in her interactions with Masetto.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1554072563/media/2019/03/BOCDonG032619-2688.jpg){{% /md %}}

<figcaption>Andrew Miller (Leporello), Felisha Trundle (Assistant), John Bitsas (Masetto), Sarah Cooper (Zerlina) in Boston Opera Collaborative's production of Don Giovanni, 2019. Photo: Dan Busler.</figcaption>

</figure>

Perhaps not all of the production's touches worked: the playful, supportive Masetto in Act II was perhaps too far disconnected from the jealous, angry Masetto in Act I, Leporello's famous Catalogue Aria should probably have been trimmed in service to his character arc, and I am not entirely sure that keeping the Commendatrice singing off-stage while having Don Giovanni interact with projectors displaying pictures of a ghostly Commendatrice was wise. But Smucker and Weinmann have clearly done their homework when it comes to the variety of experiences people have with sexual assault, and the result is a production that actively and honestly engages with the discourse surrounding rampant sexual assault in modern American culture. The even more remarkable thing is that Smucker and Weinmann find these threads in the original opera without having to reach too far for them the way so many directors do when approaching an older work with more contemporary themes. In the end, other opera directors should take notes from this production, for they have cracked a code that stumps so many others, and the result is a gut punch of a production that absolutely cannot be missed.