+++
author = ["authors/greg.md"]
categories = "Review"
date = 2023-04-09T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1680903105/media/2023/04/sqAtGBluebeard-photobyDahliaKatz-4667_wkh8we.jpg"
primary_image_credit = "Charlotte Hellekant as Judith in Bluebeard's Castle, Against the Grain Theatre / Theatre of Sound / Opera Ventures, 2023. Photo: Dahlia Katz."
related_articles = ["articles/talking-with-singers-gerald-finely.md", "articles/in-review-bluebeards-castle-erwartung.md", "articles/bluebeard-blo.md"]
related_companies = ["scene/companies/against-the-grain-theatre.md"]
related_people = ["scene/people/charlotte-hellekant.md", "scene/people/gerald-finley.md"]
short_description = "Finley's Bluebeard is caring, soft-spoken, and deliberately gentle. The scene opens in silence with him preparing to bring Judith home. He's so excited to see her, he kisses her photo and practically skips out the door."
slug = "brilliant-a-compassionate-bluebeard-and-a-comforting-castle"
title = "Brilliant: a compassionate Bluebeard and a comforting Castle"
youtube_url = ""

+++
Hello, Schmop-Tops,

Your friendly neighbourhood Greg here, to let you know that the spring opera season has definitely sprung. Sorry for the delay on this one, it was a lot to chew on.

Last week I had a coming-home of sorts. After three long years, [Against the Grain Theatre](/scene/companies/against-the-grain-theatre/) opened their first live performance since [2019's _Figaro's Wedding_](https://www.theglobeandmail.com/arts/music/article-against-the-grain-theatres-figaros-wedding-marries-a-mozart-classic/) (featuring Yours Truly.)

Full disclosure: I've been working with AtG since the jump. I'm the only singer to have performed every performance of both _Figaro's Wedding_ and [_La bohème_](/hype-atg-boheme/). I'm currently the host of their monthly [Opera Pub](https://atgtheatre.com/upcoming/opera-pub/) -- if you're in Toronto bring yourself down, it's loads of fun. So I have a long close relationship with Against the Grain Theatre.

That being said, _Bluebeard's Castle_ is a co-production with [Theatre of Sound](https://www.theatreofsound.org/) and [Opera Ventures](https://www.opera.ventures/). Similar to AtG, these visionary artists are focusing on re-imagining operas to tell current, contemporary stories. While the visions of the two companies are in total synergy, you can tell this production is different than AtG shows past.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1680904301/media/2023/04/AtGBluebeard-photobyDahliaKatz-5320_vxolen.jpg){{% /md %}}

<figcaption>The cast of Bluebeard's Castle, Against the Grain Theatre / Theatre of Sound / Opera Ventures, 2023. Photo: Dahlia Katz.</figcaption>  
</figure>

In his opening remarks, Artistic Director Joel Ivany gave a quick roll-call of their work during the dark (er?) times. They very successfully pivoted to online, video, and audio recording. They parlayed that into great successes (Junos, hello?). Extolling the virtues of collaboration as the main ingredient for their continued success, Ivany stated that this is the next step in a long line of partnerships that have produced some of the most scintillating new opera productions out there.

[_Bluebeard's Castle_](https://atgtheatre.com/upcoming/bluebeards-castle/) is no exception. The original tells the story of Bluebeard and Judith -- Judith has abandoned her family to marry the extremely wealthy Duke. Upon arrival at his castle, things take a dark turn. All the doors are locked and the place is very dimly lit. She's told not to open any doors -- obviously she does (I would too). Behind each door we see why Bluebeard wanted them kept hidden, culminating in Judith's discovering the dead wives past (who had also looked behind the doors).

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1680904389/media/2023/04/AtGBluebeard-photobyDahliaKatz-5218_ps01xs.jpg){{% /md %}}

<figcaption>Charlotte Hellekant as Judith and Gerald Finely as Bluebeard in Bluebeard's Castle, Against the Grain Theatre / Theatre of Sound / Opera Ventures, 2023. Photo: Dahlia Katz.</figcaption>  
</figure>

With a new libretto to Béla Bartok's Gothic horror classic by Daisy Evans -- Evans directs this production as well -- the tone is shifted from one of fear to one of love. Judith is now suffering from dementia and Bluebeard is trying to keep her comfortable. The "doors" are now memories of her past, full life as both a young girl and then happily married to Bluebeard. It is a remarkably successful parallel. The new libretto actually didn't stray too far from the English translation of the work that I'm familiar with. The use of the doors as a metaphor for memories in particular was a device I was very fond of.

Canadian superstar baritone [Gerald Finley](/talking-with-singers-gerald-finley/) tackled the complex role of Bluebeard. The man is constantly walking a razor's edge doing his best to keep the absolute love of his life comfortable in her great turmoil. Finley's Bluebeard is caring, soft-spoken, and deliberately gentle. The scene opens in silence with him preparing to bring Judith home. He's so excited to see her, he kisses her photo and practically skips out the door. After he brings her home (and the score begins) we then see him become a man who's both exhausted and determined. We see his very real flaws and his very true virtues. The singing was outstanding. Finley's evenness of tone through his whole register was keenly on display through his conversational almost matter-of-fact delivery. The singing was so gorgeously handled I truly felt hey was speaking his text.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1680904456/media/2023/04/AtGBluebeard-photobyDahliaKatz-5163-scaled_tle7pu.jpg){{% /md %}}

<figcaption> in Bluebeard's Castle, Against the Grain Theatre / Theatre of Sound / Opera Ventures, 2023. Photo: Dahlia Katz.</figcaption>  
</figure>

Judith is an incredibly difficult role to both sing and portray - made exponentially harder in this re-imagined narrative. The role is rangey, rhythmically difficult, and has a lot of repeated text with subtle differences -- a nightmare to memorize. As Judith, mezzo-soprano Charlotte Hellekant acted brilliantly. Her tender and layered presentation of a woman suffering dementia was considerate, creative, and respectful. I did have some issues with the singing. The piece is very conversational; there are no real arias _per se_, save Bluebeard describing his wife as parts of the day.

There are extended lines of dialogue, but none from that place of soliloquy (even if a lot of arias aren't a true soliloquy - but you know what I mean) and I feel this may have caused her to lose a bit of her vocal line. There was also some unnecessary vowel-modification, causing some cognitive dissonance in the ear. The venue was more intimate than one would expect; although the stage is quite large and cavernous, the house itself is not that large and not that far from the singers. This issue -- definitely personal and my own -- may have stemmed from an attempt to sing for a bigger room? She's an exquisite vocalist, I just felt that both the character and the vocal production were both unsettled. It works great for the acting, but a better balance could have been found in the singing. The acting, I say again, was definitely a masterclass though.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1680904496/media/2023/04/AtGBluebeard-photobyDahliaKatz-5369_ierrtt.jpg){{% /md %}}

<figcaption>Charlotte Hellekant as Judith in Bluebeard's Castle, Against the Grain Theatre / Theatre of Sound / Opera Ventures, 2023. Photo: Dahlia Katz.</figcaption>  
</figure>

The real departure from the original comes in the form of six memories portraying Judith. From young girl, to young woman, to a young mother, to a grieving one we are actually shown what she and Bluebeard are remembering. Played by Alexis Celestine Wilson (1 & 2), Jamaica Fraser (3 & 4), and Josée Young (5 & 6), these silent visions were simultaneously haunting and reassuring. The mirroring of archetypal gestures was a beautiful way to demonstrate that these very different looking women were in fact the same character.

Adrian Linford's design brought a familiarity with a dash of chaos. We all recognize the room that is now the "castle" from some point in our childhood. Whether it's your childhood home, your grandmother's house, your uncle's cottage, the vibe is unmistakably nostalgic, driving in harder the themes of memory and memory loss. Familiar though it was, it was also chaotic. As if seeing this familiarity through a kaleidoscope, which I can only imagine is a similar result inside the mind of a person living with dementia.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1680904638/media/2023/04/AtGBluebeard-photobyDahliaKatz-4636_kipvow.jpg){{% /md %}}

<figcaption>Charlotte Hellekant as Judith and Gerald Finley as Bluebeard in Bluebeard's Castle, Against the Grain Theatre / Theatre of Sound / Opera Ventures, 2023. Photo: Dahlia Katz.</figcaption>  
</figure>

The small orchestra under Stephen Higgins played superbly. Its a complex and beautiful score and there was not a single balance issue at any time -- often a pitfall when the orchestra appears onstage. This may also be in part to Higgins' excellent arrangement. The tempi were elastic without being undisciplined, and the players responded to the conductor seamlessly.

The show has closed here in Toronto, but is making the rounds to other houses across North America. It's a remarkable new setting of the piece while still retaining the poetry and anxiety inherent in the original. If you're near one of these upcoming productions I _highly_ recommend you see this.

It really is brilliant.