+++
author = ["authors/arturo-fernandez.md"]
categories = "Review"
date = 2023-03-23T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = "Boston Lyric Opera's production of [_Bluebeard's Castle_ and _Four Songs_ by Alma Mahler](https://blo.org/bluebeard) runs through March 26."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1679618667/media/2023/03/sq_BLO_Bluebeard_Judith_Naomi_Louisa_O_Connell_comes_to_terms_with_her_potential_fate_in_BLO_s_Bluebeard_s_Castle_Four_Songs_sleafk.jpg"
primary_image_credit = "Naomi Louisa O'Connell (Judith) in Boston Lyric Opera's production of Bartók's \"Bluebeard's Castle\" and Alma Mahler's \"Four Songs\", 2023. Photo by Liza Voll."
related_articles = ["articles/in-review-bluebeards-castle-erwartung.md"]
related_companies = ["scene/companies/boston-lyric-opera-1.md"]
related_people = ["scene/people/naomi-louisa-o-connell.md", "scene/people/ryan-mckinny.md"]
short_description = "The last of the four songs is actually quite dark in a way that fits the quizzically gothic ending of Bluebeard's Castle pretty perfectly, so it ended up forming an arc that actually did somehow add to one of opera's most perfect endings."
slug = "bluebeards-music-shines-with-almas-highlights"
title = "Bluebeard’s music shines, with Alma’s highlights"
youtube_url = ""

+++
Béla Bartók's _Duke Bluebeard's Castle_ is one of my favorite operas of all time: I have always loved its mysterious, colorful score, and it is one of a selection of operas I point people to when I want to introduce them to opera.

So when I heard that [Boston Lyric Opera was producing it](https://blo.org/bluebeard), I was absolutely stoked. My curiosity was piqued even more when stage director Anne Bogart was brought back. After all, one of the great strengths of Bartók's opera is the way that Béla Balász' libretto maintains just the right level of ambiguity that you can play Judith and Bluebeard in any way you want, and that would play extremely well to a director whose eye for detail was instrumental in creating the vividly gendered world of BLO's 2019 production of [_The Handmaid’s Tale_](/installation-handmaids-tale-a-dramatic-chilling-staging/).

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1679618968/media/2023/03/BLO_Bluebeard_Judith_Naomi_Louisa_O_Connell_and_Bluebeard_Ryan_McKinny_celebrate_the_castle_garden_in_BLO_s_Bluebeard_s_Castle_Four_Songs_sfrr2k.jpg){{% /md %}}

<figcaption>Naomi Louisa O'Connell (Judith) and Ryan McKinny (Bluebeard) in Boston Lyric Opera's production of Bartók's "Bluebeard's Castle" and Alma Mahler's "Four Songs", 2023. Photo by Liza Voll.</figcaption>  
</figure>

Anne Bogart met the ambiguity with her ideas almost immediately in demanding the work be paired with works by a woman composer. The eventual pairing was a set of four songs by Alma Mahler (two of which were orchestrated rather sumptuously by Julian Reynolds), and then structured the entire show around portraying Judith and Bluebeard's relationship as paralleling that of Alma and Gustav; e.i., in a way where Bluebeard's treatment of his wives and eventually Judith mirrors the kind of creative quashing that Gustav inflicted towards Alma. It also chose to enrobe _Bluebeard's Castle_ within the third and fourth songs of this set; not knowing the Alma Mahler songs, I questioned the wisdom of this at first, but the last of the four songs is actually quite dark in a way that fits the quizzically gothic ending of _Bluebeard's Castle_ pretty perfectly, so it ended up forming an arc that actually did somehow add to one of opera's most perfect endings. (And yes, I say this even though the night ended with Judith and the wives murdering Bluebeard on stage using rope as a stand-in for blood!)

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1679619017/media/2023/03/BLO_Bluebeard_Naomi_Louisa_O_Connell_in_BLO_s_Bluebeard_s_Castle_Four_Songs_bvfcfg.jpg){{% /md %}}

<figcaption>Naomi Louisa O'Connell (Judith) in Boston Lyric Opera's production of Bartók's "Bluebeard's Castle" and Alma Mahler's "Four Songs", 2023. Photo by Liza Voll.</figcaption>  
</figure>

She also chose to have Bluebeard's other wives present throughout the whole. It certainly helped set the mood early in the evening: the performance was preceded by a half-hour long salon gathering, during which pianist Yukiko Oba played pieces by women composers as Bluebeard's six wives wandered around (yes, Bogart expanded the number of wives back to six). You could tell straight away who they were: they wore crystal masks, never spoke to anyone, and stood out from the crowd of modern-dressed people with their early-20th-century Viennese dresses. The effect was rather creepy, and it served as a perfect precursor to what was a gothic, strange evening.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1679618993/media/2023/03/BLO_Buebeard_Judith_Naomi_Louisa_O_Connell_makes_a_disturbing_discovery_in_BLO_s_Bluebeard_s_Castle_Four_Songs_mlxrsv.jpg){{% /md %}}

<figcaption>Ryan McKinny (Bluebeard) and Naomi Louisa O'Connell (Judith)t in Boston Lyric Opera's production of Bartók's "Bluebeard's Castle" and Alma Mahler's "Four Songs", 2023. Photo by Liza Voll.</figcaption>  
</figure>

The wives were always visible throughout the whole, when the audience migrated to the performance area in the middle of what was essentially a redressed cruise ship terminal, doing a whole lot of dance throughout the entire opera and especially whenever a door is opened. This became pretty effective during the sixth door scene, where they held long sheets meant to portray the lake of tears, and the tableau that resulted from the opening of the final door was great. Their combined exhalation also served as the castle's groaning throughout the work, and this was a touch I greatly enjoyed for how it sets up the way the opera unfolds. I cannot say I was a fan of every part of how the wives were used: there were definitely times where I felt that some of the movement was there purely for the sake of busywork. However, I liked the way they added to the atmosphere of the production.

> \[McKinny\] commanded the stage with a powerful bass-baritone, which fit perfectly with how his character holds dominion over all the women around him until the end.

And boy, what a gorgeous production it was! The use of a cruise ship terminal as a location was actually quite brilliant: my friend and I were commenting that walking up to the entrance where we went in to watch the performance was a little like walking into a strange man's large abandoned castle. The actual performance area was also quite interesting: the platform in the center was the only lit part of the whole space, and it really helped create the production's atmosphere.

But perhaps most ingenious of all was the way the doors were staged: here, the door openings were represented by a combination of Bluebeard hiding Judith's eyes, as well as changes of bedsheets on the bed in the center of the stage, where Judith (and sometimes Bluebeard) would pull away a bedsheet to reveal a new color to denote the next room. There was inventive staging with it (such as the gold bedsheet hiding rose petals underneath it for the fourth room and the aforementioned long sheet standing in for the lake of tears), and in my estimation I think the messiness that resulted on-stage added to Judith's effect on the titular castle.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1679619096/media/2023/03/BLO_Bluebeard_Ryan_McKinny_as_Bluebeard_in_BLO_s_Bluebeard_s_Castle_Four_Songs_ty9gft.jpg){{% /md %}}

<figcaption>Ryan McKinny (Bluebeard) in Boston Lyric Opera's production of Bartók's "Bluebeard's Castle" and Alma Mahler's "Four Songs", 2023. Photo by Liza Voll.</figcaption>  
</figure>

But of course, the real meat and potatoes of the evening is [Naomi Louisa O’Connell](/scene/people/naomi-louisa-oconnell/)'s Judith and [Ryan McKinny](/scene/people/ryan-mckinny/)'s Bluebeard, both of whom were absolutely on fire. I do feel that O'Connell’s voice was perhaps a touch too light even for the reduced orchestration that BLO's production used for _Bluebeard's Castle_ (although this admittedly was not helped by the fact that my seat was very close to the orchestra), but as an actress she hit every note exactly as she needed to, and inflected her tone with such emotion that even her breathier notes spoke volumes about what she was feeling. She completely sold Judith as a woman who starts the show genuinely loving Bluebeard, and her transition into someone who grows disgusted with his quashing of the wives’ wills. Her reading of the Alma Mahler songs was also pitch-perfect, both in bringing the songs to life and relating them to this interpretation of _Bluebeard's Castle_.

McKinny was every bit her match as Bluebeard: from the moment he pulled the covers off himself and revealed he had been there the whole time, he commanded the stage with a powerful bass-baritone, which fit perfectly with how his character holds dominion over all the women around him until the end of the fourth Alma Mahler song. He also acted his part exceptionally well, which is a tricky thing considering he played a man who genuinely loves Judith but also ends up suppressing her urge to ask questions as the show goes on.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1679619031/media/2023/03/BLO_Bluebeard_Ryan_McKinny_is_the_title_character_in_BLO_s_Bluebeard_s_Castle_Four_Songs_g1p5w3.jpg){{% /md %}}

<figcaption>Ryan McKinny as Bluebeard in Boston Lyric Opera's production of Bartók's "Bluebeard's Castle" and Alma Mahler's "Four Songs", 2023. Photo by Liza Voll.</figcaption>  
</figure>

All of this came together for an evening that ended up highlighting one of my personal favorite works in the operatic repertoire in a way I greatly enjoyed. I have always loved Bartók's only opera score for its dark, evocative music, but I had never been able to see it live, and I am glad I saw it live for the first time in this production; Anne Bogart's ideas were clear and, for the most part, fully realized in a way that was visually stunning and unusually clear. Pairing it with the Alma Mahler songs brought a new dimension to both works, and I for one can't wait to get to know the songs a little better after seeing how they paired together here.